/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.db.OPartitionedDatabasePool;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Features;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientConfigurableGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientEdgeType;
import com.tinkerpop.blueprints.impls.orient.OrientTransactionalGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import org.apache.commons.configuration.Configuration;

public class OrientGraph
extends OrientTransactionalGraph {
    private boolean featuresInitialized = false;
    protected final Features FEATURES = new Features();

    public OrientGraph(ODatabaseDocumentTx iDatabase, String iUserName, String iUserPasswd) {
        super(iDatabase, true, iUserName, iUserPasswd);
    }

    public OrientGraph(ODatabaseDocumentTx iDatabase, boolean iAutoStartTx) {
        super(iDatabase, iAutoStartTx, null, null);
    }

    public OrientGraph(String url) {
        super(url, "admin", "admin");
    }

    public OrientGraph(String url, boolean iAutoStartTx) {
        super(url, "admin", "admin", iAutoStartTx);
    }

    public OrientGraph(String url, String username, String password) {
        super(url, username, password);
    }

    public OrientGraph(String url, String username, String password, boolean iAutoStartTx) {
        super(url, username, password, iAutoStartTx);
    }

    public OrientGraph(OPartitionedDatabasePool pool) {
        super(pool);
    }

    public OrientGraph(OPartitionedDatabasePool pool, OrientConfigurableGraph.Settings configuration) {
        super(pool, configuration);
    }

    public OrientGraph(Configuration iConfiguration) {
        super(iConfiguration);
    }

    public OrientGraph(ODatabaseDocumentTx iDatabase) {
        super(iDatabase);
    }

    public OrientGraph(ODatabaseDocumentTx iDatabase, String iUser, String iPassword, OrientConfigurableGraph.Settings iConfiguration) {
        super(iDatabase, iUser, iPassword, iConfiguration);
    }

    @Override
    public Features getFeatures() {
        this.makeActive();
        if (!this.featuresInitialized) {
            this.FEATURES.supportsDuplicateEdges = true;
            this.FEATURES.supportsSelfLoops = true;
            this.FEATURES.isPersistent = true;
            this.FEATURES.supportsVertexIteration = true;
            this.FEATURES.supportsVertexIndex = true;
            this.FEATURES.ignoresSuppliedIds = true;
            this.FEATURES.supportsTransactions = true;
            this.FEATURES.supportsVertexKeyIndex = true;
            this.FEATURES.supportsKeyIndices = true;
            this.FEATURES.isWrapper = false;
            this.FEATURES.supportsIndices = true;
            this.FEATURES.supportsVertexProperties = true;
            this.FEATURES.supportsEdgeProperties = true;
            this.FEATURES.supportsSerializableObjectProperty = true;
            this.FEATURES.supportsBooleanProperty = true;
            this.FEATURES.supportsDoubleProperty = true;
            this.FEATURES.supportsFloatProperty = true;
            this.FEATURES.supportsIntegerProperty = true;
            this.FEATURES.supportsPrimitiveArrayProperty = true;
            this.FEATURES.supportsUniformListProperty = true;
            this.FEATURES.supportsMixedListProperty = true;
            this.FEATURES.supportsLongProperty = true;
            this.FEATURES.supportsMapProperty = true;
            this.FEATURES.supportsStringProperty = true;
            this.FEATURES.supportsThreadedTransactions = false;
            this.FEATURES.supportsThreadIsolatedTransactions = false;
            this.FEATURES.supportsEdgeIndex = !this.isUseLightweightEdges();
            this.FEATURES.supportsEdgeKeyIndex = !this.isUseLightweightEdges();
            this.FEATURES.supportsEdgeIteration = !this.isUseLightweightEdges();
            this.FEATURES.supportsEdgeRetrieval = !this.isUseLightweightEdges();
            this.featuresInitialized = true;
        }
        return this.FEATURES;
    }

    @Override
    OrientEdge addEdgeInternal(OrientVertex currentVertex, String label, OrientVertex inVertex, String iClassName, String iClusterName, Object ... fields) {
        OIdentifiable to;
        OIdentifiable from;
        if (currentVertex.checkDeletedInTx()) {
            throw new ORecordNotFoundException("The vertex " + currentVertex.getIdentity() + " has been deleted");
        }
        if (inVertex.checkDeletedInTx()) {
            throw new ORecordNotFoundException("The vertex " + inVertex.getIdentity() + " has been deleted");
        }
        this.autoStartTransaction();
        ODocument outDocument = currentVertex.getRecord();
        if (outDocument == null) {
            throw new IllegalArgumentException("source vertex is invalid (rid=" + currentVertex.getIdentity() + ")");
        }
        if (!ODocumentInternal.getImmutableSchemaClass(outDocument).isVertexType()) {
            throw new IllegalArgumentException("source record is not a vertex");
        }
        ODocument inDocument = inVertex.getRecord();
        if (inDocument == null) {
            throw new IllegalArgumentException("destination vertex is invalid (rid=" + inVertex.getIdentity() + ")");
        }
        if (!ODocumentInternal.getImmutableSchemaClass(outDocument).isVertexType()) {
            throw new IllegalArgumentException("destination record is not a vertex");
        }
        if ((label = OrientBaseGraph.encodeClassName(label)) == null && iClassName != null) {
            label = OrientBaseGraph.encodeClassName(iClassName);
        }
        if (this.isUseClassForEdgeLabel()) {
            OrientEdgeType edgeType = this.getEdgeType(label);
            if (edgeType == null) {
                this.createEdgeType(label);
            } else {
                label = edgeType.getName();
            }
        }
        String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, label, this.settings.isUseVertexFieldsForEdgeLabels());
        String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, label, this.settings.isUseVertexFieldsForEdgeLabels());
        if (label == null) {
            throw ExceptionFactory.edgeLabelCanNotBeNull();
        }
        OrientEdge edge = null;
        if (currentVertex.canCreateDynamicEdge(outDocument, inDocument, outFieldName, inFieldName, fields, label)) {
            from = currentVertex.rawElement;
            to = inDocument;
            if (edge == null) {
                edge = this.settings.isKeepInMemoryReferences() ? new OrientEdge((OrientBaseGraph)this, from.getIdentity(), to.getIdentity(), label) : new OrientEdge((OrientBaseGraph)this, from, to, label);
            }
        } else {
            if (edge == null) {
                edge = new OrientEdge((OrientBaseGraph)this, label, fields);
                if (this.settings.isKeepInMemoryReferences()) {
                    edge.getRecord().fields("out", currentVertex.rawElement.getIdentity(), "in", inDocument.getIdentity());
                } else {
                    edge.getRecord().fields("out", currentVertex.rawElement, "in", inDocument);
                }
            }
            from = edge.getRecord();
            to = edge.getRecord();
        }
        if (this.settings.isKeepInMemoryReferences()) {
            from = from.getIdentity();
            to = to.getIdentity();
        }
        edge.save(iClusterName);
        OrientVertex.createLink(this, outDocument, to, outFieldName);
        OrientVertex.createLink(this, inDocument, from, inFieldName);
        outDocument.save();
        inDocument.save();
        return edge;
    }

    @Override
    public void removeEdgeInternal(OrientEdge edge) {
        OIdentifiable inVertexEdge = edge.vIn != null ? edge.vIn : edge.rawElement;
        String edgeClassName = OrientBaseGraph.encodeClassName(edge.getLabel());
        boolean useVertexFieldsForEdgeLabels = this.settings.isUseVertexFieldsForEdgeLabels();
        OIdentifiable outVertex = edge.getOutVertex();
        ODocument outVertexRecord = null;
        boolean outVertexChanged = false;
        if (outVertex != null) {
            if (outVertex != null) {
                outVertexRecord = (ODocument)outVertex.getRecord();
                String outFieldName = OrientVertex.getConnectionFieldName(Direction.OUT, edgeClassName, useVertexFieldsForEdgeLabels);
                outVertexChanged = edge.dropEdgeFromVertex(inVertexEdge, outVertexRecord, outFieldName, outVertexRecord.field(outFieldName));
            } else {
                OLogManager.instance().debug((Object)this, "Found broken link to outgoing vertex " + outVertex.getIdentity() + " while removing edge " + edge.getId(), new Object[0]);
            }
        }
        OIdentifiable outVertexEdge = edge.vOut != null ? edge.vOut : edge.rawElement;
        OIdentifiable inVertex = edge.getInVertex();
        ODocument inVertexRecord = null;
        boolean inVertexChanged = false;
        if (inVertex != null) {
            inVertexRecord = (ODocument)inVertex.getRecord();
            if (inVertexRecord != null) {
                String inFieldName = OrientVertex.getConnectionFieldName(Direction.IN, edgeClassName, useVertexFieldsForEdgeLabels);
                inVertexChanged = edge.dropEdgeFromVertex(outVertexEdge, inVertexRecord, inFieldName, inVertexRecord.field(inFieldName));
            } else {
                OLogManager.instance().debug((Object)this, "Found broken link to incoming vertex " + inVertex.getIdentity() + " while removing edge " + edge.getId(), new Object[0]);
            }
        }
        if (outVertexChanged) {
            outVertexRecord.save();
        }
        if (inVertexChanged) {
            inVertexRecord.save();
        }
        if (edge.rawElement != null) {
            edge.removeRecord();
        }
    }

    @Override
    void removeEdgesInternal(OrientVertex vertex, ODocument iVertex, OIdentifiable iVertexToRemove, boolean iAlsoInverse, boolean useVertexFieldsForEdgeLabels, boolean autoScaleEdgeType) {
        for (String fieldName : iVertex.fieldNames()) {
            OPair<Direction, String> connection = vertex.getConnection(Direction.BOTH, fieldName, new String[0]);
            if (connection == null) continue;
            OrientGraph.removeEdges(this, iVertex, fieldName, iVertexToRemove, iAlsoInverse, useVertexFieldsForEdgeLabels, autoScaleEdgeType, false);
        }
    }
}

