/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints;

import com.tinkerpop.blueprints.Graph;
import java.io.File;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.configuration.PropertiesConfiguration;

public class GraphFactory {
    public static Graph open(Configuration configuration) {
        Graph g;
        Class<?> graphClass;
        String clazz = configuration.getString("blueprints.graph", null);
        if (clazz == null) {
            throw new RuntimeException("Configuration must contain a valid 'blueprints.graph' setting");
        }
        try {
            graphClass = Class.forName(clazz);
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(String.format("GraphFactory could not find [%s].  Ensure that the jar is in the classpath.", clazz));
        }
        try {
            g = Graph.class.isAssignableFrom(graphClass) ? (Graph)graphClass.getConstructor(Configuration.class).newInstance(configuration) : (Graph)graphClass.getMethod("open", Configuration.class).invoke(null, configuration);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(String.format("GraphFactory can only instantiate Graph implementations that have a constructor with a single Apache Commons Configuration argument. [%s] does not seem to have one.", clazz));
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("GraphFactory could not instantiate this Graph implementation [%s].", clazz), ex);
        }
        return g;
    }

    public static Graph open(String configurationFile) {
        return GraphFactory.open(GraphFactory.getConfiguration(new File(configurationFile)));
    }

    public static Graph open(Map configuration) {
        return GraphFactory.open(new MapConfiguration(configuration));
    }

    private static final Configuration getConfiguration(File dirOrFile) {
        if (dirOrFile == null) {
            throw new IllegalArgumentException("Need to specify a configuration file or storage directory");
        }
        if (!dirOrFile.isFile()) {
            throw new IllegalArgumentException("Location of configuration must be a file");
        }
        try {
            return new PropertiesConfiguration(dirOrFile);
        }
        catch (ConfigurationException e) {
            throw new IllegalArgumentException("Could not load configuration at: " + dirOrFile, e);
        }
    }
}

