/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.delete;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;

public class OServerCommandDeleteDocument
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"DELETE|document/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        ODatabaseDocumentTx db = null;
        try {
            String[] urlParts = this.checkSyntax(iRequest.url, 3, "Syntax error: document/<database>/<record-id>");
            iRequest.data.commandInfo = "Delete document";
            db = this.getProfiledDatabaseInstance(iRequest);
            int parametersPos = urlParts[2].indexOf(63);
            String rid = parametersPos > -1 ? urlParts[2].substring(0, parametersPos) : urlParts[2];
            ORecordId recordId = new ORecordId(rid);
            if (!recordId.isValid()) {
                throw new IllegalArgumentException("Invalid Record ID in request: " + urlParts[2]);
            }
            ODocument doc = new ODocument(recordId);
            if (iRequest.content != null) {
                doc.fromJSON(iRequest.content);
            } else if (iRequest.ifMatch != null) {
                doc.getRecordVersion().getSerializer().fromString(iRequest.ifMatch, doc.getRecordVersion());
            } else {
                doc.getRecordVersion().disable();
            }
            OClass cls = doc.getSchemaClass();
            if (cls != null) {
                if (cls.isSubClassOf("V")) {
                    db.command(new OCommandSQL("DELETE VERTEX " + recordId)).execute(new Object[0]);
                } else if (cls.isSubClassOf("E")) {
                    db.command(new OCommandSQL("DELETE EDGE " + recordId)).execute(new Object[0]);
                } else {
                    doc.delete();
                }
            } else {
                doc.delete();
            }
            iResponse.send(204, "OK", "text/plain", null, null);
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

