/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.distributed.task;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.distributed.task.OAbstractRemoteTask;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class OReadRecordIfNotLatestTask
extends OAbstractRemoteTask {
    private static final long serialVersionUID = 1L;
    protected ORecordId rid;
    protected ORecordVersion recordVersion;

    public OReadRecordIfNotLatestTask() {
    }

    public OReadRecordIfNotLatestTask(ORecordId iRid, ORecordVersion recordVersion) {
        this.rid = iRid;
        this.recordVersion = recordVersion;
    }

    @Override
    public Object execute(OServer iServer, ODistributedServerManager iManager, ODatabaseDocumentTx database) throws Exception {
        Object record = database.loadIfVersionIsNotLatest(this.rid, this.recordVersion, null, true);
        if (record == null) {
            return null;
        }
        return new ORawBuffer((ORecord)record);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.rid.toString());
        this.recordVersion.getSerializer().writeTo(out, this.recordVersion);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rid = new ORecordId(in.readUTF());
        this.recordVersion = OVersionFactory.instance().createVersion();
        this.recordVersion.getSerializer().readFrom(in, this.recordVersion);
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.READ;
    }

    @Override
    public String getName() {
        return "record_read_if_not_latest";
    }

    @Override
    public boolean isIdempotent() {
        return true;
    }
}

