/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.jpa;

import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.object.jpa.OJPAEntityManagerFactory;
import com.orientechnologies.orient.object.jpa.OJPAProperties;
import com.orientechnologies.orient.object.jpa.OJPAProviderUtil;
import com.orientechnologies.orient.object.jpa.parsing.PersistenceXmlUtil;
import java.net.URL;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;

public class OJPAPersistenceProvider
implements PersistenceProvider {
    private static Logger logger = Logger.getLogger(OJPAPersistenceProvider.class.getName());
    private static OJPAProviderUtil providerUtil = new OJPAProviderUtil();
    private Collection<? extends PersistenceUnitInfo> persistenceUnits = null;

    public OJPAPersistenceProvider() {
        URL persistenceXml = Thread.currentThread().getContextClassLoader().getResource("META-INF/persistence.xml");
        if (persistenceXml != null) {
            try {
                this.persistenceUnits = PersistenceXmlUtil.parse(persistenceXml);
            }
            catch (Exception e) {
                logger.info("Can't parse 'META-INF/persistence.xml' :" + e.getMessage());
            }
        }
    }

    @Override
    public synchronized EntityManagerFactory createEntityManagerFactory(String emName, Map map) {
        if (emName == null) {
            throw new IllegalStateException("Name of the persistence unit should not be null");
        }
        PersistenceUnitInfo unitInfo = PersistenceXmlUtil.findPersistenceUnit(emName, this.persistenceUnits);
        return this.createContainerEntityManagerFactory(unitInfo, map);
    }

    @Override
    public synchronized EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        OJPAProperties properties;
        OJPAProperties oJPAProperties = properties = info == null ? new OJPAProperties() : (OJPAProperties)info.getProperties();
        if (map != null && !map.isEmpty()) {
            properties.putAll((Map<?, ?>)map);
        }
        OEntityManager entityManager = OEntityManager.getEntityManagerByDatabaseURL(properties.getURL());
        entityManager.registerEntityClasses((Collection<String>)info.getManagedClassNames());
        return new OJPAEntityManagerFactory(properties);
    }

    @Override
    public ProviderUtil getProviderUtil() {
        return providerUtil;
    }
}

