/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.iterator;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.iterator.object.OObjectIteratorClusterInterface;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.object.db.OObjectDatabaseTx;
import java.util.Iterator;

public class OObjectIteratorCluster<T>
implements OObjectIteratorClusterInterface<T> {
    private ODatabaseObject database;
    private ORecordIteratorCluster<ODocument> underlying;
    private String fetchPlan;

    public OObjectIteratorCluster(OObjectDatabaseTx iDatabase, ODatabaseDocumentTx iUnderlyingDatabase, int iClusterId) {
        this.database = iDatabase;
        this.underlying = new ORecordIteratorCluster(iDatabase.getUnderlying(), iUnderlyingDatabase, iClusterId);
    }

    @Override
    public boolean hasNext() {
        return this.underlying.hasNext();
    }

    @Override
    public T next() {
        return this.next(this.fetchPlan);
    }

    public T next(String iFetchPlan) {
        return (T)this.database.getUserObjectByRecord((OIdentifiable)this.underlying.next(), iFetchPlan);
    }

    @Override
    public void remove() {
        this.underlying.remove();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }

    public String getFetchPlan() {
        return this.fetchPlan;
    }

    public OObjectIteratorCluster<T> setFetchPlan(String fetchPlan) {
        this.fetchPlan = fetchPlan;
        return this;
    }
}

