/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.enhancement;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.reflection.OReflectionHelper;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.object.OObjectLazyMultivalueElement;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.db.record.ORecordLazySet;
import com.orientechnologies.orient.core.db.record.OTrackedList;
import com.orientechnologies.orient.core.db.record.OTrackedMap;
import com.orientechnologies.orient.core.db.record.OTrackedSet;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.core.version.OVersionFactory;
import com.orientechnologies.orient.object.db.OObjectLazyList;
import com.orientechnologies.orient.object.db.OObjectLazyMap;
import com.orientechnologies.orient.object.db.OObjectLazySet;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectMethodFilter;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyList;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazyMap;
import com.orientechnologies.orient.object.enumerations.OObjectEnumLazySet;
import com.orientechnologies.orient.object.enumerations.OObjectLazyEnumSerializer;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerList;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerMap;
import com.orientechnologies.orient.object.serialization.OObjectCustomSerializerSet;
import com.orientechnologies.orient.object.serialization.OObjectLazyCustomSerializer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public class OObjectProxyMethodHandler
implements MethodHandler {
    protected final Map<String, ORecordVersion> loadedFields;
    protected final Set<ORID> orphans = new HashSet<ORID>();
    protected ODocument doc;
    protected ProxyObject parentObject;

    public OObjectProxyMethodHandler(ODocument iDocument) {
        this.doc = iDocument;
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (db.getDatabaseOwner() instanceof ODatabaseObject && !((ODatabaseObject)((Object)db.getDatabaseOwner())).isLazyLoading()) {
            this.doc.detach();
        }
        this.loadedFields = new HashMap<String, ORecordVersion>();
    }

    public ODocument getDoc() {
        return this.doc;
    }

    public void setDoc(ODocument iDoc) {
        this.doc = iDoc;
    }

    public ProxyObject getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(ProxyObject parentDoc) {
        this.parentObject = parentDoc;
    }

    public Set<ORID> getOrphans() {
        return this.orphans;
    }

    @Override
    public Object invoke(Object self, Method m, Method proceed, Object[] args) throws Throwable {
        OObjectMethodFilter filter = OObjectEntityEnhancer.getInstance().getMethodFilter(self.getClass());
        if (filter.isSetterMethod(m)) {
            return this.manageSetMethod(self, m, proceed, args);
        }
        if (filter.isGetterMethod(m)) {
            return this.manageGetMethod(self, m, proceed, args);
        }
        return proceed.invoke(self, args);
    }

    public void detach(Object self, boolean nonProxiedInstance) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> selfClass = self.getClass();
        for (String fieldName : this.doc.fieldNames()) {
            Object value = this.getValue(self, fieldName, false, null, true);
            if (value instanceof OObjectLazyMultivalueElement) {
                ((OObjectLazyMultivalueElement)value).detach(nonProxiedInstance);
                if (nonProxiedInstance) {
                    value = ((OObjectLazyMultivalueElement)value).getNonOrientInstance();
                }
            }
            OObjectEntitySerializer.setFieldValue(OObjectEntitySerializer.getField(fieldName, selfClass), self, value);
        }
        OObjectEntitySerializer.setIdField(selfClass, self, this.doc.getIdentity());
        OObjectEntitySerializer.setVersionField(selfClass, self, this.doc.getRecordVersion().copy());
    }

    public void detachAll(Object self, boolean nonProxiedInstance, Map<Object, Object> alreadyDetached) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> selfClass = self.getClass();
        for (String fieldName : this.doc.fieldNames()) {
            Field field = OObjectEntitySerializer.getField(fieldName, selfClass);
            if (field == null) continue;
            Object value = this.getValue(self, fieldName, false, null, true);
            if (value instanceof OObjectLazyMultivalueElement) {
                ((OObjectLazyMultivalueElement)value).detachAll(nonProxiedInstance, alreadyDetached);
                if (nonProxiedInstance) {
                    value = ((OObjectLazyMultivalueElement)value).getNonOrientInstance();
                }
            } else if (value instanceof Proxy) {
                Object detachedValue;
                OObjectProxyMethodHandler handler = (OObjectProxyMethodHandler)((ProxyObject)value).getHandler();
                if (nonProxiedInstance) {
                    value = OObjectEntitySerializer.getNonProxiedInstance(value);
                }
                if ((detachedValue = alreadyDetached.get(handler.doc.getIdentity())) != null) {
                    value = detachedValue;
                } else {
                    alreadyDetached.put(handler.doc.getIdentity(), value);
                    handler.detachAll(value, nonProxiedInstance, alreadyDetached);
                }
            }
            OObjectEntitySerializer.setFieldValue(field, self, value);
        }
        OObjectEntitySerializer.setIdField(selfClass, self, this.doc.getIdentity());
        OObjectEntitySerializer.setVersionField(selfClass, self, this.doc.getRecordVersion().copy());
    }

    public void attach(Object self) throws IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<Object> currentClass = self.getClass();
        while (currentClass != Object.class) {
            if (Proxy.class.isAssignableFrom(currentClass)) {
                currentClass = currentClass.getSuperclass();
                continue;
            }
            for (Field f : currentClass.getDeclaredFields()) {
                String fieldName = f.getName();
                Class<?> declaringClass = f.getDeclaringClass();
                if (OObjectEntitySerializer.isTransientField(declaringClass, fieldName) || OObjectEntitySerializer.isVersionField(declaringClass, fieldName) || OObjectEntitySerializer.isIdField(declaringClass, fieldName)) continue;
                Object value = OObjectEntitySerializer.getFieldValue(f, self);
                value = this.setValue(self, fieldName, value);
                OObjectEntitySerializer.setFieldValue(f, self, value);
            }
            if ((currentClass = currentClass.getSuperclass()) != null && !currentClass.equals(ODocument.class)) continue;
            currentClass = Object.class;
        }
    }

    public void setDirty() {
        this.doc.setDirty();
        if (this.parentObject != null) {
            ((OObjectProxyMethodHandler)this.parentObject.getHandler()).setDirty();
        }
    }

    public void updateLoadedFieldMap(Object proxiedObject, boolean iReload) {
        HashSet<String> fields = new HashSet<String>(this.loadedFields.keySet());
        for (String fieldName : fields) {
            try {
                if (iReload) {
                    Field fieldToReset = OObjectEntitySerializer.getField(fieldName, proxiedObject.getClass());
                    OObjectEntitySerializer.setFieldValue(fieldToReset, proxiedObject, this.getDefaultValueForField(fieldToReset));
                    continue;
                }
                Object value = this.getValue(proxiedObject, fieldName, false, null);
                if (value instanceof OObjectLazyMultivalueElement) {
                    if (((OObjectLazyMultivalueElement)value).getUnderlying() == this.doc.field(fieldName)) continue;
                    this.loadedFields.remove(fieldName);
                    continue;
                }
                this.loadedFields.put(fieldName, this.doc.getRecordVersion().copy());
            }
            catch (IllegalArgumentException e) {
                throw new OSerializationException("Error updating object after save of class " + proxiedObject.getClass(), e);
            }
            catch (IllegalAccessException e) {
                throw new OSerializationException("Error updating object after save of class " + proxiedObject.getClass(), e);
            }
            catch (NoSuchMethodException e) {
                throw new OSerializationException("Error updating object after save of class " + proxiedObject.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new OSerializationException("Error updating object after save of class " + proxiedObject.getClass(), e);
            }
        }
        if (iReload) {
            this.loadedFields.clear();
        }
    }

    protected Object manageGetMethod(Object self, Method m, Method proceed, Object[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, SecurityException, IllegalArgumentException, NoSuchFieldException {
        boolean idOrVersionField;
        String fieldName = OObjectEntityEnhancer.getInstance().getMethodFilter(self.getClass()).getFieldName(m);
        ORID docRID = this.doc.getIdentity();
        if (OObjectEntitySerializer.isIdField(m.getDeclaringClass(), fieldName)) {
            idOrVersionField = true;
            OObjectEntitySerializer.setIdField(m.getDeclaringClass(), self, docRID);
        } else if (OObjectEntitySerializer.isVersionField(m.getDeclaringClass(), fieldName)) {
            idOrVersionField = true;
            if (docRID.isValid() && !docRID.isTemporary()) {
                OObjectEntitySerializer.setVersionField(m.getDeclaringClass(), self, this.doc.getRecordVersion().copy());
            }
        } else {
            idOrVersionField = false;
        }
        Object value = proceed.invoke(self, args);
        value = this.getValue(self, fieldName, idOrVersionField, value);
        if (docRID.isValid() && !docRID.isTemporary()) {
            this.loadedFields.put(fieldName, this.doc.getRecordVersion().copy());
        } else {
            this.loadedFields.put(fieldName, OVersionFactory.instance().createVersion());
        }
        return value;
    }

    protected Object getValue(Object self, String fieldName, boolean idOrVersionField, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.getValue(self, fieldName, idOrVersionField, value, false);
    }

    protected Object getValue(Object self, String fieldName, boolean idOrVersionField, Object value, boolean iIgnoreLoadedFields) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (!idOrVersionField) {
            Object docValue;
            if (value == null) {
                if (!iIgnoreLoadedFields && this.loadedFields.containsKey(fieldName) && this.loadedFields.get(fieldName).compareTo(this.doc.getRecordVersion()) == 0) {
                    return null;
                }
                Object docValue2 = this.getDocFieldValue(self, fieldName);
                if (docValue2 != null) {
                    value = this.lazyLoadField(self, fieldName, docValue2, value);
                }
            } else if ((value instanceof Collection || value instanceof Map) && !(value instanceof OObjectLazyMultivalueElement) || value.getClass().isArray()) {
                Class<?> genericMultiValueType = OReflectionHelper.getGenericMultivalueType(OObjectEntitySerializer.getField(fieldName, self.getClass()));
                if (genericMultiValueType == null || !OReflectionHelper.isJavaType(genericMultiValueType)) {
                    Field f = OObjectEntitySerializer.getField(fieldName, self.getClass());
                    value = OObjectEntitySerializer.isSerializedType(f) && !(value instanceof OObjectLazyCustomSerializer) ? this.manageSerializedCollections(self, fieldName, value) : (genericMultiValueType != null && genericMultiValueType.isEnum() && !(value instanceof OObjectLazyEnumSerializer) ? this.manageEnumCollections(self, f.getName(), genericMultiValueType, value) : this.manageObjectCollections(self, fieldName, value));
                } else {
                    Object docValue3 = this.getDocFieldValue(self, fieldName);
                    if (docValue3 == null) {
                        if (value.getClass().isArray()) {
                            OClass schemaClass = this.doc.getSchemaClass();
                            OProperty schemaProperty = null;
                            if (schemaClass != null) {
                                schemaProperty = schemaClass.getProperty(fieldName);
                            }
                            this.doc.field(fieldName, OObjectEntitySerializer.typeToStream(value, schemaProperty != null ? schemaProperty.getType() : null, this.getDatabase(), this.doc));
                        } else {
                            this.doc.field(fieldName, value);
                        }
                    } else if (!this.loadedFields.containsKey(fieldName)) {
                        value = this.manageArrayFieldObject(OObjectEntitySerializer.getField(fieldName, self.getClass()), self, docValue3);
                        Method setMethod = this.getSetMethod(self.getClass().getSuperclass(), this.getSetterFieldName(fieldName), value);
                        setMethod.invoke(self, value);
                    } else if ((value instanceof Set || value instanceof Map) && this.loadedFields.get(fieldName).compareTo(this.doc.getRecordVersion()) < 0 && !OReflectionHelper.isJavaType(genericMultiValueType)) {
                        value = value instanceof Set ? new OObjectLazySet(self, (Set)docValue3, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), fieldName)) : new OObjectLazyMap(self, (Map)docValue3, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), fieldName));
                        Method setMethod = this.getSetMethod(self.getClass().getSuperclass(), this.getSetterFieldName(fieldName), value);
                        setMethod.invoke(self, value);
                    }
                }
            } else if (!(this.loadedFields.containsKey(fieldName) && this.loadedFields.get(fieldName).compareTo(this.doc.getRecordVersion()) >= 0 || (docValue = this.getDocFieldValue(self, fieldName)) == null || docValue.equals(value))) {
                value = this.lazyLoadField(self, fieldName, docValue, value);
            }
        }
        return value;
    }

    protected Object getDocFieldValue(Object self, String fieldName) {
        OClass cls = this.doc.getSchemaClass();
        if (cls != null && cls.existsProperty(fieldName)) {
            return this.doc.field(fieldName);
        }
        OType expected = OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName);
        if (this.doc.fieldType(fieldName) != expected) {
            this.doc.field(fieldName, this.doc.field(fieldName), expected);
        }
        return this.doc.field(fieldName);
    }

    protected Object setDocFieldValue(String fieldName, Object value, OType type) {
        if (this.doc.getSchemaClass().existsProperty(fieldName)) {
            return this.doc.field(fieldName, value);
        }
        return this.doc.field(fieldName, value, type);
    }

    protected Object manageObjectCollections(Object self, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean customSerialization = false;
        Field f = OObjectEntitySerializer.getField(fieldName, self.getClass());
        if (OObjectEntitySerializer.isSerializedType(f)) {
            customSerialization = true;
        }
        if (value instanceof Collection) {
            value = this.manageCollectionSave(self, f, (Collection)value, customSerialization, false);
        } else if (value instanceof Map) {
            value = this.manageMapSave(self, f, (Map)value, customSerialization);
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(OObjectEntitySerializer.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageSerializedCollections(Object self, String fieldName, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (value instanceof Collection) {
            if (value instanceof List) {
                ArrayList<Object> docList = (ArrayList<Object>)this.doc.field(fieldName, OType.EMBEDDEDLIST);
                if (docList == null) {
                    docList = new ArrayList<Object>();
                    this.setDocFieldValue(fieldName, docList, OType.EMBEDDEDLIST);
                }
                value = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(OObjectEntitySerializer.getField(fieldName, self.getClass())), this.doc, (List<Object>)docList, value);
            } else if (value instanceof Set) {
                HashSet<Object> docSet = (HashSet<Object>)this.doc.field(fieldName, OType.EMBEDDEDSET);
                if (docSet == null) {
                    docSet = new HashSet<Object>();
                    this.setDocFieldValue(fieldName, docSet, OType.EMBEDDEDSET);
                }
                value = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(OObjectEntitySerializer.getField(fieldName, self.getClass())), this.doc, docSet, (Set)((Object)value));
            }
        } else if (value instanceof Map) {
            HashMap<Object, Object> docMap = (HashMap<Object, Object>)this.doc.field(fieldName, OType.EMBEDDEDMAP);
            if (docMap == null) {
                docMap = new HashMap<Object, Object>();
                this.setDocFieldValue(fieldName, docMap, OType.EMBEDDEDMAP);
            }
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(OObjectEntitySerializer.getField(fieldName, self.getClass())), this.doc, docMap, (Map)((Object)value));
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(OObjectEntitySerializer.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageEnumCollections(Object self, String fieldName, Class<?> enumClass, Object value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (value instanceof Collection) {
            if (value instanceof List) {
                ArrayList<Object> docList = (ArrayList<Object>)this.doc.field(fieldName, OType.EMBEDDEDLIST);
                if (docList == null) {
                    docList = new ArrayList<Object>();
                    this.setDocFieldValue(fieldName, docList, OType.EMBEDDEDLIST);
                }
                value = new OObjectEnumLazyList(enumClass, this.doc, (List<Object>)docList, value);
            } else if (value instanceof Set) {
                HashSet<Object> docSet = (HashSet<Object>)this.doc.field(fieldName, OType.EMBEDDEDSET);
                if (docSet == null) {
                    docSet = new HashSet<Object>();
                    this.setDocFieldValue(fieldName, docSet, OType.EMBEDDEDSET);
                }
                value = new OObjectEnumLazySet(enumClass, this.doc, docSet, (Set)((Object)value));
            }
        } else if (value instanceof Map) {
            HashMap<Object, Object> docMap = (HashMap<Object, Object>)this.doc.field(fieldName, OType.EMBEDDEDMAP);
            if (docMap == null) {
                docMap = new HashMap<Object, Object>();
                this.setDocFieldValue(fieldName, docMap, OType.EMBEDDEDMAP);
            }
            value = new OObjectEnumLazyMap(enumClass, this.doc, docMap, (Map)((Object)value));
        } else if (value.getClass().isArray()) {
            value = this.manageArraySave(fieldName, (Object[])value);
        }
        OObjectEntitySerializer.setFieldValue(OObjectEntitySerializer.getField(fieldName, self.getClass()), self, value);
        return value;
    }

    protected Object manageArraySave(String iFieldName, Object[] value) {
        Object o;
        if (value.length > 0 && ((o = value[0]) instanceof Proxy || o.getClass().isEnum())) {
            Object[] newValue = new Object[value.length];
            this.convertArray(value, newValue, o.getClass().isEnum());
            this.doc.field(iFieldName, newValue);
        }
        return value;
    }

    protected void convertArray(Object[] value, Object[] newValue, boolean isEnum) {
        for (int i = 0; i < value.length; ++i) {
            newValue[i] = isEnum ? (value[i] != null ? ((Enum)value[i]).name() : null) : (value[i] != null ? OObjectEntitySerializer.getDocument((Proxy)value[i]) : null);
        }
    }

    protected Object manageMapSave(Object self, Field f, Map<?, ?> value, boolean customSerialization) {
        Class<Enum> genericType = OReflectionHelper.getGenericMultivalueType(f);
        if (customSerialization) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            this.setDocFieldValue(f.getName(), map, OType.EMBEDDEDMAP);
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), this.doc, map, value);
        } else if (genericType != null && genericType.isEnum()) {
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            this.setDocFieldValue(f.getName(), map, OType.EMBEDDEDMAP);
            value = new OObjectEnumLazyMap(genericType, this.doc, map, value);
        } else if (!(value instanceof OObjectLazyMultivalueElement)) {
            ORecordLazyMap docMap;
            OType type;
            OType oType = type = OObjectEntitySerializer.isEmbeddedField(self.getClass(), f.getName()) ? OType.EMBEDDEDMAP : OType.LINKMAP;
            if (this.doc.fieldType(f.getName()) != type) {
                this.doc.field(f.getName(), this.doc.field(f.getName()), type);
            }
            if ((docMap = (ORecordLazyMap)this.doc.field(f.getName(), type)) == null) {
                docMap = OType.EMBEDDEDMAP == type ? new OTrackedMap(this.doc) : new ORecordLazyMap(this.doc);
                this.setDocFieldValue(f.getName(), docMap, type);
            }
            value = new OObjectLazyMap(self, docMap, value, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), f.getName()));
        }
        return value;
    }

    protected Object manageCollectionSave(Object self, Field f, Collection<?> value, boolean customSerialization, boolean isFieldUpdate) {
        Class<Enum> genericType = OReflectionHelper.getGenericMultivalueType(f);
        if (customSerialization) {
            if (value instanceof List) {
                ArrayList list = new ArrayList();
                this.setDocFieldValue(f.getName(), list, OType.EMBEDDEDLIST);
                value = new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), this.doc, new ArrayList<Object>(), (List)value);
            } else {
                HashSet<Object> set = new HashSet<Object>();
                this.setDocFieldValue(f.getName(), set, OType.EMBEDDEDSET);
                value = new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), this.doc, set, (Set)value);
            }
        } else if (genericType != null && genericType.isEnum()) {
            if (value instanceof List) {
                ArrayList<Object> list = new ArrayList<Object>();
                this.setDocFieldValue(f.getName(), list, OType.EMBEDDEDLIST);
                value = new OObjectEnumLazyList(genericType, this.doc, list, (List)value);
            } else {
                HashSet<Object> set = new HashSet<Object>();
                this.setDocFieldValue(f.getName(), set, OType.EMBEDDEDSET);
                value = new OObjectEnumLazySet(genericType, this.doc, set, (Set)value);
            }
        } else if (!(value instanceof OObjectLazyMultivalueElement)) {
            boolean embedded = OObjectEntitySerializer.isEmbeddedField(self.getClass(), f.getName());
            if (value instanceof List) {
                OType type = embedded ? OType.EMBEDDEDLIST : OType.LINKLIST;
                ORecordLazyList docList = (ORecordLazyList)this.doc.field(f.getName(), type);
                if (docList == null) {
                    docList = embedded ? new OTrackedList(this.doc) : new ORecordLazyList(this.doc);
                    this.setDocFieldValue(f.getName(), docList, type);
                } else if (isFieldUpdate) {
                    docList.clear();
                }
                value = new OObjectLazyList(self, docList, value, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), f.getName()));
            } else if (value instanceof Set) {
                OType type = embedded ? OType.EMBEDDEDSET : OType.LINKSET;
                AbstractCollection docSet = (OTrackedSet<OIdentifiable>)this.doc.field(f.getName(), type);
                if (docSet == null) {
                    docSet = embedded ? new OTrackedSet<OIdentifiable>(this.doc) : new ORecordLazySet(this.doc);
                    this.setDocFieldValue(f.getName(), docSet, type);
                } else if (isFieldUpdate) {
                    docSet.clear();
                }
                value = new OObjectLazySet(self, (Set<OIdentifiable>)((Object)docSet), (Set)value, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), f.getName()));
            }
        }
        if (!((ODatabaseObject)((Object)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner())).isLazyLoading()) {
            ((OObjectLazyMultivalueElement)((Object)value)).detach(false);
        }
        return value;
    }

    protected Object lazyLoadField(Object self, String fieldName, Object docValue, Object currentValue) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        boolean customSerialization = false;
        Field f = OObjectEntitySerializer.getField(fieldName, self.getClass());
        if (f == null) {
            return currentValue;
        }
        if (OObjectEntitySerializer.isSerializedType(f)) {
            customSerialization = true;
        }
        if (docValue instanceof OIdentifiable) {
            if (OIdentifiable.class.isAssignableFrom(f.getType())) {
                if (ORecordAbstract.class.isAssignableFrom(f.getType())) {
                    ORecordAbstract record = (ORecordAbstract)((OIdentifiable)docValue).getRecord();
                    OObjectEntitySerializer.setFieldValue(f, self, record);
                    return record;
                }
                OObjectEntitySerializer.setFieldValue(f, self, docValue);
                return docValue;
            }
            docValue = this.convertDocumentToObject((ODocument)((OIdentifiable)docValue).getRecord(), self);
        } else if (docValue instanceof Collection) {
            docValue = this.manageCollectionLoad(f, self, docValue, customSerialization);
        } else if (docValue instanceof Map) {
            docValue = this.manageMapLoad(f, self, docValue, customSerialization);
        } else if (docValue.getClass().isArray() && !docValue.getClass().getComponentType().isPrimitive()) {
            docValue = this.manageArrayLoad(docValue, f);
        } else if (customSerialization) {
            docValue = OObjectEntitySerializer.deserializeFieldValue(OObjectEntitySerializer.getField(fieldName, self.getClass()).getType(), docValue);
        } else if (f.getType().isEnum()) {
            docValue = docValue instanceof Number ? ((Enum[])f.getType().getEnumConstants())[((Number)docValue).intValue()] : Enum.valueOf(f.getType(), docValue.toString());
        }
        OObjectEntitySerializer.setFieldValue(f, self, docValue);
        return docValue;
    }

    protected Object manageArrayLoad(Object value, Field f) {
        if (((Object[])value).length > 0) {
            Object o = ((Object[])value)[0];
            if (o instanceof OIdentifiable) {
                Object[] newValue = new Object[((Object[])value).length];
                for (int i = 0; i < ((Object[])value).length; ++i) {
                    ODocument doc = (ODocument)((OIdentifiable)((Object[])value)[i]).getRecord();
                    newValue[i] = OObjectEntitySerializer.getDocument((Proxy)((Object)doc));
                }
                value = newValue;
            } else {
                Class<?> genericType = OReflectionHelper.getGenericMultivalueType(f);
                if (genericType != null && genericType.isEnum()) {
                    Object newValue = Array.newInstance(genericType, ((Object[])value).length);
                    for (int i = 0; i < ((Object[])value).length; ++i) {
                        o = value[i];
                        o = o instanceof Number ? genericType.getEnumConstants()[((Number)o).intValue()] : Enum.valueOf(genericType, o.toString());
                        ((Enum[])newValue)[i] = (Enum)o;
                    }
                    value = newValue;
                }
            }
        }
        return value;
    }

    protected Object manageMapLoad(Field f, Object self, Object value, boolean customSerialization) {
        Class<Enum> genericType = OReflectionHelper.getGenericMultivalueType(f);
        if (!(!(value instanceof ORecordLazyMap) && (!(value instanceof OTrackedMap) || genericType != null && OReflectionHelper.isJavaType(genericType) || customSerialization || genericType != null && genericType.isEnum()))) {
            value = new OObjectLazyMap(self, (OTrackedMap)value, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), f.getName()));
        } else if (customSerialization) {
            value = new OObjectCustomSerializerMap(OObjectEntitySerializer.getSerializedType(f), this.doc, value);
        } else if (genericType != null && genericType.isEnum()) {
            value = new OObjectEnumLazyMap(genericType, this.doc, value);
        }
        return value;
    }

    protected Object manageCollectionLoad(Field f, Object self, Object value, boolean customSerialization) {
        Class<Enum> genericType = OReflectionHelper.getGenericMultivalueType(f);
        if (!(!(value instanceof ORecordLazyList) && (!(value instanceof OTrackedList) || genericType != null && OReflectionHelper.isJavaType(genericType) || customSerialization || genericType != null && genericType.isEnum()))) {
            value = new OObjectLazyList(self, (List<OIdentifiable>)value, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), f.getName()));
        } else if (value instanceof ORecordLazySet || value instanceof OMVRBTreeRIDSet || value instanceof OTrackedSet && (genericType == null || !OReflectionHelper.isJavaType(genericType)) && !customSerialization && (genericType == null || !genericType.isEnum())) {
            value = new OObjectLazySet(self, (Set)value, OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), f.getName()));
        } else if (customSerialization) {
            value = value instanceof List ? new OObjectCustomSerializerList(OObjectEntitySerializer.getSerializedType(f), this.doc, (List<Object>)value) : new OObjectCustomSerializerSet(OObjectEntitySerializer.getSerializedType(f), this.doc, (Set)value);
        } else if (genericType != null && genericType.isEnum()) {
            value = value instanceof List ? new OObjectEnumLazyList(genericType, this.doc, (List<Object>)value) : new OObjectEnumLazySet(genericType, this.doc, (Set)value);
        }
        return this.manageArrayFieldObject(f, self, value);
    }

    protected Object manageArrayFieldObject(Field field, Object self, Object value) {
        if (field.getType().isArray()) {
            Collection collectionValue = (Collection)value;
            Object newArray = Array.newInstance(field.getType().getComponentType(), collectionValue.size());
            int i = 0;
            for (Object collectionItem : collectionValue) {
                Array.set(newArray, i, collectionItem);
                ++i;
            }
            return newArray;
        }
        return value;
    }

    protected Object convertDocumentToObject(ODocument value, Object self) {
        if (value == null) {
            return null;
        }
        return OObjectEntityEnhancer.getInstance().getProxiedInstance(value.getClassName(), this.getDatabase().getEntityManager(), value, self instanceof ProxyObject ? (ProxyObject)self : null, new Object[0]);
    }

    protected Object manageSetMethod(Object self, Method m, Method proceed, Object[] args) throws IllegalAccessException, InvocationTargetException {
        String fieldName = OObjectEntityEnhancer.getInstance().getMethodFilter(self.getClass()).getFieldName(m);
        args[0] = this.setValue(self, fieldName, args[0]);
        return proceed.invoke(self, args);
    }

    protected Object setValue(Object self, String fieldName, Object valueToSet) {
        if (valueToSet == null) {
            Object oldValue = this.doc.field(fieldName);
            if (OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), fieldName) && oldValue instanceof OIdentifiable) {
                this.orphans.add(((OIdentifiable)oldValue).getIdentity());
            }
            this.setDocFieldValue(fieldName, valueToSet, OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
        } else if (!valueToSet.getClass().isAnonymousClass()) {
            if (valueToSet instanceof Proxy) {
                ODocument docToSet = OObjectEntitySerializer.getDocument((Proxy)valueToSet);
                if (OObjectEntitySerializer.isEmbeddedField(self.getClass(), fieldName)) {
                    ODocumentInternal.addOwner(docToSet, this.doc);
                }
                Object oldValue = this.doc.field(fieldName);
                if (OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), fieldName) && oldValue instanceof OIdentifiable) {
                    this.orphans.add(((OIdentifiable)oldValue).getIdentity());
                }
                this.setDocFieldValue(fieldName, docToSet, OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
            } else if (valueToSet instanceof OIdentifiable) {
                if (valueToSet instanceof ODocument && OObjectEntitySerializer.isEmbeddedField(self.getClass(), fieldName)) {
                    ODocumentInternal.addOwner((ODocument)valueToSet, this.doc);
                }
                Object oldValue = this.doc.field(fieldName);
                if (OObjectEntitySerializer.isCascadeDeleteField(self.getClass(), fieldName) && oldValue instanceof OIdentifiable) {
                    this.orphans.add(((OIdentifiable)oldValue).getIdentity());
                }
                this.setDocFieldValue(fieldName, valueToSet, OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
            } else if (valueToSet instanceof Collection || valueToSet instanceof Map || valueToSet.getClass().isArray()) {
                Class<?> genericMultiValueType = OReflectionHelper.getGenericMultivalueType(OObjectEntitySerializer.getField(fieldName, self.getClass()));
                if (genericMultiValueType != null && !OReflectionHelper.isJavaType(genericMultiValueType)) {
                    if (!(valueToSet instanceof OObjectLazyMultivalueElement)) {
                        if (valueToSet instanceof Collection) {
                            boolean customSerialization = false;
                            Field f = OObjectEntitySerializer.getField(fieldName, self.getClass());
                            if (OObjectEntitySerializer.isSerializedType(f)) {
                                customSerialization = true;
                            }
                            valueToSet = this.manageCollectionSave(self, f, (Collection)valueToSet, customSerialization, true);
                        } else if (valueToSet instanceof Map) {
                            boolean customSerialization = false;
                            Field f = OObjectEntitySerializer.getField(fieldName, self.getClass());
                            if (OObjectEntitySerializer.isSerializedType(f)) {
                                customSerialization = true;
                            }
                            valueToSet = this.manageMapSave(self, f, (Map)valueToSet, customSerialization);
                        } else if (valueToSet.getClass().isArray()) {
                            valueToSet = this.manageArraySave(fieldName, (Object[])valueToSet);
                        }
                    }
                } else if (OObjectEntitySerializer.isToSerialize(valueToSet.getClass())) {
                    this.setDocFieldValue(fieldName, OObjectEntitySerializer.serializeFieldValue(OObjectEntitySerializer.getField(fieldName, self.getClass()).getType(), valueToSet), OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
                } else if (valueToSet.getClass().isArray()) {
                    OClass schemaClass = this.doc.getSchemaClass();
                    OProperty schemaProperty = null;
                    if (schemaClass != null) {
                        schemaProperty = schemaClass.getProperty(fieldName);
                    }
                    this.setDocFieldValue(fieldName, OObjectEntitySerializer.typeToStream(valueToSet, schemaProperty != null ? schemaProperty.getType() : null, this.getDatabase(), this.doc), OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
                } else {
                    this.setDocFieldValue(fieldName, valueToSet, OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
                }
            } else if (valueToSet.getClass().isEnum()) {
                this.setDocFieldValue(fieldName, ((Enum)valueToSet).name(), OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
            } else if (OObjectEntitySerializer.isToSerialize(valueToSet.getClass())) {
                this.setDocFieldValue(fieldName, OObjectEntitySerializer.serializeFieldValue(OObjectEntitySerializer.getField(fieldName, self.getClass()).getType(), valueToSet), OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
            } else if (this.getDatabase().getEntityManager().getEntityClass(valueToSet.getClass().getSimpleName()) != null && !valueToSet.getClass().isEnum()) {
                valueToSet = OObjectEntitySerializer.serializeObject(valueToSet, this.getDatabase());
                ODocument docToSet = OObjectEntitySerializer.getDocument((Proxy)valueToSet);
                if (OObjectEntitySerializer.isEmbeddedField(self.getClass(), fieldName)) {
                    ODocumentInternal.addOwner(docToSet, this.doc);
                }
                this.setDocFieldValue(fieldName, docToSet, OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
            } else {
                this.setDocFieldValue(fieldName, valueToSet, OObjectEntitySerializer.getTypeByClass(self.getClass(), fieldName));
            }
            this.loadedFields.put(fieldName, this.doc.getRecordVersion().copy());
            this.setDirty();
        } else {
            OLogManager.instance().warn((Object)this, "Setting property '%s' in proxied class '%s' with an anonymous class '%s'. The document won't have this property.", fieldName, self.getClass().getName(), valueToSet.getClass().getName());
        }
        return valueToSet;
    }

    protected String getSetterFieldName(String fieldName) {
        StringBuffer methodName = new StringBuffer("set");
        methodName.append(Character.toUpperCase(fieldName.charAt(0)));
        for (int i = 1; i < fieldName.length(); ++i) {
            methodName.append(fieldName.charAt(i));
        }
        return methodName.toString();
    }

    protected Method getSetMethod(Class<?> iClass, String fieldName, Object value) throws NoSuchMethodException {
        for (Method m : iClass.getDeclaredMethods()) {
            if (!m.getName().equals(fieldName) || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(value.getClass())) continue;
            return m;
        }
        if (iClass.getSuperclass().equals(Object.class)) {
            return null;
        }
        return this.getSetMethod(iClass.getSuperclass(), fieldName, value);
    }

    private ODatabaseObject getDatabase() {
        return (ODatabaseObject)((Object)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner());
    }

    private Object getDefaultValueForField(Field field) {
        if (field.getType() == Byte.TYPE) {
            return Byte.valueOf("0");
        }
        if (field.getType() == Short.TYPE) {
            return Short.valueOf("0");
        }
        if (field.getType() == Integer.TYPE) {
            return 0;
        }
        if (field.getType() == Long.TYPE) {
            return 0L;
        }
        if (field.getType() == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (field.getType() == Double.TYPE) {
            return 0.0;
        }
        if (field.getType() == Boolean.TYPE) {
            return false;
        }
        return null;
    }
}

