/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.object.db;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.conflict.ORecordConflictStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.entity.OEntityManager;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.version.ORecordVersion;
import com.orientechnologies.orient.object.db.ODatabasePojoAbstract;
import com.orientechnologies.orient.object.db.OObjectNotDetachedException;
import com.orientechnologies.orient.object.dictionary.ODictionaryWrapper;
import com.orientechnologies.orient.object.enhancement.OObjectEntityEnhancer;
import com.orientechnologies.orient.object.enhancement.OObjectEntitySerializer;
import com.orientechnologies.orient.object.enhancement.OObjectMethodFilter;
import com.orientechnologies.orient.object.enhancement.OObjectProxyMethodHandler;
import com.orientechnologies.orient.object.entity.OObjectEntityClassHandler;
import com.orientechnologies.orient.object.iterator.OObjectIteratorClass;
import com.orientechnologies.orient.object.iterator.OObjectIteratorCluster;
import com.orientechnologies.orient.object.metadata.OMetadataObject;
import com.orientechnologies.orient.object.serialization.OObjectSerializerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.Proxy;
import javassist.util.proxy.ProxyObject;

public class OObjectDatabaseTx
extends ODatabasePojoAbstract<Object>
implements ODatabaseObject,
ODatabaseInternal<Object>,
OUserObject2RecordHandler {
    public static final String TYPE = "object";
    protected ODictionary<Object> dictionary;
    protected OEntityManager entityManager;
    protected boolean saveOnlyDirty;
    protected boolean lazyLoading;
    protected boolean automaticSchemaGeneration;
    protected OMetadataObject metadata;

    public OObjectDatabaseTx(String iURL) {
        super(new ODatabaseDocumentTx(iURL));
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner(this);
        this.init();
    }

    public OObjectDatabaseTx(ODatabaseDocumentTx iDatabase) {
        super(iDatabase);
        ((ODatabaseDocumentTx)this.underlying).setDatabaseOwner(this);
        this.init();
    }

    @Override
    public <T> T newInstance(Class<T> iType) {
        return (T)this.newInstance(iType.getSimpleName(), null, OCommonConst.EMPTY_OBJECT_ARRAY);
    }

    public <T> T newInstance(Class<T> iType, Object ... iArgs) {
        return (T)this.newInstance(iType.getSimpleName(), null, iArgs);
    }

    @Override
    public <RET> RET newInstance(String iClassName) {
        return this.newInstance(iClassName, null, OCommonConst.EMPTY_OBJECT_ARRAY);
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(String iUserName, String iUserPassword) {
        super.open(iUserName, iUserPassword);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        this.metadata = new OMetadataObject(((ODatabaseDocumentTx)this.underlying).getMetadata());
        return (THISDB)this;
    }

    @Override
    public <THISDB extends ODatabase> THISDB open(OToken iToken) {
        super.open(iToken);
        this.entityManager.registerEntityClass(OUser.class);
        this.entityManager.registerEntityClass(ORole.class);
        this.metadata = new OMetadataObject(((ODatabaseDocumentTx)this.underlying).getMetadata());
        return (THISDB)this;
    }

    @Override
    public OMetadataObject getMetadata() {
        this.checkOpeness();
        if (this.metadata == null) {
            this.metadata = new OMetadataObject(((ODatabaseDocumentTx)this.underlying).getMetadata());
        }
        return this.metadata;
    }

    @Override
    public Iterable<ODatabaseListener> getListeners() {
        return ((ODatabaseDocumentTx)this.underlying).getListeners();
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, Object ... iArgs) {
        ((ODatabaseDocumentTx)this.underlying).checkIfActive();
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Class<?> entityClass = this.entityManager.getEntityClass(iClassName);
            if (entityClass != null) {
                Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, ((ODatabaseDocumentTx)this.underlying).newInstance(iClassName), null, iArgs);
                return (RET)enhanced;
            }
            throw new OSerializationException("Type " + iClassName + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on creating object of class " + iClassName, (Throwable)e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET> RET newInstance(String iClassName, Object iEnclosingClass, ODocument iDocument, Object ... iArgs) {
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_CREATE, (Object)iClassName);
        try {
            Class<?> entityClass = this.entityManager.getEntityClass(iClassName);
            if (entityClass != null) {
                Object enhanced = OObjectEntityEnhancer.getInstance().getProxiedInstance(this.entityManager.getEntityClass(iClassName), iEnclosingClass, iDocument, null, iArgs);
                return (RET)enhanced;
            }
            throw new OSerializationException("Type " + iClassName + " cannot be serialized because is not part of registered entities. To fix this error register this class");
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on creating object of class " + iClassName, (Throwable)e, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass) {
        return this.browseClass(iClusterClass, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(Class<RET> iClusterClass, boolean iPolymorphic) {
        if (iClusterClass == null) {
            return null;
        }
        return this.browseClass(iClusterClass.getSimpleName(), iPolymorphic);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName) {
        return this.browseClass(iClassName, true);
    }

    public <RET> OObjectIteratorClass<RET> browseClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.CLASS, ORole.PERMISSION_READ, (Object)iClassName);
        return new OObjectIteratorClass(this, (ODatabaseDocumentTx)this.getUnderlying(), iClassName, iPolymorphic);
    }

    public <RET> OObjectIteratorCluster<RET> browseCluster(String iClusterName) {
        this.checkOpeness();
        this.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_READ, (Object)iClusterName);
        return new OObjectIteratorCluster(this, (ODatabaseDocumentTx)this.getUnderlying(), this.getClusterIdByName(iClusterName));
    }

    @Override
    public <RET> RET load(Object iPojo) {
        return this.load(iPojo, (String)null);
    }

    public <RET> RET reload(Object iPojo) {
        return this.reload(iPojo, (String)null, true);
    }

    public <RET> RET reload(Object iPojo, boolean iIgnoreCache) {
        return this.reload(iPojo, (String)null, iIgnoreCache);
    }

    @Override
    public <RET> RET reload(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        return this.reload(iPojo, iFetchPlan, iIgnoreCache, true);
    }

    @Override
    public <RET> RET reload(Object iObject, String iFetchPlan, boolean iIgnoreCache, boolean force) {
        this.checkOpeness();
        if (iObject == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iObject, true);
        ((ODatabaseDocumentTx)this.underlying).reload(record, iFetchPlan, iIgnoreCache, force);
        iObject = this.stream2pojo(record, iObject, iFetchPlan, true);
        return (RET)iObject;
    }

    @Override
    public <RET> RET load(Object iPojo, String iFetchPlan) {
        return this.load(iPojo, iFetchPlan, false);
    }

    @Override
    public void attach(Object iPojo) {
        OObjectEntitySerializer.attach(iPojo, this);
    }

    public <RET> RET attachAndSave(Object iPojo) {
        this.attach(iPojo);
        return this.save(iPojo);
    }

    @Override
    public <RET> RET detach(Object iPojo) {
        return (RET)OObjectEntitySerializer.detach(iPojo, this);
    }

    public <RET> RET detach(Object iPojo, boolean returnNonProxiedInstance) {
        return (RET)OObjectEntitySerializer.detach(iPojo, this, returnNonProxiedInstance);
    }

    public <RET> RET detachAll(Object iPojo, boolean returnNonProxiedInstance) {
        return this.detachAll(iPojo, returnNonProxiedInstance, new HashMap<Object, Object>());
    }

    @Override
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache) {
        return this.load(iPojo, iFetchPlan, iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    @Deprecated
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return this.load(iPojo, iFetchPlan, iIgnoreCache, !iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public <RET> RET load(Object iPojo, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        if (iPojo == null) {
            return null;
        }
        ODocument record = this.getRecordByUserObject(iPojo, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(record, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT);
            Object object = this.stream2pojo(record, iPojo, iFetchPlan);
            return (RET)object;
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
    }

    @Override
    public <RET> RET load(ORID recordId) {
        return this.load(recordId, (String)null);
    }

    @Override
    public <RET> RET load(ORID iRecordId, String iFetchPlan) {
        return this.load(iRecordId, iFetchPlan, false);
    }

    @Override
    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return this.load(iRecordId, iFetchPlan, iIgnoreCache, !iIgnoreCache, false, OStorage.LOCKING_STRATEGY.DEFAULT);
    }

    @Override
    @Deprecated
    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        return this.load(iRecordId, iFetchPlan, iIgnoreCache, !iIgnoreCache, loadTombstone, iLockingStrategy);
    }

    @Override
    @Deprecated
    public <RET> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        this.checkOpeness();
        if (iRecordId == null) {
            return null;
        }
        ODocument record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache, iUpdateCache, loadTombstone, OStorage.LOCKING_STRATEGY.DEFAULT);
        if (record == null) {
            return null;
        }
        return (RET)OObjectEntityEnhancer.getInstance().getProxiedInstance(record.getClassName(), this.entityManager, record, null, new Object[0]);
    }

    @Override
    public <RET> RET save(Object iContent) {
        return this.save(iContent, (String)null, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    @Override
    public <RET> RET save(Object iContent, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        return this.save(iContent, (String)null, iMode, false, iRecordCreatedCallback, iRecordUpdatedCallback);
    }

    @Override
    public <RET> RET save(Object iPojo, String iClusterName) {
        return this.save(iPojo, iClusterName, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, (ORecordCallback<? extends Number>)null, (ORecordCallback<ORecordVersion>)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <RET> RET save(Object iPojo, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        this.checkOpeness();
        if (iPojo == null) {
            return (RET)iPojo;
        }
        if (OMultiValue.isMultiValue(iPojo)) {
            for (Object pojo : OMultiValue.getMultiValueIterable(iPojo)) {
                this.save(pojo, iClusterName);
            }
            return (RET)iPojo;
        }
        ((Set)OSerializationThreadLocal.INSTANCE.get()).clear();
        Object proxiedObject = OObjectEntitySerializer.serializeObject(iPojo, this);
        ODocument record = this.getRecordByUserObject(proxiedObject, true);
        try {
            record.setInternalStatus(ORecordElement.STATUS.MARSHALLING);
            if (!this.saveOnlyDirty || record.isDirty()) {
                this.deleteOrphans((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler());
                ODocument savedRecord = (ODocument)((ODatabaseDocumentTx)this.underlying).save(record, iClusterName, iMode, iForceCreate, iRecordCreatedCallback, iRecordUpdatedCallback);
                ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).setDoc(savedRecord);
                ((OObjectProxyMethodHandler)((ProxyObject)proxiedObject).getHandler()).updateLoadedFieldMap(proxiedObject, false);
                this.registerUserObject(proxiedObject, record);
            }
        }
        finally {
            record.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return (RET)proxiedObject;
    }

    public ODatabaseObject delete(Object iPojo) {
        this.checkOpeness();
        if (iPojo == null) {
            return this;
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record == null) {
            ORecordId rid = OObjectSerializerHelper.getObjectID(this, iPojo);
            if (rid == null) {
                throw new OObjectNotDetachedException("Cannot retrieve the object's ID for '" + iPojo + "' because has not been detached");
            }
            record = (ODocument)((ODatabaseDocumentTx)this.underlying).load(rid);
        }
        this.deleteCascade(record);
        ((ODatabaseDocumentTx)this.underlying).delete(record);
        if (this.getTransaction() instanceof OTransactionNoTx) {
            this.unregisterPojo(iPojo, record);
        }
        return this;
    }

    public ODatabaseObject delete(ORID iRID) {
        this.checkOpeness();
        if (iRID == null) {
            return this;
        }
        Object record = iRID.getRecord();
        if (record instanceof ODocument) {
            Object iPojo = this.getUserObjectByRecord((OIdentifiable)record, null);
            this.deleteCascade((ODocument)record);
            ((ODatabaseDocumentTx)this.underlying).delete((ORecord)record);
            if (this.getTransaction() instanceof OTransactionNoTx) {
                this.unregisterPojo(iPojo, (ODocument)record);
            }
        }
        return this;
    }

    public ODatabaseObject delete(ORID iRID, ORecordVersion iVersion) {
        this.deleteRecord(iRID, iVersion, false);
        return this;
    }

    @Override
    public boolean hide(ORID rid) {
        throw new UnsupportedOperationException("hide");
    }

    @Override
    public ODatabase<Object> cleanOutRecord(ORID iRID, ORecordVersion iVersion) {
        this.deleteRecord(iRID, iVersion, true);
        return this;
    }

    @Override
    public long countClass(String iClassName) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName);
    }

    @Override
    public long countClass(String iClassName, boolean iPolymorphic) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClassName, iPolymorphic);
    }

    public long countClass(Class<?> iClass) {
        this.checkOpeness();
        return ((ODatabaseDocumentTx)this.underlying).countClass(iClass.getSimpleName());
    }

    @Override
    public ODictionary<Object> getDictionary() {
        this.checkOpeness();
        if (this.dictionary == null) {
            this.dictionary = new ODictionaryWrapper(this, ((ODatabaseDocumentTx)this.underlying).getDictionary().getIndex());
        }
        return this.dictionary;
    }

    @Override
    public ODatabasePojoAbstract<Object> commit() {
        return this.commit(false);
    }

    @Override
    public ODatabasePojoAbstract<Object> commit(boolean force) throws OTransactionException {
        ((ODatabaseDocumentTx)this.underlying).commit(force);
        if (this.getTransaction().isActive()) {
            return this;
        }
        if (this.getTransaction().getAllRecordEntries() != null) {
            Object pojo = null;
            for (ORecordOperation oRecordOperation : this.getTransaction().getAllRecordEntries()) {
                switch (oRecordOperation.type) {
                    case 1: 
                    case 3: {
                        break;
                    }
                    case 2: {
                        ORecord rec = oRecordOperation.getRecord();
                        if (!(rec instanceof ODocument)) break;
                        this.unregisterPojo((Object)pojo, (ODocument)rec);
                    }
                }
            }
        }
        return this;
    }

    @Override
    public ODatabasePojoAbstract<Object> rollback() {
        return this.rollback(false);
    }

    @Override
    public ODatabasePojoAbstract<Object> rollback(boolean force) throws OTransactionException {
        ((ODatabaseDocumentTx)this.underlying).rollback(force);
        if (!((ODatabaseDocumentTx)this.underlying).getTransaction().isActive()) {
            if (this.getTransaction().getCurrentRecordEntries() != null) {
                ArrayList<ORecordOperation> newEntries = new ArrayList<ORecordOperation>();
                for (ORecordOperation oRecordOperation : this.getTransaction().getCurrentRecordEntries()) {
                    if (oRecordOperation.type != 3) continue;
                    newEntries.add(oRecordOperation);
                }
            } else {
                Object var2_3 = null;
            }
        }
        return this;
    }

    @Override
    public OEntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public ODatabaseDocumentInternal getUnderlying() {
        return (ODatabaseDocumentInternal)this.underlying;
    }

    @Override
    public ORecordVersion getVersion(Object iPojo) {
        this.checkOpeness();
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getRecordVersion();
        }
        return OObjectSerializerHelper.getObjectVersion(iPojo);
    }

    @Override
    public ORID getIdentity(Object iPojo) {
        this.checkOpeness();
        if (iPojo instanceof OIdentifiable) {
            return ((OIdentifiable)iPojo).getIdentity();
        }
        ODocument record = this.getRecordByUserObject(iPojo, false);
        if (record != null) {
            return record.getIdentity();
        }
        return OObjectSerializerHelper.getObjectID(this, iPojo);
    }

    public boolean isSaveOnlyDirty() {
        return this.saveOnlyDirty;
    }

    public void setSaveOnlyDirty(boolean saveOnlyDirty) {
        this.saveOnlyDirty = saveOnlyDirty;
    }

    public boolean isAutomaticSchemaGeneration() {
        return this.automaticSchemaGeneration;
    }

    public void setAutomaticSchemaGeneration(boolean automaticSchemaGeneration) {
        this.automaticSchemaGeneration = automaticSchemaGeneration;
    }

    @Override
    public Object newInstance() {
        this.checkOpeness();
        return new ODocument();
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric resourceGeneric, String resourceSpecific, byte iOperation) {
        return (DBTYPE)((ODatabaseDocumentTx)this.underlying).checkSecurity(resourceGeneric, resourceSpecific, iOperation);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric iResource, int iOperation, Object iResourceSpecific) {
        return (DBTYPE)((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabase> DBTYPE checkSecurity(ORule.ResourceGeneric iResource, int iOperation, Object ... iResourcesSpecific) {
        return (DBTYPE)((ODatabaseDocumentTx)this.underlying).checkSecurity(iResource, iOperation, iResourcesSpecific);
    }

    @Override
    public ODocument pojo2Stream(Object iPojo, ODocument iRecord) {
        if (iPojo instanceof ProxyObject) {
            return ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).getDoc();
        }
        return OObjectSerializerHelper.toStream(iPojo, iRecord, this.getEntityManager(), this.getMetadata().getSchema().getClass(iPojo.getClass().getSimpleName()), this, this, this.saveOnlyDirty);
    }

    @Override
    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan) {
        return this.stream2pojo(iRecord, iPojo, iFetchPlan, false);
    }

    public Object stream2pojo(ODocument iRecord, Object iPojo, String iFetchPlan, boolean iReload) {
        if (iRecord.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            iRecord = (ODocument)iRecord.load();
        }
        if (iReload) {
            if (iPojo != null) {
                if (iPojo instanceof Proxy) {
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).setDoc(iRecord);
                    ((OObjectProxyMethodHandler)((ProxyObject)iPojo).getHandler()).updateLoadedFieldMap(iPojo, iReload);
                    return iPojo;
                }
                return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
            }
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iRecord.getClassName(), this.entityManager, iRecord, null, new Object[0]);
        }
        if (!(iPojo instanceof Proxy)) {
            return OObjectEntityEnhancer.getInstance().getProxiedInstance(iPojo.getClass(), iRecord, new Object[0]);
        }
        return iPojo;
    }

    @Override
    public boolean isLazyLoading() {
        return this.lazyLoading;
    }

    @Override
    public void setLazyLoading(boolean lazyLoading) {
        this.lazyLoading = lazyLoading;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public ORecordConflictStrategy getConflictStrategy() {
        return ((ODatabaseDocumentTx)this.underlying).getConflictStrategy();
    }

    @Override
    public OObjectDatabaseTx setConflictStrategy(ORecordConflictStrategy iResolver) {
        ((ODatabaseDocumentTx)this.underlying).setConflictStrategy(iResolver);
        return this;
    }

    @Override
    public OObjectDatabaseTx setConflictStrategy(String iStrategyName) {
        this.getStorage().setConflictStrategy(Orient.instance().getRecordConflictStrategy().getStrategy(iStrategyName));
        return this;
    }

    @Override
    public ODocument getRecordByUserObject(Object iPojo, boolean iCreateIfNotAvailable) {
        if (iPojo instanceof Proxy) {
            return OObjectEntitySerializer.getDocument((Proxy)iPojo);
        }
        return OObjectEntitySerializer.getDocument((Proxy)OObjectEntitySerializer.serializeObject(iPojo, this));
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan, boolean iCreate) {
        ODocument document = (ODocument)iRecord.getRecord();
        return OObjectEntityEnhancer.getInstance().getProxiedInstance(document.getClassName(), this.getEntityManager(), document, null, new Object[0]);
    }

    @Override
    public void registerUserObject(Object iObject, ORecord iRecord) {
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecord iRecord) {
    }

    @Override
    public void unregisterPojo(Object iObject, ODocument iRecord) {
    }

    public void registerClassMethodFilter(Class<?> iClass, OObjectMethodFilter iMethodFilter) {
        OObjectEntityEnhancer.getInstance().registerClassMethodFilter(iClass, iMethodFilter);
    }

    public void deregisterClassMethodFilter(Class<?> iClass) {
        OObjectEntityEnhancer.getInstance().deregisterClassMethodFilter(iClass);
    }

    @Override
    public void resetInitialization() {
        ((ODatabaseDocumentTx)this.underlying).resetInitialization();
    }

    protected <RET> RET detachAll(Object iPojo, boolean returnNonProxiedInstance, Map<Object, Object> alreadyDetached) {
        return (RET)OObjectEntitySerializer.detachAll(iPojo, this, returnNonProxiedInstance, alreadyDetached);
    }

    protected void deleteCascade(ODocument record) {
        if (record == null) {
            return;
        }
        List<String> toDeleteCascade = OObjectEntitySerializer.getCascadeDeleteFields(record.getClassName());
        if (toDeleteCascade != null) {
            for (String field : toDeleteCascade) {
                Object toDelete = record.field(field);
                if (toDelete instanceof OIdentifiable) {
                    if (toDelete == null) continue;
                    this.delete(((OIdentifiable)toDelete).getIdentity());
                    continue;
                }
                if (toDelete instanceof Collection) {
                    for (OIdentifiable cascadeRecord : (Collection)toDelete) {
                        if (cascadeRecord == null) continue;
                        this.delete(cascadeRecord.getIdentity());
                    }
                    continue;
                }
                if (!(toDelete instanceof Map)) continue;
                for (OIdentifiable cascadeRecord : ((Map)toDelete).values()) {
                    if (cascadeRecord == null) continue;
                    this.delete(cascadeRecord.getIdentity());
                }
            }
        }
    }

    protected void init() {
        this.entityManager = OEntityManager.getEntityManagerByDatabaseURL(this.getURL());
        this.entityManager.setClassHandler(OObjectEntityClassHandler.getInstance());
        this.saveOnlyDirty = OGlobalConfiguration.OBJECT_SAVE_ONLY_DIRTY.getValueAsBoolean();
        OObjectSerializerHelper.register();
        this.lazyLoading = true;
        if (!this.isClosed() && this.entityManager.getEntityClass(OUser.class.getSimpleName()) == null) {
            this.entityManager.registerEntityClass(OUser.class);
            this.entityManager.registerEntityClass(ORole.class);
        }
    }

    protected void deleteOrphans(OObjectProxyMethodHandler handler) {
        for (ORID orphan : handler.getOrphans()) {
            ODocument doc = (ODocument)orphan.getRecord();
            this.deleteCascade(doc);
            ((ODatabaseDocumentTx)this.underlying).delete(doc);
        }
        handler.getOrphans().clear();
    }

    private boolean deleteRecord(ORID iRID, ORecordVersion iVersion, boolean prohibitTombstones) {
        this.checkOpeness();
        if (iRID == null) {
            return true;
        }
        ODocument record = (ODocument)iRID.getRecord();
        if (record != null) {
            Object iPojo = this.getUserObjectByRecord(record, null);
            this.deleteCascade(record);
            if (prohibitTombstones) {
                ((ODatabaseDocumentTx)this.underlying).cleanOutRecord(iRID, iVersion);
            } else {
                ((ODatabaseDocumentTx)this.underlying).delete(iRID, iVersion);
            }
            if (this.getTransaction() instanceof OTransactionNoTx) {
                this.unregisterPojo(iPojo, record);
            }
        }
        return false;
    }
}

