/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutorAbstract;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMathAbstract;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public abstract class OSQLFunctionPathFinder
extends OSQLFunctionMathAbstract {
    protected OrientBaseGraph db;
    protected Set<OrientVertex> unSettledNodes;
    protected Map<ORID, OrientVertex> predecessors;
    protected Map<ORID, Float> distance;
    protected OrientVertex paramSourceVertex;
    protected OrientVertex paramDestinationVertex;
    protected Direction paramDirection = Direction.OUT;
    protected OCommandContext context;
    protected static final float MIN = 0.0f;

    public OSQLFunctionPathFinder(String iName, int iMinParams, int iMaxParams) {
        super(iName, iMinParams, iMaxParams);
    }

    protected LinkedList<OrientVertex> execute(OCommandContext iContext) {
        this.context = iContext;
        this.unSettledNodes = new HashSet<OrientVertex>();
        this.distance = new HashMap<ORID, Float>();
        this.predecessors = new HashMap<ORID, OrientVertex>();
        this.distance.put(this.paramSourceVertex.getIdentity(), Float.valueOf(0.0f));
        this.unSettledNodes.add(this.paramSourceVertex);
        int maxDistances = 0;
        int maxSettled = 0;
        int maxUnSettled = 0;
        int maxPredecessors = 0;
        while (this.continueTraversing()) {
            OrientVertex node = this.getMinimum(this.unSettledNodes);
            this.unSettledNodes.remove(node);
            this.findMinimalDistances(node);
            if (this.distance.size() > maxDistances) {
                maxDistances = this.distance.size();
            }
            if (this.unSettledNodes.size() > maxUnSettled) {
                maxUnSettled = this.unSettledNodes.size();
            }
            if (this.predecessors.size() > maxPredecessors) {
                maxPredecessors = this.predecessors.size();
            }
            if ((this.isVariableEdgeWeight() || !this.distance.containsKey(this.paramDestinationVertex.getIdentity())) && OCommandExecutorAbstract.checkInterruption(this.context)) continue;
            break;
        }
        this.context.setVariable("maxDistances", maxDistances);
        this.context.setVariable("maxSettled", maxSettled);
        this.context.setVariable("maxUnSettled", maxUnSettled);
        this.context.setVariable("maxPredecessors", maxPredecessors);
        this.distance = null;
        return this.getPath();
    }

    protected boolean isVariableEdgeWeight() {
        return false;
    }

    public LinkedList<OrientVertex> getPath() {
        LinkedList<OrientVertex> path = new LinkedList<OrientVertex>();
        OrientVertex step = this.paramDestinationVertex;
        if (this.predecessors.get(step.getIdentity()) == null) {
            return null;
        }
        path.add(step);
        while (this.predecessors.get(step.getIdentity()) != null) {
            step = this.predecessors.get(step.getIdentity());
            path.add(step);
        }
        Collections.reverse(path);
        return path;
    }

    @Override
    public boolean aggregateResults() {
        return false;
    }

    @Override
    public Object getResult() {
        return this.getPath();
    }

    protected void findMinimalDistances(OrientVertex node) {
        for (OrientVertex neighbor : this.getNeighbors(node)) {
            float d = this.sumDistances(this.getShortestDistance(node), this.getDistance(node, neighbor));
            if (!(this.getShortestDistance(neighbor) > d)) continue;
            this.distance.put(neighbor.getIdentity(), Float.valueOf(d));
            this.predecessors.put(neighbor.getIdentity(), node);
            this.unSettledNodes.add(neighbor);
        }
    }

    protected Set<OrientVertex> getNeighbors(Vertex node) {
        this.context.incrementVariable("getNeighbors");
        HashSet<OrientVertex> neighbors = new HashSet<OrientVertex>();
        if (node != null) {
            for (Vertex v : node.getVertices(this.paramDirection, new String[0])) {
                OrientVertex ov = (OrientVertex)v;
                if (ov == null || !this.isNotSettled(ov)) continue;
                neighbors.add(ov);
            }
        }
        return neighbors;
    }

    protected OrientVertex getMinimum(Set<OrientVertex> vertexes) {
        OrientVertex minimum = null;
        Float minimumDistance = null;
        for (OrientVertex vertex : vertexes) {
            if (minimum != null && !(this.getShortestDistance(vertex) < minimumDistance.floatValue())) continue;
            minimum = vertex;
            minimumDistance = Float.valueOf(this.getShortestDistance(minimum));
        }
        return minimum;
    }

    protected boolean isNotSettled(OrientVertex vertex) {
        return this.unSettledNodes.contains(vertex) || !this.distance.containsKey(vertex.getIdentity());
    }

    protected boolean continueTraversing() {
        return this.unSettledNodes.size() > 0;
    }

    protected float getShortestDistance(OrientVertex destination) {
        if (destination == null) {
            return Float.MAX_VALUE;
        }
        Float d = this.distance.get(destination.getIdentity());
        return d == null ? Float.MAX_VALUE : d.floatValue();
    }

    protected float sumDistances(float iDistance1, float iDistance2) {
        return iDistance1 + iDistance2;
    }

    protected abstract float getDistance(OrientVertex var1, OrientVertex var2);
}

