/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql.functions;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.orientechnologies.orient.graph.sql.functions.OSQLFunctionPathFinder;
import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.Iterator;
import java.util.LinkedList;

public class OSQLFunctionDijkstra
extends OSQLFunctionPathFinder {
    public static final String NAME = "dijkstra";
    private String paramWeightFieldName;

    public OSQLFunctionDijkstra() {
        super(NAME, 3, 4);
    }

    @Override
    public LinkedList<OrientVertex> execute(Object iThis, final OIdentifiable iCurrentRecord, Object iCurrentResult, final Object[] iParams, final OCommandContext iContext) {
        return OGraphCommandExecutorSQLFactory.runWithAnyGraph(new OGraphCommandExecutorSQLFactory.GraphCallBack<LinkedList<OrientVertex>>(){

            @Override
            public LinkedList<OrientVertex> call(OrientBaseGraph graph) {
                ORecord record = iCurrentRecord != null ? (ORecord)iCurrentRecord.getRecord() : null;
                Object source = iParams[0];
                if (OMultiValue.isMultiValue(source)) {
                    if (OMultiValue.getSize(source) > 1) {
                        throw new IllegalArgumentException("Only one sourceVertex is allowed");
                    }
                    source = OMultiValue.getFirstValue(source);
                }
                OSQLFunctionDijkstra.this.paramSourceVertex = graph.getVertex(OSQLHelper.getValue(source, record, iContext));
                Object dest = iParams[1];
                if (OMultiValue.isMultiValue(dest)) {
                    if (OMultiValue.getSize(dest) > 1) {
                        throw new IllegalArgumentException("Only one destinationVertex is allowed");
                    }
                    dest = OMultiValue.getFirstValue(dest);
                }
                OSQLFunctionDijkstra.this.paramDestinationVertex = graph.getVertex(OSQLHelper.getValue(dest, record, iContext));
                OSQLFunctionDijkstra.this.paramWeightFieldName = OIOUtils.getStringContent(iParams[2]);
                if (iParams.length > 3) {
                    OSQLFunctionDijkstra.this.paramDirection = Direction.valueOf(iParams[3].toString().toUpperCase());
                }
                return OSQLFunctionDijkstra.this.internalExecute(iContext);
            }
        });
    }

    private LinkedList<OrientVertex> internalExecute(OCommandContext iContext) {
        return super.execute(iContext);
    }

    @Override
    public String getSyntax() {
        return "dijkstra(<sourceVertex>, <destinationVertex>, <weightEdgeFieldName>, [<direction>])";
    }

    @Override
    protected float getDistance(OrientVertex node, OrientVertex target) {
        Object fieldValue;
        Edge e;
        Iterator<Edge> edges = node.getEdges(target, this.paramDirection, new String[0]).iterator();
        if (edges.hasNext() && (e = edges.next()) != null && (fieldValue = e.getProperty(this.paramWeightFieldName)) != null) {
            if (fieldValue instanceof Float) {
                return ((Float)fieldValue).floatValue();
            }
            if (fieldValue instanceof Number) {
                return ((Number)fieldValue).floatValue();
            }
        }
        return 0.0f;
    }

    @Override
    protected boolean isVariableEdgeWeight() {
        return true;
    }
}

