/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestInternal;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.graph.sql.OGraphCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public class OCommandExecutorSQLDeleteVertex
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest,
OCommandResultListener {
    public static final String NAME = "DELETE VERTEX";
    private static final String KEYWORD_BATCH = "BATCH";
    private ORecordId rid;
    private int removed = 0;
    private ODatabaseDocument database;
    private OCommandRequest query;
    private String returning = "COUNT";
    private List<ORecord> allDeletedRecords;
    private AtomicReference<OrientBaseGraph> currentGraph = new AtomicReference();
    private OModifiableBoolean shutdownFlag = new OModifiableBoolean();
    private boolean txAlreadyBegun;
    private int batch = 100;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OCommandExecutorSQLDeleteVertex parse(OCommandRequest iRequest) {
        String queryText;
        OCommandRequestText textRequest = (OCommandRequestText)iRequest;
        String originalQuery = queryText = textRequest.getText();
        try {
            queryText = this.preParse(queryText, iRequest);
            textRequest.setText(queryText);
            this.database = OCommandExecutorSQLDeleteVertex.getDatabase();
            this.init((OCommandRequestText)iRequest);
            this.parserRequiredKeyword("DELETE");
            this.parserRequiredKeyword("VERTEX");
            OClass clazz = null;
            String where = null;
            String word = this.parseOptionalWord(true, new String[0]);
            while (word != null) {
                if (word.startsWith("#")) {
                    this.rid = new ORecordId(word);
                } else if (word.equalsIgnoreCase("from")) {
                    StringBuilder q = new StringBuilder();
                    int newPos = OStringSerializerHelper.getEmbedded(this.parserText, this.parserGetCurrentPosition(), -1, q);
                    this.query = this.database.command(new OSQLAsynchQuery(q.toString(), this));
                    this.parserSetCurrentPosition(newPos);
                } else {
                    if (word.equals("WHERE")) {
                        if (clazz == null) {
                            clazz = ((OMetadataInternal)this.database.getMetadata()).getImmutableSchemaSnapshot().getClass("V");
                        }
                        where = this.parserGetCurrentPosition() > -1 ? " " + this.parserText.substring(this.parserGetPreviousPosition()) : "";
                        this.query = this.database.command(new OSQLAsynchQuery("select from `" + clazz.getName() + "`" + where, this));
                        break;
                    }
                    if (word.equals("LIMIT")) {
                        word = this.parseOptionalWord(true, new String[0]);
                        try {
                            this.limit = Integer.parseInt(word);
                        }
                        catch (Exception e) {
                            throw new OCommandSQLParsingException("Invalid LIMIT: " + word, e);
                        }
                    } else if (word.equals("RETURN")) {
                        this.returning = this.parseReturn();
                    } else if (word.equals(KEYWORD_BATCH)) {
                        word = this.parserNextWord(true);
                        if (word != null) {
                            this.batch = Integer.parseInt(word);
                        }
                    } else if (word.length() > 0 && (clazz = ((OMetadataInternal)this.database.getMetadata()).getImmutableSchemaSnapshot().getClass(word)) == null) {
                        throw new OCommandSQLParsingException("Class '" + word + "' was not found");
                    }
                }
                word = this.parseOptionalWord(true, new String[0]);
                if (!this.parserIsEnded()) continue;
            }
            where = where == null ? "" : " WHERE " + where;
            if (this.query == null && this.rid == null) {
                StringBuilder queryString = new StringBuilder();
                queryString.append("select from `");
                if (clazz == null) {
                    queryString.append("V");
                } else {
                    queryString.append(clazz.getName());
                }
                queryString.append("`");
                queryString.append(where);
                if (this.limit > -1) {
                    queryString.append(" LIMIT ").append(this.limit);
                }
                this.query = this.database.command(new OSQLAsynchQuery(queryString.toString(), this));
            }
        }
        finally {
            textRequest.setText(originalQuery);
        }
        return this;
    }

    @Override
    public Object execute(final Map<Object, Object> iArgs) {
        if (this.rid == null && this.query == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (!this.returning.equalsIgnoreCase("COUNT")) {
            this.allDeletedRecords = new ArrayList<ORecord>();
        }
        this.txAlreadyBegun = OCommandExecutorSQLDeleteVertex.getDatabase().getTransaction().isActive();
        if (this.rid != null) {
            OGraphCommandExecutorSQLFactory.runInConfiguredTxMode(new OGraphCommandExecutorSQLFactory.GraphCallBack<Object>(){

                @Override
                public Object call(OrientBaseGraph graph) {
                    OrientVertex v = graph.getVertex(OCommandExecutorSQLDeleteVertex.this.rid);
                    if (v != null) {
                        v.remove();
                        OCommandExecutorSQLDeleteVertex.this.removed = 1;
                    }
                    return null;
                }
            });
            this.end();
        } else if (this.query != null) {
            OGraphCommandExecutorSQLFactory.runInConfiguredTxMode(new OGraphCommandExecutorSQLFactory.GraphCallBack<OrientGraph>(){

                @Override
                public OrientGraph call(OrientBaseGraph iGraph) {
                    OCommandExecutorSQLDeleteVertex.this.currentGraph.set(iGraph);
                    OCommandExecutorSQLDeleteVertex.this.query.setContext(OCommandExecutorSQLDeleteVertex.this.getContext());
                    OCommandExecutorSQLDeleteVertex.this.query.execute(iArgs);
                    return null;
                }
            });
        } else {
            throw new OCommandExecutionException("Invalid target");
        }
        if (this.returning.equalsIgnoreCase("COUNT")) {
            return this.removed;
        }
        return this.allDeletedRecords;
    }

    @Override
    public boolean result(Object iRecord) {
        OIdentifiable id = (OIdentifiable)iRecord;
        if (id.getIdentity().isValid()) {
            ODocument record = (ODocument)id.getRecord();
            OrientBaseGraph g = this.currentGraph.get();
            OrientVertex v = g.getVertex(record);
            if (v != null) {
                v.remove();
                if (!this.txAlreadyBegun && this.batch > 0 && this.removed % this.batch == 0 && g instanceof OrientGraph) {
                    g.commit();
                    ((OrientGraph)g).begin();
                }
                if (this.returning.equalsIgnoreCase("BEFORE")) {
                    this.allDeletedRecords.add(record);
                }
                ++this.removed;
            }
        }
        return true;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public String getSyntax() {
        return "DELETE VERTEX <rid>|<class>|FROM <query> [WHERE <conditions>] [LIMIT <max-records>] [RETURN <COUNT|BEFORE>]> [BATCH <batch-size>]";
    }

    @Override
    public void end() {
        OrientBaseGraph g = this.currentGraph.get();
        if (g != null && !this.txAlreadyBegun) {
            g.commit();
            if (this.shutdownFlag.getValue()) {
                g.shutdown(false);
            }
        }
    }

    @Override
    public int getSecurityOperationType() {
        return ORole.PERMISSION_DELETE;
    }

    protected String parseReturn() throws OCommandSQLParsingException {
        String returning = this.parserNextWord(true);
        if (!returning.equalsIgnoreCase("COUNT") && !returning.equalsIgnoreCase("BEFORE")) {
            this.throwParsingException("Invalid RETURN value set to '" + returning + "' but it should be COUNT (default), BEFORE. Example: " + "RETURN" + " BEFORE");
        }
        return returning;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.WRITE;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT getDistributedResultManagement() {
        return this.getDistributedExecutionMode() == OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL ? OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.CHECK_FOR_EQUALS : OCommandDistributedReplicateRequest.DISTRIBUTED_RESULT_MGMT.MERGE;
    }

    @Override
    public Set<String> getInvolvedClusters() {
        HashSet<String> result = new HashSet<String>();
        if (this.rid != null) {
            result.add(this.database.getClusterNameById(this.rid.getClusterId()));
        } else if (this.query != null) {
            OCommandExecutor executor = OCommandManager.instance().getExecutor((OCommandRequestInternal)this.query);
            executor.setContext(this.context);
            executor.parse(this.query);
            return executor.getInvolvedClusters();
        }
        return result;
    }

    @Override
    public OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE getDistributedExecutionMode() {
        return this.query != null && !OCommandExecutorSQLDeleteVertex.getDatabase().getTransaction().isActive() ? OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.REPLICATE : OCommandDistributedReplicateRequest.DISTRIBUTED_EXECUTION_MODE.LOCAL;
    }
}

