/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.version;

import com.orientechnologies.common.serialization.OBinaryConverter;
import com.orientechnologies.common.serialization.OBinaryConverterFactory;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.storage.fs.OFile;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.nio.ByteOrder;

public final class OSimpleVersion
implements ORecordVersion {
    public static final OBinaryConverter CONVERTER = OBinaryConverterFactory.getConverter();
    protected int version;

    public OSimpleVersion() {
    }

    public OSimpleVersion(int version) {
        this.version = version;
    }

    @Override
    public void increment() {
        if (this.isTombstone()) {
            throw new IllegalStateException("Record was deleted and cannot be updated.");
        }
        ++this.version;
    }

    @Override
    public void decrement() {
        if (this.isTombstone()) {
            throw new IllegalStateException("Record was deleted and cannot be updated.");
        }
        --this.version;
    }

    @Override
    public boolean isUntracked() {
        return this.version == -1;
    }

    @Override
    public boolean isTemporary() {
        return this.version < -1;
    }

    @Override
    public boolean isValid() {
        return this.version > -1;
    }

    @Override
    public boolean isTombstone() {
        return this.version < 0;
    }

    @Override
    public void convertToTombstone() {
        if (this.isTombstone()) {
            throw new IllegalStateException("Record was deleted and cannot be updated.");
        }
        ++this.version;
        this.version = -this.version;
    }

    @Override
    public byte[] toStream() {
        byte[] buffer = new byte[4];
        this.getSerializer().writeTo(buffer, 0, (ORecordVersion)this);
        return buffer;
    }

    @Override
    public void fromStream(byte[] stream) {
        this.getSerializer().readFrom(stream, 0, (ORecordVersion)this);
    }

    @Override
    public void setCounter(int iVersion) {
        this.version = iVersion;
    }

    @Override
    public int getCounter() {
        return this.version;
    }

    @Override
    public void copyFrom(ORecordVersion iOtherVersion) {
        OSimpleVersion otherVersion = (OSimpleVersion)iOtherVersion;
        this.version = otherVersion.version;
    }

    @Override
    public void reset() {
        this.version = 0;
    }

    @Override
    public void setRollbackMode() {
        this.version = Integer.MIN_VALUE + this.version;
    }

    @Override
    public void clearRollbackMode() {
        this.version -= Integer.MIN_VALUE;
    }

    @Override
    public void disable() {
        this.version = -1;
    }

    @Override
    public void revive() {
        this.version = -this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OSimpleVersion)) {
            return false;
        }
        OSimpleVersion that = (OSimpleVersion)o;
        return this.version == that.version;
    }

    @Override
    public int hashCode() {
        return this.version;
    }

    @Override
    public String toString() {
        return OSimpleVersionSerializer.INSTANCE.toString(this);
    }

    @Override
    public ORecordVersion copy() {
        return new OSimpleVersion(this.version);
    }

    @Override
    public ORecordVersion.ORecordVersionSerializer getSerializer() {
        return OSimpleVersionSerializer.INSTANCE;
    }

    @Override
    public int compareTo(ORecordVersion o) {
        int otherVersion;
        int myVersion = this.isTombstone() ? -this.version : this.version;
        if (myVersion == (otherVersion = o.isTombstone() ? -o.getCounter() : o.getCounter())) {
            return 0;
        }
        if (myVersion < otherVersion) {
            return -1;
        }
        return 1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        OSimpleVersionSerializer.INSTANCE.writeTo(out, (ORecordVersion)this);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        OSimpleVersionSerializer.INSTANCE.readFrom(in, (ORecordVersion)this);
    }

    private static final class OSimpleVersionSerializer
    implements ORecordVersion.ORecordVersionSerializer {
        private static final OSimpleVersionSerializer INSTANCE = new OSimpleVersionSerializer();

        private OSimpleVersionSerializer() {
        }

        @Override
        public void writeTo(DataOutput out, ORecordVersion version) throws IOException {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            out.writeInt(simpleVersion.version);
        }

        @Override
        public void readFrom(DataInput in, ORecordVersion version) throws IOException {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            simpleVersion.version = in.readInt();
        }

        @Override
        public void readFrom(InputStream stream, ORecordVersion version) throws IOException {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            simpleVersion.version = OBinaryProtocol.bytes2int(stream);
        }

        @Override
        public void writeTo(OutputStream stream, ORecordVersion version) throws IOException {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            stream.write(OBinaryProtocol.int2bytes(simpleVersion.version));
        }

        @Override
        public int writeTo(byte[] iStream, int pos, ORecordVersion version) {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            OBinaryProtocol.int2bytes(simpleVersion.version, iStream, pos);
            return 4;
        }

        @Override
        public int readFrom(byte[] iStream, int pos, ORecordVersion version) {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            simpleVersion.version = OBinaryProtocol.bytes2int(iStream, pos);
            return 4;
        }

        @Override
        public int writeTo(OFile file, long offset, ORecordVersion version) throws IOException {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            file.writeInt(offset, simpleVersion.version);
            return 4;
        }

        @Override
        public long readFrom(OFile file, long offset, ORecordVersion version) throws IOException {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            simpleVersion.version = file.readInt(offset);
            return 4L;
        }

        @Override
        public int fastWriteTo(byte[] iStream, int pos, ORecordVersion version) {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            CONVERTER.putInt(iStream, pos, simpleVersion.version, ByteOrder.nativeOrder());
            return 4;
        }

        @Override
        public int fastReadFrom(byte[] iStream, int pos, ORecordVersion version) {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            simpleVersion.version = CONVERTER.getInt(iStream, pos, ByteOrder.nativeOrder());
            return 4;
        }

        @Override
        public byte[] toByteArray(ORecordVersion version) {
            byte[] bytes = new byte[4];
            this.fastWriteTo(bytes, 0, version);
            return bytes;
        }

        @Override
        public String toString(ORecordVersion recordVersion) {
            OSimpleVersion simpleVersion = (OSimpleVersion)recordVersion;
            return String.valueOf(simpleVersion.version);
        }

        @Override
        public void fromString(String string, ORecordVersion version) {
            OSimpleVersion simpleVersion = (OSimpleVersion)version;
            simpleVersion.version = Integer.parseInt(string);
        }
    }
}

