/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.OScenarioThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.ORollbackException;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private static AtomicInteger txSerial = new AtomicInteger();
    private boolean usingLog = true;
    private int txStartCounter;

    public OTransactionOptimistic(ODatabaseDocumentTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Invalid value of TX counter.");
        }
        if (this.txStartCounter == 0) {
            this.status = OTransaction.TXSTATUS.BEGUN;
        }
        ++this.txStartCounter;
        if (this.txStartCounter > 1) {
            OLogManager.instance().debug((Object)this, "Transaction was already started and will be reused.", new Object[0]);
        }
    }

    @Override
    public void commit() {
        this.commit(false);
    }

    @Override
    public void commit(boolean force) {
        this.checkTransaction();
        if (this.txStartCounter < 0) {
            throw new OStorageException("Invalid value of tx counter");
        }
        this.txStartCounter = force ? 0 : --this.txStartCounter;
        if (this.txStartCounter == 0) {
            this.doCommit();
        } else if (this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was not committed.", new Object[0]);
        } else {
            throw new OTransactionException("Transaction was committed more times than it is started.");
        }
    }

    @Override
    public int amountOfNestedTxs() {
        return this.txStartCounter;
    }

    @Override
    public void rollback() {
        this.rollback(false, -1);
    }

    @Override
    public void rollback(boolean force, int commitLevelDiff) {
        if (this.txStartCounter < 0) {
            throw new OStorageException("Invalid value of TX counter");
        }
        this.checkTransaction();
        this.txStartCounter += commitLevelDiff;
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        if (!force && this.txStartCounter > 0) {
            OLogManager.instance().debug((Object)this, "Nested transaction was closed but transaction itself was scheduled for rollback.", new Object[0]);
            return;
        }
        if (this.txStartCounter < 0) {
            throw new OTransactionException("Transaction was rolled back more times than it was started.");
        }
        this.database.getStorage().callInLock(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                OTransactionOptimistic.this.database.getStorage().rollback(OTransactionOptimistic.this);
                return null;
            }
        }, true);
        this.database.getLocalCache().clear();
        for (ORecordOperation v : this.recordEntries.values()) {
            v.getRecord().unload();
        }
        for (ORecordOperation v : this.allEntries.values()) {
            v.getRecord().unload();
        }
        this.close();
        this.status = OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY lockingStrategy) {
        return this.loadRecord(rid, iRecord, fetchPlan, ignoreCache, true, loadTombstone, lockingStrategy);
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY lockingStrategy) {
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (iRecord != null && txRecord != iRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", iRecord.getIdentity());
            }
            return txRecord;
        }
        if (rid.isTemporary()) {
            return null;
        }
        Object record = this.database.executeReadRecord((ORecordId)rid, iRecord, null, fetchPlan, ignoreCache, iUpdateCache, false, lockingStrategy, new ODatabaseDocumentTx.SimpleRecordReader());
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord loadRecordIfVersionIsNotLatest(ORID rid, ORecordVersion recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            throw new ORecordNotFoundException("Record with id " + rid + " was not found in database.");
        }
        if (txRecord != null) {
            if (txRecord.getRecordVersion().compareTo(recordVersion) > 0) {
                return txRecord;
            }
            return null;
        }
        if (rid.isTemporary()) {
            throw new ORecordNotFoundException("Record with id " + rid + " was not found in database.");
        }
        Object record = this.database.executeReadRecord((ORecordId)rid, null, recordVersion, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new ODatabaseDocumentTx.SimpleRecordReader());
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord iRecord, String fetchPlan, boolean ignoreCache) {
        return this.reloadRecord(rid, iRecord, fetchPlan, ignoreCache, true);
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord passedRecord, String fetchPlan, boolean ignoreCache, boolean force) {
        Object record;
        this.checkTransaction();
        ORecord txRecord = this.getRecord(rid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            if (passedRecord != null && txRecord != passedRecord) {
                OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", passedRecord.getIdentity());
            }
            return txRecord;
        }
        if (rid.isTemporary()) {
            return null;
        }
        try {
            ODatabaseDocumentTx.RecordReader recordReader = force ? new ODatabaseDocumentTx.SimpleRecordReader() : new ODatabaseDocumentTx.LatestVersionRecordReader();
            Object loadedRecord = this.database.executeReadRecord((ORecordId)rid, passedRecord, null, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, recordReader);
            record = force ? loadedRecord : (loadedRecord == null ? passedRecord : loadedRecord);
        }
        catch (ORecordNotFoundException e) {
            return null;
        }
        if (record != null && this.isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ) {
            this.addRecord((ORecord)record, (byte)0, null);
        }
        return record;
    }

    @Override
    public ORecord loadRecord(ORID rid, ORecord record, String fetchPlan, boolean ignoreCache) {
        return this.loadRecord(rid, record, fetchPlan, ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE);
    }

    @Override
    public void deleteRecord(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public ORecord saveRecord(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        if (iRecord == null) {
            return null;
        }
        byte operation = iForceCreate ? (byte)3 : (iRecord.getIdentity().isValid() ? (byte)1 : 3);
        this.addRecord(iRecord, operation, iClusterName);
        return iRecord;
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.recordEntries.size() + ", idxEntries=" + this.indexEntries.size() + ']';
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }

    public void setStatus(OTransaction.TXSTATUS iStatus) {
        this.status = iStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRecord(ORecord iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        if (iStatus != 0) {
            this.changedDocuments.remove(iRecord);
        }
        try {
            switch (iStatus) {
                case 3: {
                    this.database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_CREATE, (Object)iClusterName);
                    ORecordHook.RESULT res = this.database.callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, iRecord);
                    if (res != ORecordHook.RESULT.RECORD_CHANGED || !(iRecord instanceof ODocument)) break;
                    ((ODocument)iRecord).validate();
                    break;
                }
                case 0: {
                    break;
                }
                case 1: {
                    this.database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_UPDATE, (Object)iClusterName);
                    ORecordHook.RESULT res = this.database.callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, iRecord);
                    if (res != ORecordHook.RESULT.RECORD_CHANGED || !(iRecord instanceof ODocument)) break;
                    ((ODocument)iRecord).validate();
                    break;
                }
                case 2: {
                    this.database.checkSecurity(ORule.ResourceGeneric.CLUSTER, ORole.PERMISSION_DELETE, (Object)iClusterName);
                    this.database.callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, iRecord);
                }
            }
            try {
                if (iRecord.getIdentity().isTemporary()) {
                    this.temp2persistent.put(iRecord.getIdentity().copy(), iRecord);
                }
                if (this.status == OTransaction.TXSTATUS.COMMITTING && this.database.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage) {
                    switch (iStatus) {
                        case 1: 
                        case 3: {
                            ORID oldRid = iRecord.getIdentity().copy();
                            this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getRecordVersion(), false, ODatabase.OPERATION_MODE.SYNCHRONOUS, false, null, null);
                            this.updateIdentityAfterCommit(oldRid, iRecord.getIdentity());
                            break;
                        }
                        case 2: {
                            this.database.executeDeleteRecord(iRecord, iRecord.getRecordVersion(), false, false, ODatabase.OPERATION_MODE.SYNCHRONOUS, false);
                        }
                    }
                    ORecordOperation txRecord = this.getRecordEntry(iRecord.getIdentity());
                    if (txRecord == null) {
                        this.allEntries.put(iRecord.getIdentity(), new ORecordOperation(iRecord, iStatus));
                    } else if (txRecord.record != iRecord) {
                        String clusterName = this.getDatabase().getClusterNameById(iRecord.getIdentity().getClusterId());
                        if (!clusterName.equals("manindex") && !clusterName.equals("index")) {
                            OLogManager.instance().warn((Object)this, "Found record in transaction with the same RID %s but different instance. Probably the record has been loaded from another transaction and reused on the current one: reload it from current transaction before to update or delete it", iRecord.getIdentity());
                        }
                        txRecord.record = iRecord;
                        txRecord.type = iStatus;
                    }
                } else {
                    ORecordOperation txEntry;
                    ORecordId rid = (ORecordId)iRecord.getIdentity();
                    if (!rid.isValid()) {
                        ORecordInternal.onBeforeIdentityChanged(iRecord);
                        if (this.database.getStorage().isAssigningClusterIds() || iClusterName != null) {
                            if (rid.clusterId == -1) {
                                int n = rid.clusterId = iClusterName != null ? this.database.getClusterIdByName(iClusterName) : this.database.getDefaultClusterId();
                            }
                            if (this.database.getStorageVersions().classesAreDetectedByClusterId() && iRecord instanceof ODocument) {
                                ODocument recordSchemaAware = (ODocument)iRecord;
                                OImmutableClass recordClass = ODocumentInternal.getImmutableSchemaClass(recordSchemaAware);
                                OClass clusterIdClass = this.database.getMetadata().getImmutableSchemaSnapshot().getClassByClusterId(rid.clusterId);
                                if (recordClass == null && clusterIdClass != null || clusterIdClass == null && recordClass != null || recordClass != null && !((Object)recordClass).equals(clusterIdClass)) {
                                    throw new OSchemaException("Record saved into cluster " + iClusterName + " should be saved with class " + clusterIdClass + " but saved with class " + recordClass);
                                }
                            }
                        }
                        rid.clusterPosition = this.newObjectCounter--;
                        ORecordInternal.onAfterIdentityChanged(iRecord);
                    }
                    if ((txEntry = this.getRecordEntry(rid)) == null) {
                        if (!rid.isTemporary() || iStatus == 3) {
                            txEntry = new ORecordOperation(iRecord, iStatus);
                            this.recordEntries.put(rid, txEntry);
                        }
                    } else {
                        txEntry.record = iRecord;
                        switch (txEntry.type) {
                            case 0: {
                                switch (iStatus) {
                                    case 1: {
                                        txEntry.type = 1;
                                        break;
                                    }
                                    case 2: {
                                        txEntry.type = (byte)2;
                                    }
                                }
                                break;
                            }
                            case 1: {
                                switch (iStatus) {
                                    case 2: {
                                        txEntry.type = (byte)2;
                                    }
                                }
                                break;
                            }
                            case 2: {
                                break;
                            }
                            case 3: {
                                switch (iStatus) {
                                    case 2: {
                                        this.recordEntries.remove(rid);
                                    }
                                }
                            }
                        }
                    }
                }
                switch (iStatus) {
                    case 3: {
                        this.database.callbackHooks(ORecordHook.TYPE.AFTER_CREATE, iRecord);
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.AFTER_DELETE, iRecord);
                    }
                }
                if (iRecord instanceof ODocument && ((ODocument)iRecord).isTrackingChanges()) {
                    ((ODocument)iRecord).setTrackingChanges(false);
                    ((ODocument)iRecord).setTrackingChanges(true);
                }
            }
            catch (Throwable t) {
                switch (iStatus) {
                    case 3: {
                        this.database.callbackHooks(ORecordHook.TYPE.CREATE_FAILED, iRecord);
                        break;
                    }
                    case 1: {
                        this.database.callbackHooks(ORecordHook.TYPE.UPDATE_FAILED, iRecord);
                        break;
                    }
                    case 2: {
                        this.database.callbackHooks(ORecordHook.TYPE.DELETE_FAILED, iRecord);
                    }
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                throw new ODatabaseException("Error on saving record " + iRecord.getIdentity(), t);
            }
        }
        finally {
            switch (iStatus) {
                case 3: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_CREATION, iRecord);
                    break;
                }
                case 1: {
                    this.database.callbackHooks(ORecordHook.TYPE.FINALIZE_UPDATE, iRecord);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit() {
        if (this.status == OTransaction.TXSTATUS.ROLLED_BACK || this.status == OTransaction.TXSTATUS.ROLLBACKING) {
            throw new ORollbackException("Given transaction was rolled back and cannot be used.");
        }
        this.status = OTransaction.TXSTATUS.COMMITTING;
        if (!this.recordEntries.isEmpty() || !this.indexEntries.isEmpty()) {
            if (OScenarioThreadLocal.INSTANCE.getRunMode() == OScenarioThreadLocal.RUN_MODE.DEFAULT && !(this.database.getStorage().getUnderlying() instanceof OAbstractPaginatedStorage)) {
                this.database.getStorage().commit(this, null);
            } else {
                List<OIndexAbstract<?>> lockedIndexes = this.acquireIndexLocks();
                try {
                    HashMap indexes = new HashMap();
                    for (OIndex<?> index : this.database.getMetadata().getIndexManager().getIndexes()) {
                        indexes.put(index.getName(), index);
                    }
                    final CommitIndexesCallback callback = new CommitIndexesCallback(indexes);
                    String storageType = this.database.getStorage().getUnderlying().getType();
                    if (storageType.equals("plocal") || storageType.equals("memory")) {
                        this.database.getStorage().commit(this, callback);
                    } else {
                        this.database.getStorage().callInLock(new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                OTransactionOptimistic.this.database.getStorage().commit(OTransactionOptimistic.this, callback);
                                return null;
                            }
                        }, true);
                    }
                }
                finally {
                    this.releaseIndexLocks(lockedIndexes);
                }
            }
        }
        this.close();
        this.status = OTransaction.TXSTATUS.COMPLETED;
    }

    private List<OIndexAbstract<?>> acquireIndexLocks() {
        ArrayList<OIndexAbstract> lockedIndexes = null;
        List<String> involvedIndexes = this.getInvolvedIndexes();
        if (involvedIndexes != null) {
            Collections.sort(involvedIndexes);
        }
        try {
            if (involvedIndexes != null) {
                for (String indexName : involvedIndexes) {
                    OIndexAbstract index = (OIndexAbstract)this.database.getMetadata().getIndexManager().getIndexInternal(indexName);
                    if (lockedIndexes == null) {
                        lockedIndexes = new ArrayList<OIndexAbstract>();
                    }
                    index.acquireModificationLock();
                    lockedIndexes.add(index);
                }
            }
            return lockedIndexes;
        }
        catch (RuntimeException e) {
            this.releaseIndexLocks(lockedIndexes);
            throw e;
        }
    }

    private void releaseIndexLocks(List<OIndexAbstract<?>> lockedIndexes) {
        if (lockedIndexes != null) {
            for (OIndexAbstract<?> index : lockedIndexes) {
                index.releaseModificationLock();
            }
        }
    }

    private class CommitIndexesCallback
    implements Runnable {
        private final Map<String, OIndex<?>> indexes;

        private CommitIndexesCallback(Map<String, OIndex<?>> indexes) {
            this.indexes = indexes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ODocument indexEntries = OTransactionOptimistic.this.getIndexChanges();
            if (indexEntries != null) {
                OIndexInternal<Object> index;
                HashMap indexesToCommit = new HashMap();
                for (Map.Entry<String, Object> indexEntry : indexEntries) {
                    index = this.indexes.get(indexEntry.getKey()).getInternal();
                    indexesToCommit.put(index.getName(), index.getInternal());
                }
                for (OIndexInternal indexInternal : indexesToCommit.values()) {
                    indexInternal.preCommit();
                }
                for (Map.Entry<String, Object> indexEntry : indexEntries) {
                    index = ((OIndexInternal)indexesToCommit.get(indexEntry.getKey())).getInternal();
                    if (index == null) {
                        OLogManager.instance().error((Object)this, "Index with name '" + indexEntry.getKey() + "' was not found.", new Object[0]);
                        throw new OIndexException("Index with name '" + indexEntry.getKey() + "' was not found.");
                    }
                    index.addTxOperation((ODocument)indexEntry.getValue());
                }
                try {
                    for (OIndexInternal indexInternal : indexesToCommit.values()) {
                        indexInternal.commit();
                    }
                }
                finally {
                    for (OIndexInternal indexInternal : indexesToCommit.values()) {
                        indexInternal.postCommit();
                    }
                }
            }
        }
    }
}

