/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import com.orientechnologies.orient.core.version.ORecordVersion;
import java.util.Collection;
import java.util.List;

public class OTransactionNoTx
extends OTransactionAbstract {
    public OTransactionNoTx(ODatabaseDocumentTx iDatabase) {
        super(iDatabase);
    }

    @Override
    public void begin() {
    }

    @Override
    public void commit() {
    }

    @Override
    public int getEntryCount() {
        return 0;
    }

    @Override
    public boolean hasRecordCreation() {
        return false;
    }

    @Override
    public void restore() {
    }

    @Override
    public void commit(boolean force) {
    }

    @Override
    public void rollback() {
    }

    @Override
    @Deprecated
    public ORecord loadRecord(ORID iRid, ORecord iRecord, String iFetchPlan, boolean ignoreCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        if (iRid.isNew()) {
            return null;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, null, iFetchPlan, ignoreCache, !ignoreCache, loadTombstone, iLockingStrategy, new ODatabaseDocumentTx.SimpleRecordReader());
    }

    @Override
    @Deprecated
    public ORecord loadRecord(ORID iRid, ORecord iRecord, String iFetchPlan, boolean ignoreCache, boolean iUpdateCache, boolean loadTombstone, OStorage.LOCKING_STRATEGY iLockingStrategy) {
        if (iRid.isNew()) {
            return null;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, null, iFetchPlan, ignoreCache, iUpdateCache, loadTombstone, iLockingStrategy, new ODatabaseDocumentTx.SimpleRecordReader());
    }

    @Override
    public ORecord loadRecord(ORID iRid, ORecord iRecord, String iFetchPlan, boolean ignoreCache) {
        if (iRid.isNew()) {
            return null;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, null, iFetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new ODatabaseDocumentTx.SimpleRecordReader());
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord record, String fetchPlan, boolean ignoreCache) {
        return this.reloadRecord(rid, record, fetchPlan, ignoreCache, true);
    }

    @Override
    public ORecord reloadRecord(ORID rid, ORecord record, String fetchPlan, boolean ignoreCache, boolean force) {
        if (rid.isNew()) {
            return null;
        }
        ODatabaseDocumentTx.RecordReader recordReader = force ? new ODatabaseDocumentTx.SimpleRecordReader() : new ODatabaseDocumentTx.LatestVersionRecordReader();
        Object loadedRecord = this.database.executeReadRecord((ORecordId)rid, record, null, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, recordReader);
        if (force) {
            return loadedRecord;
        }
        if (loadedRecord == null) {
            return record;
        }
        return loadedRecord;
    }

    @Override
    public ORecord loadRecordIfVersionIsNotLatest(ORID rid, ORecordVersion recordVersion, String fetchPlan, boolean ignoreCache) throws ORecordNotFoundException {
        if (rid.isNew()) {
            return null;
        }
        return this.database.executeReadRecord((ORecordId)rid, null, recordVersion, fetchPlan, ignoreCache, !ignoreCache, false, OStorage.LOCKING_STRATEGY.NONE, new ODatabaseDocumentTx.LatestVersionRecordReader());
    }

    @Override
    public ORecord saveRecord(ORecord iRecord, String iClusterName, ODatabase.OPERATION_MODE iMode, boolean iForceCreate, ORecordCallback<? extends Number> iRecordCreatedCallback, ORecordCallback<ORecordVersion> iRecordUpdatedCallback) {
        try {
            return this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getRecordVersion(), true, iMode, iForceCreate, iRecordCreatedCallback, null);
        }
        catch (Exception e) {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (rid.isValid()) {
                this.database.getLocalCache().freeRecord(rid);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OException(e);
        }
    }

    @Override
    public OTransaction setIsolationLevel(OTransaction.ISOLATION_LEVEL isolationLevel) {
        if (isolationLevel != OTransaction.ISOLATION_LEVEL.READ_COMMITTED) {
            throw new IllegalArgumentException("Isolation level '" + (Object)((Object)isolationLevel) + "' is not supported without an active transaction");
        }
        return super.setIsolationLevel(isolationLevel);
    }

    @Override
    public void deleteRecord(ORecord iRecord, ODatabase.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isPersistent()) {
            return;
        }
        try {
            this.database.executeDeleteRecord(iRecord, iRecord.getRecordVersion(), true, true, iMode, false);
        }
        catch (Exception e) {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (rid.isValid()) {
                this.database.getLocalCache().freeRecord(rid);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OException(e);
        }
    }

    public Collection<ORecordOperation> getCurrentRecordEntries() {
        return null;
    }

    public Collection<ORecordOperation> getAllRecordEntries() {
        return null;
    }

    @Override
    public List<ORecordOperation> getNewRecordEntriesByClass(OClass iClass, boolean iPolymorphic) {
        return null;
    }

    @Override
    public List<ORecordOperation> getNewRecordEntriesByClusterIds(int[] iIds) {
        return null;
    }

    @Override
    public void clearRecordEntries() {
    }

    public int getRecordEntriesSize() {
        return 0;
    }

    @Override
    public ORecord getRecord(ORID rid) {
        return null;
    }

    @Override
    public ORecordOperation getRecordEntry(ORID rid) {
        return null;
    }

    @Override
    public boolean isUsingLog() {
        return false;
    }

    @Override
    public void setUsingLog(boolean useLog) {
    }

    @Override
    public ODocument getIndexChanges() {
        return null;
    }

    public OTransactionIndexChangesPerKey getIndexEntry(String iIndexName, Object iKey) {
        return null;
    }

    @Override
    public void addIndexEntry(OIndex<?> delegate, String indexName, OTransactionIndexChanges.OPERATION status, Object key, OIdentifiable value) {
        switch (status) {
            case CLEAR: {
                delegate.clear();
                break;
            }
            case PUT: {
                delegate.put(key, value);
                break;
            }
            case REMOVE: {
                assert (key != null);
                delegate.remove(key, value);
            }
        }
    }

    @Override
    public void clearIndexEntries() {
    }

    @Override
    public OTransactionIndexChanges getIndexChanges(String iName) {
        return null;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public List<String> getInvolvedIndexes() {
        return null;
    }

    @Override
    public void updateIdentityAfterCommit(ORID oldRid, ORID newRid) {
    }

    @Override
    public int amountOfNestedTxs() {
        return 0;
    }

    @Override
    public void rollback(boolean force, int commitLevelDiff) {
    }
}

