/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsMangerMXBean;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.ONestedRollbackException;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.ONonTxOperationPerformedWALRecord;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OOperationUnitId;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class OAtomicOperationsManager
implements OAtomicOperationsMangerMXBean {
    public static final String MBEAN_NAME = "com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations:type=OAtomicOperationsMangerMXBean";
    private volatile boolean trackAtomicOperations = OGlobalConfiguration.TX_TRACK_ATOMIC_OPERATIONS.getValueAsBoolean();
    private final AtomicBoolean mbeanIsRegistered = new AtomicBoolean();
    private static volatile ThreadLocal<OAtomicOperation> currentOperation = new ThreadLocal();
    private final OAbstractPaginatedStorage storage;
    private final OWriteAheadLog writeAheadLog;
    private final OLockManager<String> lockManager = new OLockManager(true, -1);
    private final OReadCache readCache;
    private final OWriteCache writeCache;
    private final Map<OOperationUnitId, OPair<String, StackTraceElement[]>> activeAtomicOperations = new ConcurrentHashMap<OOperationUnitId, OPair<String, StackTraceElement[]>>();

    public OAtomicOperationsManager(OAbstractPaginatedStorage storage) {
        this.storage = storage;
        this.writeAheadLog = storage.getWALInstance();
        this.readCache = storage.getReadCache();
        this.writeCache = storage.getWriteCache();
    }

    public OAtomicOperation startAtomicOperation(ODurableComponent durableComponent, boolean rollbackOnlyMode) throws IOException {
        if (durableComponent != null) {
            return this.startAtomicOperation(durableComponent.getFullName(), rollbackOnlyMode);
        }
        return this.startAtomicOperation((String)null, rollbackOnlyMode);
    }

    public OAtomicOperation startAtomicOperation(String fullName, boolean rollbackOnlyMode) throws IOException {
        if (this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        if (operation != null) {
            operation.incrementCounter();
            if (fullName != null) {
                this.acquireExclusiveLockTillOperationComplete(fullName);
            }
            return operation;
        }
        OOperationUnitId unitId = OOperationUnitId.generateId();
        OLogSequenceNumber lsn = !rollbackOnlyMode ? this.writeAheadLog.logAtomicOperationStartRecord(true, unitId) : null;
        operation = new OAtomicOperation(lsn, unitId, this.readCache, this.writeCache, this.storage.getId(), rollbackOnlyMode);
        currentOperation.set(operation);
        if (this.trackAtomicOperations) {
            Thread thread = Thread.currentThread();
            this.activeAtomicOperations.put(unitId, new OPair<String, StackTraceElement[]>(thread.getName(), thread.getStackTrace()));
        }
        if (this.storage.getStorageTransaction() == null) {
            this.writeAheadLog.log(new ONonTxOperationPerformedWALRecord());
        }
        if (fullName != null) {
            this.acquireExclusiveLockTillOperationComplete(fullName);
        }
        return operation;
    }

    public OAtomicOperation getCurrentOperation() {
        return currentOperation.get();
    }

    public OAtomicOperation endAtomicOperation(boolean rollback, Exception exception) throws IOException {
        if (this.writeAheadLog == null) {
            return null;
        }
        OAtomicOperation operation = currentOperation.get();
        assert (operation != null);
        if (rollback) {
            operation.rollback(exception);
        }
        if (operation.isRollback() && !rollback) {
            StringWriter writer = new StringWriter();
            writer.append("Atomic operation was rolled back by internal component");
            if (operation.getRollbackException() != null) {
                writer.append(", exception which caused this rollback is :\n");
                operation.getRollbackException().printStackTrace(new PrintWriter(writer));
                writer.append("\r\n");
            }
            throw new ONestedRollbackException(writer.toString(), exception);
        }
        int counter = operation.decrementCounter();
        assert (counter >= 0);
        if (counter == 0) {
            if (!operation.isRollback()) {
                operation.commitChanges(this.writeAheadLog);
            }
            if (!operation.isRollbackOnlyMode()) {
                this.writeAheadLog.logAtomicOperationEndRecord(operation.getOperationUnitId(), rollback, operation.getStartLSN());
            }
            currentOperation.set(null);
            if (this.trackAtomicOperations) {
                this.activeAtomicOperations.remove(operation.getOperationUnitId());
            }
            for (String lockObject : operation.lockedObjects()) {
                this.lockManager.releaseLock(this, lockObject, OLockManager.LOCK.EXCLUSIVE);
            }
        }
        return operation;
    }

    private void acquireExclusiveLockTillOperationComplete(String fullName) {
        OAtomicOperation operation = currentOperation.get();
        if (operation == null) {
            return;
        }
        if (operation.containsInLockedObjects(fullName)) {
            return;
        }
        this.lockManager.acquireLock(fullName, OLockManager.LOCK.EXCLUSIVE);
        operation.addLockedObject(fullName);
    }

    public void acquireReadLock(ODurableComponent durableComponent) {
        if (this.writeAheadLog == null) {
            return;
        }
        assert (durableComponent.getName() != null);
        assert (durableComponent.getFullName() != null);
        this.lockManager.acquireLock(durableComponent.getFullName(), OLockManager.LOCK.SHARED);
    }

    public void releaseReadLock(ODurableComponent durableComponent) {
        if (this.writeAheadLog == null) {
            return;
        }
        assert (durableComponent.getName() != null);
        assert (durableComponent.getFullName() != null);
        this.lockManager.releaseLock(this, durableComponent.getFullName(), OLockManager.LOCK.SHARED);
    }

    public void registerMBean() {
        if (this.mbeanIsRegistered.compareAndSet(false, true)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName());
                server.registerMBean(this, mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new OStorageException("Error during registration of atomic manager MBean.", e);
            }
            catch (InstanceAlreadyExistsException e) {
                throw new OStorageException("Error during registration of atomic manager MBean.", e);
            }
            catch (MBeanRegistrationException e) {
                throw new OStorageException("Error during registration of atomic manager MBean.", e);
            }
            catch (NotCompliantMBeanException e) {
                throw new OStorageException("Error during registration of atomic manager MBean.", e);
            }
        }
    }

    private String getMBeanName() {
        return "com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations:type=OAtomicOperationsMangerMXBean,name=" + ObjectName.quote(this.storage.getName()) + ",id=" + this.storage.getId();
    }

    public void unregisterMBean() {
        if (this.mbeanIsRegistered.compareAndSet(true, false)) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                ObjectName mbeanName = new ObjectName(this.getMBeanName());
                server.unregisterMBean(mbeanName);
            }
            catch (MalformedObjectNameException e) {
                throw new OStorageException("Error during unregistration of atomic manager MBean.", e);
            }
            catch (InstanceNotFoundException e) {
                throw new OStorageException("Error during unregistration of atomic manager MBean.", e);
            }
            catch (MBeanRegistrationException e) {
                throw new OStorageException("Error during unregistration of atomic manager MBean.", e);
            }
        }
    }

    @Override
    public void trackAtomicOperations() {
        this.activeAtomicOperations.clear();
        this.trackAtomicOperations = true;
    }

    @Override
    public void doNotTrackAtomicOperations() {
        this.trackAtomicOperations = false;
        this.activeAtomicOperations.clear();
    }

    @Override
    public String dumpActiveAtomicOperations() {
        if (!this.trackAtomicOperations) {
            this.activeAtomicOperations.clear();
        }
        StringWriter writer = new StringWriter();
        writer.append("List of active atomic operations: \r\n");
        writer.append("------------------------------------------------------------------------------------------------\r\n");
        for (Map.Entry<OOperationUnitId, OPair<String, StackTraceElement[]>> entry : this.activeAtomicOperations.entrySet()) {
            writer.append("Operation unit id :").append(entry.getKey().toString()).append("\r\n");
            writer.append("Started at thread : ").append((CharSequence)entry.getValue().getKey()).append("\r\n");
            writer.append("Stack trace of method which started this operation : \r\n");
            StackTraceElement[] stackTraceElements = entry.getValue().getValue();
            for (int i = 1; i < stackTraceElements.length; ++i) {
                writer.append("\tat ").append(stackTraceElements[i].toString()).append("\r\n");
            }
            writer.append("\r\n\r\n");
        }
        writer.append("-------------------------------------------------------------------------------------------------\r\n");
        return writer.toString();
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (currentOperation == null) {
                    currentOperation = new ThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                currentOperation = null;
            }
        });
    }
}

