/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import com.orientechnologies.common.concur.resource.OSharedContainer;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OCurrentStorageComponentsFactory;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.OMetadataInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

public abstract class OStorageAbstract
implements OStorage,
OSharedContainer {
    public static final ThreadGroup storageThreadGroup;
    protected final String url;
    protected final String mode;
    protected final OSharedResourceAdaptiveExternal dataLock;
    protected final OReadersWriterSpinLock stateLock;
    protected volatile OStorageConfiguration configuration;
    protected volatile OCurrentStorageComponentsFactory componentsFactory;
    protected String name;
    protected AtomicLong version = new AtomicLong();
    protected volatile OStorage.STATUS status = OStorage.STATUS.CLOSED;
    private final OSharedContainerImpl sharedContainer = new OSharedContainerImpl();

    public OStorageAbstract(String name, String iURL, String mode, int timeout) {
        this.name = OStringSerializerHelper.contains(name, '/') ? name.substring(name.lastIndexOf("/") + 1) : name;
        if (OStringSerializerHelper.contains(name, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.url = iURL;
        this.mode = mode;
        this.dataLock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), timeout, true);
        this.stateLock = new OReadersWriterSpinLock();
    }

    @Override
    public abstract OCluster getClusterByName(String var1);

    @Override
    public OStorage getUnderlying() {
        return this;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isClosed() {
        return this.status == OStorage.STATUS.CLOSED;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && !ppos.recordVersion.isTombstone();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void close() {
        this.close(false, false);
    }

    @Override
    public void close(boolean iForce, boolean onDelete) {
        this.sharedContainer.clearResources();
    }

    @Override
    public boolean existsResource(String iName) {
        return this.sharedContainer.existsResource(iName);
    }

    @Override
    public <T> T removeResource(String iName) {
        return this.sharedContainer.removeResource(iName);
    }

    @Override
    public <T> T getResource(String iName, Callable<T> iCallback) {
        return this.sharedContainer.getResource(iName, iCallback);
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public boolean dropCluster(String iClusterName, boolean iTruncate) {
        return this.dropCluster(this.getClusterIdByName(iClusterName), iTruncate);
    }

    @Override
    public long countRecords() {
        long tot = 0L;
        for (OCluster oCluster : this.getClusterInstances()) {
            if (oCluster == null) continue;
            tot += oCluster.getEntries() - oCluster.getTombstonesCount();
        }
        return tot;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    @Override
    public OStorage.STATUS getStatus() {
        return this.status;
    }

    @Override
    public void checkForClusterPermissions(String iClusterName) {
        OMetadata metaData = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata();
        if (metaData != null) {
            Set<OClass> classes = ((OMetadataInternal)metaData).getImmutableSchemaSnapshot().getClassesRelyOnCluster(iClusterName);
            for (OClass c : classes) {
                if (!c.isSubClassOf("ORestricted")) continue;
                throw new OSecurityException("Class '" + c.getName() + "' cannot be truncated because has record level security enabled (extends '" + "ORestricted" + "')");
            }
        }
    }

    @Override
    public boolean isDistributed() {
        return false;
    }

    @Override
    public boolean isAssigningClusterIds() {
        return true;
    }

    @Override
    public OCurrentStorageComponentsFactory getComponentsFactory() {
        return this.componentsFactory;
    }

    @Override
    public long getLastOperationId() {
        return 0L;
    }

    static {
        ThreadGroup parentThreadGroup;
        ThreadGroup parentThreadGroupBackup = parentThreadGroup = Thread.currentThread().getThreadGroup();
        boolean found = false;
        while (parentThreadGroup.getParent() != null) {
            if (parentThreadGroup.equals(Orient.instance().getThreadGroup())) {
                parentThreadGroup = parentThreadGroup.getParent();
                found = true;
                break;
            }
            parentThreadGroup = parentThreadGroup.getParent();
        }
        if (!found) {
            parentThreadGroup = parentThreadGroupBackup;
        }
        storageThreadGroup = new ThreadGroup(parentThreadGroup, "OrientDB Storage");
    }
}

