/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OFromClause;
import com.orientechnologies.orient.core.sql.parser.OLimit;
import com.orientechnologies.orient.core.sql.parser.OProjection;
import com.orientechnologies.orient.core.sql.parser.OStatement;
import com.orientechnologies.orient.core.sql.parser.OTimeout;
import com.orientechnologies.orient.core.sql.parser.OUpdateOperations;
import com.orientechnologies.orient.core.sql.parser.OWhereClause;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OUpdateStatement
extends OStatement {
    protected OFromClause target;
    protected List<OUpdateOperations> operations = new ArrayList<OUpdateOperations>();
    protected boolean upsert = false;
    protected boolean returnBefore = false;
    protected boolean returnAfter = false;
    protected OProjection returnProjection;
    protected OWhereClause whereClause;
    protected boolean lockRecord = false;
    protected OLimit limit;
    protected OTimeout timeout;

    public OUpdateStatement(int id) {
        super(id);
    }

    public OUpdateStatement(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("UPDATE ");
        result.append(this.target.toString());
        for (OUpdateOperations ops : this.operations) {
            result.append(" ");
            result.append(ops.toString());
        }
        if (this.upsert) {
            result.append(" UPSERT");
        }
        if (this.returnBefore || this.returnAfter) {
            result.append(" RETURN");
            if (this.returnBefore) {
                result.append(" BEFORE");
            } else {
                result.append(" AFTER");
            }
            if (this.returnProjection != null) {
                result.append(" ");
                result.append(this.returnProjection.toString());
            }
        }
        if (this.whereClause != null) {
            result.append(" WHERE ");
            result.append(this.whereClause.toString());
        }
        if (this.lockRecord) {
            result.append(" LOCK RECORD");
        }
        if (this.limit != null) {
            result.append(this.limit);
        }
        if (this.timeout != null) {
            result.append(this.timeout);
        }
        return result.toString();
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        if (this.target != null) {
            this.target.replaceParameters(params);
        }
        for (OUpdateOperations ops : this.operations) {
            ops.replaceParameters(params);
        }
        if (this.returnProjection != null) {
            this.returnProjection.replaceParameters(params);
        }
        if (this.whereClause != null) {
            this.whereClause.replaceParameters(params);
        }
        if (this.limit != null) {
            this.limit.replaceParameters(params);
        }
    }
}

