/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import com.orientechnologies.orient.core.sql.parser.SimpleNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OMathExpression
extends SimpleNode {
    protected List<OMathExpression> childExpressions = new ArrayList<OMathExpression>();
    protected List<Operator> operators = new ArrayList<Operator>();

    public OMathExpression(int id) {
        super(id);
    }

    public OMathExpression(OrientSql p, int id) {
        super(p, id);
    }

    public void replaceParameters(Map<Object, Object> params) {
        if (this.childExpressions != null) {
            for (OMathExpression expr : this.childExpressions) {
                expr.replaceParameters(params);
            }
        }
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    public List<OMathExpression> getChildExpressions() {
        return this.childExpressions;
    }

    public void setChildExpressions(List<OMathExpression> childExpressions) {
        this.childExpressions = childExpressions;
    }

    public Object createExecutorFilter() {
        return null;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.childExpressions.size(); ++i) {
            if (i > 0) {
                result.append(" ");
                switch (this.operators.get(i - 1)) {
                    case PLUS: {
                        result.append("+");
                        break;
                    }
                    case MINUS: {
                        result.append("-");
                        break;
                    }
                    case STAR: {
                        result.append("*");
                        break;
                    }
                    case SLASH: {
                        result.append("/");
                        break;
                    }
                    case REM: {
                        result.append("%");
                    }
                }
                result.append(" ");
            }
            result.append(this.childExpressions.get(i).toString());
        }
        return result.toString();
    }

    protected boolean supportsBasicCalculation() {
        for (OMathExpression expr : this.childExpressions) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    public static enum Operator {
        PLUS,
        MINUS,
        STAR,
        SLASH,
        REM;

    }
}

