/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OInputParameter;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OMatchesCondition
extends OBooleanExpression {
    protected OExpression expression;
    protected String right;
    protected OInputParameter rightParam;
    protected Object paramValue;

    public OMatchesCondition(int id) {
        super(id);
    }

    public OMatchesCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord) {
        return false;
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        Object paramResult;
        this.expression.replaceParameters(params);
        if (this.rightParam != null && this.rightParam != (paramResult = this.rightParam.bindFromInputParams(params))) {
            this.paramValue = paramResult;
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.expression.toString());
        result.append(" MATCHES ");
        if (this.rightParam != null) {
            if (this.paramValue != null) {
                if (this.paramValue instanceof String) {
                    this.paramValue = OExpression.encode((String)this.paramValue);
                    result.append("\"" + this.paramValue + "\"");
                }
            } else {
                result.append(this.rightParam);
            }
        } else if (this.right != null) {
            result.append(this.right);
        }
        return result.toString();
    }

    @Override
    public boolean supportsBasicCalculation() {
        return this.expression.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        if (this.expression != null && !this.expression.supportsBasicCalculation()) {
            return 1;
        }
        return 0;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        if (this.expression != null && !this.expression.supportsBasicCalculation()) {
            return Collections.singletonList(this.expression);
        }
        return Collections.EMPTY_LIST;
    }
}

