/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OExpression;
import com.orientechnologies.orient.core.sql.parser.OOrBlock;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import com.orientechnologies.orient.core.sql.parser.OrientSqlVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OContainsAllCondition
extends OBooleanExpression {
    protected OExpression left;
    protected OExpression right;
    protected OOrBlock rightBlock;

    public OContainsAllCondition(int id) {
        super(id);
    }

    public OContainsAllCondition(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OrientSqlVisitor visitor, Object data) {
        return visitor.visit(this, data);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord) {
        return false;
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        this.left.replaceParameters(params);
        if (this.right != null) {
            this.right.replaceParameters(params);
        }
        if (this.rightBlock != null) {
            this.rightBlock.replaceParameters(params);
        }
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.left.toString());
        result.append(" CONTAINSALL ");
        if (this.right != null) {
            result.append(this.right.toString());
        } else if (this.rightBlock != null) {
            result.append("(");
            result.append(this.rightBlock.toString());
            result.append(")");
        }
        return result.toString();
    }

    public OExpression getLeft() {
        return this.left;
    }

    public void setLeft(OExpression left) {
        this.left = left;
    }

    public OExpression getRight() {
        return this.right;
    }

    public void setRight(OExpression right) {
        this.right = right;
    }

    @Override
    public boolean supportsBasicCalculation() {
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            return false;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            return false;
        }
        return this.rightBlock == null || this.rightBlock.supportsBasicCalculation();
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int total = 0;
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            ++total;
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            ++total;
        }
        if (this.rightBlock != null && !this.rightBlock.supportsBasicCalculation()) {
            ++total;
        }
        return total;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.left != null && !this.left.supportsBasicCalculation()) {
            result.add(this.left);
        }
        if (this.right != null && !this.right.supportsBasicCalculation()) {
            result.add(this.right);
        }
        if (this.rightBlock != null) {
            result.addAll(this.rightBlock.getExternalCalculationConditions());
        }
        return result;
    }
}

