/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.parser;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.parser.OBooleanExpression;
import com.orientechnologies.orient.core.sql.parser.OrientSql;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class OAndBlock
extends OBooleanExpression {
    List<OBooleanExpression> subBlocks = new ArrayList<OBooleanExpression>();

    public OAndBlock(int id) {
        super(id);
    }

    public OAndBlock(OrientSql p, int id) {
        super(p, id);
    }

    @Override
    public boolean evaluate(OIdentifiable currentRecord) {
        if (this.getSubBlocks() == null) {
            return true;
        }
        for (OBooleanExpression block : this.subBlocks) {
            if (block.evaluate(currentRecord)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void replaceParameters(Map<Object, Object> params) {
        for (OBooleanExpression sub : this.subBlocks) {
            sub.replaceParameters(params);
        }
    }

    public List<OBooleanExpression> getSubBlocks() {
        return this.subBlocks;
    }

    public void setSubBlocks(List<OBooleanExpression> subBlocks) {
        this.subBlocks = subBlocks;
    }

    @Override
    public String toString() {
        if (this.subBlocks == null || this.subBlocks.size() == 0) {
            return "";
        }
        if (this.subBlocks.size() == 1) {
            return this.subBlocks.get(0).toString();
        }
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (OBooleanExpression expr : this.subBlocks) {
            if (!first) {
                result.append(" AND ");
            }
            result.append(expr.toString());
            first = false;
        }
        return result.toString();
    }

    @Override
    protected boolean supportsBasicCalculation() {
        for (OBooleanExpression expr : this.subBlocks) {
            if (expr.supportsBasicCalculation()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int getNumberOfExternalCalculations() {
        int result = 0;
        for (OBooleanExpression expr : this.subBlocks) {
            result += expr.getNumberOfExternalCalculations();
        }
        return result;
    }

    @Override
    protected List<Object> getExternalCalculationConditions() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (OBooleanExpression expr : this.subBlocks) {
            result.addAll(expr.getExternalCalculationConditions());
        }
        return result;
    }
}

