/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OQueryOperatorTraverse
extends OQueryOperatorEqualityNotNulls {
    private int startDeepLevel = 0;
    private int endDeepLevel = -1;
    private String[] cfgFields;

    public OQueryOperatorTraverse() {
        super("TRAVERSE", 5, false, 1, true);
    }

    public OQueryOperatorTraverse(int startDeepLevel, int endDeepLevel, String[] iFieldList) {
        this();
        this.startDeepLevel = startDeepLevel;
        this.endDeepLevel = endDeepLevel;
        this.cfgFields = iFieldList;
    }

    @Override
    public String getSyntax() {
        return "<left> TRAVERSE[(<begin-deep-level> [,<maximum-deep-level> [,<fields>]] )] ( <conditions> )";
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        Object target;
        OSQLFilterCondition condition;
        if (iCondition.getLeft() instanceof OSQLFilterCondition) {
            condition = (OSQLFilterCondition)iCondition.getLeft();
            target = iRight;
        } else {
            condition = (OSQLFilterCondition)iCondition.getRight();
            target = iLeft;
        }
        HashSet<ORID> evaluatedRecords = new HashSet<ORID>();
        return this.traverse(target, condition, 0, evaluatedRecords, iContext);
    }

    private boolean traverse(Object iTarget, OSQLFilterCondition iCondition, int iLevel, Set<ORID> iEvaluatedRecords, OCommandContext iContext) {
        block24: {
            block23: {
                if (this.endDeepLevel > -1 && iLevel > this.endDeepLevel) {
                    return false;
                }
                if (iTarget instanceof OIdentifiable) {
                    if (iEvaluatedRecords.contains(((OIdentifiable)iTarget).getIdentity())) {
                        return false;
                    }
                    iTarget = ((OIdentifiable)iTarget).getRecord();
                }
                if (!(iTarget instanceof ODocument)) break block23;
                ODocument target = (ODocument)iTarget;
                iEvaluatedRecords.add(target.getIdentity());
                if (target.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                    try {
                        target.load();
                    }
                    catch (ORecordNotFoundException e) {
                        return false;
                    }
                }
                if (iLevel >= this.startDeepLevel && (Boolean)iCondition.evaluate(target, null, iContext) == Boolean.TRUE) {
                    return true;
                }
                if (this.cfgFields == null) break block24;
                for (String cfgField : this.cfgFields) {
                    if (cfgField.equalsIgnoreCase("ANY()")) {
                        for (String fieldName : target.fieldNames()) {
                            if (!this.traverse(target.rawField(fieldName), iCondition, iLevel + 1, iEvaluatedRecords, iContext)) continue;
                            return true;
                        }
                        continue;
                    }
                    if (cfgField.equalsIgnoreCase("ANY()")) {
                        for (String fieldName : target.fieldNames()) {
                            if (this.traverse(target.rawField(fieldName), iCondition, iLevel + 1, iEvaluatedRecords, iContext)) continue;
                            return false;
                        }
                        return true;
                    }
                    if (!this.traverse(target.rawField(cfgField), iCondition, iLevel + 1, iEvaluatedRecords, iContext)) continue;
                    return true;
                }
                break block24;
            }
            if (iTarget instanceof OQueryRuntimeValueMulti) {
                OQueryRuntimeValueMulti multi = (OQueryRuntimeValueMulti)iTarget;
                for (Object o : multi.getValues()) {
                    if (this.traverse(o, iCondition, iLevel + 1, iEvaluatedRecords, iContext) != Boolean.TRUE.booleanValue()) continue;
                    return true;
                }
            } else if (iTarget instanceof Map) {
                Map map = (Map)iTarget;
                for (Object o : map.values()) {
                    if (this.traverse(o, iCondition, iLevel + 1, iEvaluatedRecords, iContext) != Boolean.TRUE.booleanValue()) continue;
                    return true;
                }
            } else if (OMultiValue.isMultiValue(iTarget)) {
                Iterable<Object> collection = OMultiValue.getMultiValueIterable(iTarget);
                for (Object o : collection) {
                    if (this.traverse(o, iCondition, iLevel + 1, iEvaluatedRecords, iContext) != Boolean.TRUE.booleanValue()) continue;
                    return true;
                }
            } else if (iTarget instanceof Iterator) {
                Iterator iterator = (Iterator)iTarget;
                while (iterator.hasNext()) {
                    if (this.traverse(iterator.next(), iCondition, iLevel + 1, iEvaluatedRecords, iContext) != Boolean.TRUE.booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public OQueryOperator configure(List<String> iParams) {
        if (iParams == null) {
            return this;
        }
        int start = !iParams.isEmpty() ? Integer.parseInt(iParams.get(0)) : this.startDeepLevel;
        int end = iParams.size() > 1 ? Integer.parseInt(iParams.get(1)) : this.endDeepLevel;
        String[] fields = new String[]{"any()"};
        if (iParams.size() > 2) {
            String f = iParams.get(2);
            if (f.startsWith("'") || f.startsWith("\"")) {
                f = f.substring(1, f.length() - 1);
            }
            fields = f.split(",");
        }
        return new OQueryOperatorTraverse(start, end, fields);
    }

    public int getStartDeepLevel() {
        return this.startDeepLevel;
    }

    public int getEndDeepLevel() {
        return this.endDeepLevel;
    }

    public String[] getCfgFields() {
        return this.cfgFields;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public String toString() {
        return String.format("%s(%d,%d,%s)", this.keyword, this.startDeepLevel, this.endDeepLevel, Arrays.toString(this.cfgFields));
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

