/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.method.misc;

import com.orientechnologies.common.collection.OMultiCollectionIterator;
import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.ArrayList;
import java.util.Collection;

public class OSQLMethodField
extends OAbstractSQLMethod {
    public static final String NAME = "field";

    public OSQLMethodField() {
        super(NAME, 1, 1);
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iParams[0] == null) {
            return null;
        }
        String paramAsString = iParams[0].toString();
        if (ioResult != null) {
            if (ioResult instanceof String) {
                try {
                    ioResult = new ODocument(new ORecordId((String)ioResult));
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Error on reading rid with value '%s'", null, ioResult);
                    ioResult = null;
                }
            } else if (ioResult instanceof OIdentifiable) {
                ioResult = ((OIdentifiable)ioResult).getRecord();
            } else if (ioResult instanceof Collection || ioResult instanceof OMultiCollectionIterator || ioResult.getClass().isArray()) {
                ArrayList<Object> result = new ArrayList<Object>(OMultiValue.getSize(ioResult));
                for (Object o : OMultiValue.getMultiValueIterable(ioResult)) {
                    Object newlyAdded = ODocumentHelper.getFieldValue(o, paramAsString);
                    if (OMultiValue.isMultiValue(newlyAdded)) {
                        for (Object item : OMultiValue.getMultiValueIterable(newlyAdded)) {
                            result.add(item);
                        }
                        continue;
                    }
                    result.add(newlyAdded);
                }
                return result;
            }
        }
        if (!"*".equals(paramAsString) && ioResult != null) {
            ioResult = ioResult instanceof OCommandContext ? ((OCommandContext)ioResult).getVariable(paramAsString) : ODocumentHelper.getFieldValue(ioResult, paramAsString, iContext);
        }
        return ioResult;
    }

    @Override
    public boolean evaluateParameters() {
        return false;
    }
}

