/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.method.misc.OAbstractSQLMethod;
import java.util.ArrayList;
import java.util.Map;

public class OSQLMethodInclude
extends OAbstractSQLMethod {
    public static final String NAME = "include";

    public OSQLMethodInclude() {
        super(NAME, 1, -1);
    }

    @Override
    public String getSyntax() {
        return "Syntax error: include([<field-name>][,]*)";
    }

    @Override
    public Object execute(Object iThis, OIdentifiable iCurrentRecord, OCommandContext iContext, Object ioResult, Object[] iParams) {
        if (iParams[0] != null) {
            if (iThis instanceof ODocument) {
                return this.copy((ODocument)iThis, iParams);
            }
            if (iThis instanceof Map) {
                return this.copy((Map)iThis, iParams);
            }
            if (OMultiValue.isMultiValue(iThis)) {
                ArrayList<Object> result = new ArrayList<Object>(OMultiValue.getSize(iThis));
                for (Object o : OMultiValue.getMultiValueIterable(iThis)) {
                    if (!(o instanceof OIdentifiable)) continue;
                    result.add(this.copy((ODocument)((OIdentifiable)o).getRecord(), iParams));
                }
                return result;
            }
        }
        return null;
    }

    private Object copy(ODocument document, Object[] iFieldNames) {
        ODocument doc = new ODocument();
        for (int i = 0; i < iFieldNames.length; ++i) {
            if (iFieldNames[i] == null) continue;
            String fieldName = iFieldNames[i].toString();
            doc.field(fieldName, document.field(fieldName));
        }
        return doc;
    }

    private Object copy(Map map, Object[] iFieldNames) {
        ODocument doc = new ODocument();
        for (int i = 0; i < iFieldNames.length; ++i) {
            if (iFieldNames[i] == null) continue;
            String fieldName = iFieldNames[i].toString();
            doc.field(fieldName, map.get(fieldName));
        }
        return doc;
    }
}

