/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public abstract class OCommandExecutorSQLSetAware
extends OCommandExecutorSQLAbstract {
    protected static final String KEYWORD_SET = "SET";
    protected static final String KEYWORD_CONTENT = "CONTENT";
    protected ODocument content = null;
    protected int parameterCounter = 0;

    protected void parseContent() {
        if (!this.parserIsEnded() && !this.parserGetLastWord().equals("WHERE")) {
            this.content = this.parseJSON();
        }
        if (this.content == null) {
            this.throwSyntaxErrorException("Content not provided. Example: CONTENT { \"name\": \"Jay\" }");
        }
    }

    protected void parseSetFields(OClass iClass, List<OPair<String, Object>> fields) {
        while (!(this.parserIsEnded() || fields.size() != 0 && this.parserGetLastSeparator() != ',' && this.parserGetCurrentChar() != ',')) {
            String fieldName = this.parserRequiredWord(false, "Field name expected");
            if (fieldName.equalsIgnoreCase("WHERE")) {
                this.parserGoBack();
                break;
            }
            this.parserNextChars(false, true, "=");
            String fieldValue = this.parserRequiredWord(false, "Value expected", " =><,\r\n");
            Object v = this.convertValue(iClass, fieldName, this.getFieldValueCountingParameters(fieldValue));
            fields.add(new OPair<String, Object>(fieldName, v));
            this.parserSkipWhiteSpaces();
        }
        if (fields.size() == 0) {
            this.throwParsingException("Entries to set <field> = <value> are missed. Example: name = 'Bill', salary = 300.2");
        }
    }

    protected OClass extractClassFromTarget(String iTarget) {
        if (!iTarget.startsWith("CLUSTER:") && !iTarget.startsWith("INDEX:")) {
            if (iTarget.startsWith("CLASS:")) {
                iTarget = iTarget.substring("CLASS:".length());
            }
            if (iTarget.charAt(0) == '#') {
                return OCommandExecutorSQLSetAware.getDatabase().getMetadata().getSchema().getClassByClusterId(new ORecordId((String)iTarget).clusterId);
            }
            return OCommandExecutorSQLSetAware.getDatabase().getMetadata().getSchema().getClass(iTarget);
        }
        return null;
    }

    protected Object convertValue(OClass iClass, String fieldName, Object v) {
        OProperty p;
        if (iClass != null && (p = iClass.getProperty(fieldName)) != null) {
            OClass embeddedType = p.getLinkedClass();
            switch (p.getType()) {
                case EMBEDDED: {
                    if (!(v instanceof Map)) break;
                    v = this.createDocumentFromMap(embeddedType, (Map<String, Object>)((Object)v));
                    break;
                }
                case EMBEDDEDSET: {
                    if (v instanceof Map) {
                        return this.createDocumentFromMap(embeddedType, (Map<String, Object>)((Object)v));
                    }
                    if (!OMultiValue.isMultiValue(v)) break;
                    HashSet<Object> set = new HashSet<Object>();
                    for (Object o : OMultiValue.getMultiValueIterable(v)) {
                        if (o instanceof Map) {
                            ODocument doc = this.createDocumentFromMap(embeddedType, (Map)o);
                            set.add(doc);
                            continue;
                        }
                        if (o instanceof OIdentifiable) {
                            set.add(((OIdentifiable)o).getRecord());
                            continue;
                        }
                        set.add(o);
                    }
                    v = set;
                    break;
                }
                case EMBEDDEDLIST: {
                    if (v instanceof Map) {
                        return this.createDocumentFromMap(embeddedType, (Map<String, Object>)((Object)v));
                    }
                    if (!OMultiValue.isMultiValue(v)) break;
                    ArrayList<Object> set = new ArrayList<Object>();
                    for (Object o : OMultiValue.getMultiValueIterable(v)) {
                        if (o instanceof Map) {
                            ODocument doc = this.createDocumentFromMap(embeddedType, (Map)o);
                            set.add(doc);
                            continue;
                        }
                        if (o instanceof OIdentifiable) {
                            set.add(((OIdentifiable)o).getRecord());
                            continue;
                        }
                        set.add(o);
                    }
                    v = set;
                    break;
                }
                case EMBEDDEDMAP: {
                    if (!(v instanceof Map)) break;
                    HashMap map = new HashMap();
                    for (Map.Entry entry : ((Map)((Object)v)).entrySet()) {
                        if (entry.getValue() instanceof Map) {
                            ODocument doc = this.createDocumentFromMap(embeddedType, (Map)entry.getValue());
                            map.put(entry.getKey(), doc);
                            continue;
                        }
                        if (entry.getValue() instanceof OIdentifiable) {
                            map.put(entry.getKey(), (ODocument)((OIdentifiable)entry.getValue()).getRecord());
                            continue;
                        }
                        map.put(entry.getKey(), (ODocument)entry.getValue());
                    }
                    v = map;
                }
            }
        }
        return v;
    }

    private ODocument createDocumentFromMap(OClass embeddedType, Map<String, Object> o) {
        ODocument doc = new ODocument();
        if (embeddedType != null) {
            doc.setClassName(embeddedType.getName());
        }
        doc.fromMap(o);
        return doc;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    protected Object getFieldValueCountingParameters(String fieldValue) {
        if (fieldValue.trim().equals("?")) {
            ++this.parameterCounter;
        }
        return OSQLHelper.parseValue(this, fieldValue, this.context);
    }

    protected ODocument parseJSON() {
        String contentAsString = this.parserRequiredWord(false, "JSON expected").trim();
        ODocument json = new ODocument().fromJSON(contentAsString);
        this.parserSkipWhiteSpaces();
        return json;
    }
}

