/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Iterator;
import java.util.Map;

public class OCommandExecutorSQLOptimizeDatabase
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_OPTIMIZE = "OPTIMIZE";
    public static final String KEYWORD_DATABASE = "DATABASE";
    public static final String KEYWORD_EDGE = "-LWEDGES";
    private boolean optimizeEdges = false;
    private int batch = 1000;

    public OCommandExecutorSQLOptimizeDatabase parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLOptimizeDatabase.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_OPTIMIZE)) {
            throw new OCommandSQLParsingException("Keyword OPTIMIZE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLOptimizeDatabase.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_DATABASE)) {
            throw new OCommandSQLParsingException("Keyword DATABASE not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        oldPos = pos;
        pos = OCommandExecutorSQLOptimizeDatabase.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (word.toString().equals(KEYWORD_EDGE)) {
            this.optimizeEdges = true;
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        StringBuilder result = new StringBuilder();
        if (this.optimizeEdges) {
            result.append(this.optimizeEdges());
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String optimizeEdges() {
        ODatabaseDocumentInternal db = OCommandExecutorSQLOptimizeDatabase.getDatabase();
        long transformed = 0L;
        if (db.getTransaction().isActive()) {
            db.commit();
        }
        db.begin();
        try {
            for (ODocument doc : db.browseClass("E")) {
                if (Thread.currentThread().isInterrupted()) break;
                if (doc == null || doc.fields() != 2) continue;
                ORID edgeIdentity = doc.getIdentity();
                ODocument outV = (ODocument)doc.field("out");
                ODocument inV = (ODocument)doc.field("in");
                Object outField = outV.field("out_" + doc.getClassName());
                if (outField instanceof ORidBag) {
                    Iterator<OIdentifiable> it = ((ORidBag)outField).iterator();
                    while (it.hasNext()) {
                        OIdentifiable v = it.next();
                        if (!edgeIdentity.equals(v)) continue;
                        it.remove();
                        ((ORidBag)outField).add(inV.getIdentity());
                        break;
                    }
                }
                outV.save();
                Object inField = inV.field("in_" + doc.getClassName());
                if (outField instanceof ORidBag) {
                    Iterator<OIdentifiable> it = ((ORidBag)inField).iterator();
                    while (it.hasNext()) {
                        OIdentifiable v = it.next();
                        if (!edgeIdentity.equals(v)) continue;
                        it.remove();
                        ((ORidBag)inField).add(outV.getIdentity());
                        break;
                    }
                }
                inV.save();
                doc.delete();
                if (++transformed % (long)this.batch != 0L) continue;
                db.commit();
                db.begin();
            }
            db.commit();
        }
        finally {
            if (db.getTransaction().isActive()) {
                db.rollback();
            }
        }
        return "Transformed " + transformed + " regular edges in lightweight edges";
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public String getSyntax() {
        return "OPTIMIZE DATABASE [-lwedges]";
    }
}

