/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.Map;

public class OCommandExecutorSQLDropClass
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_CLASS = "CLASS";
    public static final String KEYWORD_UNSAFE = "UNSAFE";
    private String className;
    private boolean unsafe;

    public OCommandExecutorSQLDropClass parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLDropClass.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropClass.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.parserText, oldPos);
        }
        if ((pos = OCommandExecutorSQLDropClass.nextWord(this.parserText, this.parserTextUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>. Use " + this.getSyntax(), this.parserText, pos);
        }
        this.className = word.toString();
        if ((pos = OCommandExecutorSQLDropClass.nextWord(this.parserText, this.parserTextUpperCase, pos, word, true)) > -1 && KEYWORD_UNSAFE.equalsIgnoreCase(word.toString())) {
            this.unsafe = true;
        }
        return this;
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLDropClass.getDatabase();
        OClass cls = database.getMetadata().getSchema().getClass(this.className);
        if (cls == null) {
            return null;
        }
        long records = cls.count(true);
        if (records > 0L && !this.unsafe) {
            if (cls.isSubClassOf("V")) {
                throw new OCommandExecutionException("'DROP CLASS' command cannot drop class '" + this.className + "' because it contains Vertices. Use 'DELETE VERTEX' command first to avoid broken edges in a database, or apply the 'UNSAFE' keyword to force it");
            }
            if (cls.isSubClassOf("E")) {
                throw new OCommandExecutionException("'DROP CLASS' command cannot drop class '" + this.className + "' because it contains Edges. Use 'DELETE EDGE' command first to avoid broken vertices in a database, or apply the 'UNSAFE' keyword to force it");
            }
        }
        database.getMetadata().getSchema().dropClass(this.className);
        if (records > 0L && this.unsafe) {
            if (cls.isSubClassOf("V")) {
                if (this.unsafe) {
                    OLogManager.instance().warn((Object)this, "Dropped class '%s' containing %d vertices using UNSAFE mode. Database could contain broken edges", this.className, records);
                }
            } else if (cls.isSubClassOf("E")) {
                OLogManager.instance().warn((Object)this, "Dropped class '%s' containing %d edges using UNSAFE mode. Database could contain broken vertices", this.className, records);
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "DROP CLASS <class> [UNSAFE]";
    }

    @Override
    public boolean involveSchema() {
        return true;
    }
}

