/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandDistributedReplicateRequest;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class OCommandExecutorSQLCreateProperty
extends OCommandExecutorSQLAbstract
implements OCommandDistributedReplicateRequest {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_PROPERTY = "PROPERTY";
    private String className;
    private String fieldName;
    private OType type;
    private String linked;
    private boolean unsafe = false;

    public OCommandExecutorSQLCreateProperty parse(OCommandRequest iRequest) {
        this.init((OCommandRequestText)iRequest);
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found", this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_PROPERTY)) {
            throw new OCommandSQLParsingException("Keyword PROPERTY not found", this.parserText, oldPos);
        }
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.parserText, oldPos);
        }
        String[] parts = this.split(word);
        if (parts.length != 2) {
            throw new OCommandSQLParsingException("Expected <class>.<property>", this.parserText, oldPos);
        }
        this.className = parts[0];
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class not found", this.parserText, oldPos);
        }
        this.fieldName = parts[1];
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Missed property type", this.parserText, oldPos);
        }
        this.type = OType.valueOf(word.toString());
        oldPos = pos;
        if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
            return this;
        }
        if (word.toString().equals("UNSAFE")) {
            this.unsafe = true;
        } else {
            this.linked = word.toString();
            oldPos = pos;
            if ((pos = OCommandExecutorSQLCreateProperty.nextWord(this.parserText, this.parserTextUpperCase, oldPos, word, false)) == -1) {
                return this;
            }
            if (word.toString().equals("UNSAFE")) {
                this.unsafe = true;
            }
        }
        return this;
    }

    private String[] split(StringBuilder word) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean quoted = false;
        for (char c : word.toString().toCharArray()) {
            if (!quoted) {
                if (c == '`') {
                    quoted = true;
                    continue;
                }
                if (c == '.') {
                    String nextToken = builder.toString().trim();
                    if (nextToken.length() > 0) {
                        result.add(nextToken);
                    }
                    builder = new StringBuilder();
                    continue;
                }
                builder.append(c);
                continue;
            }
            if (c == '`') {
                quoted = false;
                continue;
            }
            builder.append(c);
        }
        String nextToken = builder.toString().trim();
        if (nextToken.length() > 0) {
            result.add(nextToken);
        }
        return result.toArray(new String[0]);
    }

    @Override
    public long getDistributedTimeout() {
        return OGlobalConfiguration.DISTRIBUTED_COMMAND_TASK_SYNCH_TIMEOUT.getValueAsLong();
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.type == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseDocumentInternal database = OCommandExecutorSQLCreateProperty.getDatabase();
        OClassImpl sourceClass = (OClassImpl)database.getMetadata().getSchema().getClass(this.className);
        if (sourceClass == null) {
            throw new OCommandExecutionException("Source class '" + this.className + "' not found");
        }
        OPropertyImpl prop = (OPropertyImpl)sourceClass.getProperty(this.fieldName);
        if (prop != null) {
            throw new OCommandExecutionException("Property '" + this.className + "." + this.fieldName + "' already exists. Remove it before to retry.");
        }
        OClass linkedClass = null;
        OType linkedType = null;
        if (this.linked != null && (linkedClass = database.getMetadata().getSchema().getClass(this.linked)) == null) {
            linkedType = OType.valueOf(this.linked.toUpperCase(Locale.ENGLISH));
        }
        sourceClass.addPropertyInternal(this.fieldName, this.type, linkedType, linkedClass, !this.unsafe);
        return sourceClass.properties().size();
    }

    @Override
    public OCommandDistributedReplicateRequest.QUORUM_TYPE getQuorumType() {
        return OCommandDistributedReplicateRequest.QUORUM_TYPE.ALL;
    }

    @Override
    public String getSyntax() {
        return "CREATE PROPERTY <class>.<property> <type> [<linked-type>|<linked-class>] [UNSAFE]";
    }
}

