/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstractCursor;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexKeyCursor;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class OChainedIndexProxy<T>
implements OIndex<T> {
    private final OIndex<T> firstIndex;
    private final List<OIndex<?>> indexChain;
    private final OIndex<?> lastIndex;

    private OChainedIndexProxy(List<OIndex<?>> indexChain) {
        this.firstIndex = indexChain.get(0);
        this.indexChain = Collections.unmodifiableList(indexChain);
        this.lastIndex = indexChain.get(indexChain.size() - 1);
    }

    public static <T> Collection<OChainedIndexProxy<T>> createProxies(OClass iSchemaClass, OSQLFilterItemField.FieldChain longChain) {
        ArrayList<OChainedIndexProxy<T>> proxies = new ArrayList<OChainedIndexProxy<T>>();
        for (List<OIndex<?>> indexChain : OChainedIndexProxy.getIndexesForChain(iSchemaClass, longChain)) {
            proxies.add(new OChainedIndexProxy<T>(indexChain));
        }
        return proxies;
    }

    private static boolean isComposite(OIndex<?> currentIndex) {
        return currentIndex.getDefinition().getParamCount() > 1;
    }

    private static Iterable<List<OIndex<?>>> getIndexesForChain(OClass iSchemaClass, OSQLFilterItemField.FieldChain fieldChain) {
        List<OIndex<?>> baseIndexes = OChainedIndexProxy.prepareBaseIndexes(iSchemaClass, fieldChain);
        if (baseIndexes == null) {
            return Collections.emptyList();
        }
        Collection<OIndex<?>> lastIndexes = OChainedIndexProxy.prepareLastIndexVariants(iSchemaClass, fieldChain);
        ArrayList result = new ArrayList();
        for (OIndex<?> lastIndex : lastIndexes) {
            ArrayList indexes = new ArrayList(fieldChain.getItemCount());
            indexes.addAll(baseIndexes);
            indexes.add(lastIndex);
            result.add(indexes);
        }
        return result;
    }

    private static Collection<OIndex<?>> prepareLastIndexVariants(OClass iSchemaClass, OSQLFilterItemField.FieldChain fieldChain) {
        OClass oClass = iSchemaClass;
        ArrayList result = new ArrayList();
        for (int i = 0; i < fieldChain.getItemCount() - 1; ++i) {
            if ((oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass()) != null) continue;
            return result;
        }
        TreeSet involvedIndexes = new TreeSet(new Comparator<OIndex<?>>(){

            @Override
            public int compare(OIndex<?> o1, OIndex<?> o2) {
                return o1.getDefinition().getParamCount() - o2.getDefinition().getParamCount();
            }
        });
        involvedIndexes.addAll(oClass.getInvolvedIndexes(fieldChain.getItemName(fieldChain.getItemCount() - 1)));
        HashSet indexTypes = new HashSet(3);
        for (OIndex oIndex : involvedIndexes) {
            if (indexTypes.contains(oIndex.getInternal().getClass())) continue;
            result.add(oIndex);
            indexTypes.add(oIndex.getInternal().getClass());
        }
        return result;
    }

    private static List<OIndex<?>> prepareBaseIndexes(OClass iSchemaClass, OSQLFilterItemField.FieldChain fieldChain) {
        ArrayList result = new ArrayList(fieldChain.getItemCount() - 1);
        OClass oClass = iSchemaClass;
        for (int i = 0; i < fieldChain.getItemCount() - 1; ++i) {
            Set<OIndex<?>> involvedIndexes = oClass.getInvolvedIndexes(fieldChain.getItemName(i));
            OIndex<?> bestIndex = OChainedIndexProxy.findBestIndex(involvedIndexes);
            if (bestIndex == null) {
                return null;
            }
            result.add(bestIndex);
            oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass();
        }
        return result;
    }

    protected static OIndex<?> findBestIndex(Iterable<OIndex<?>> indexes) {
        OIndex<?> bestIndex = null;
        for (OIndex<?> index : indexes) {
            if (OChainedIndexProxy.priorityOfUsage(index) <= OChainedIndexProxy.priorityOfUsage(bestIndex)) continue;
            bestIndex = index;
        }
        return bestIndex;
    }

    private static int priorityOfUsage(OIndex<?> index) {
        if (index == null) {
            return -1;
        }
        OClass.INDEX_TYPE indexType = OClass.INDEX_TYPE.valueOf(index.getType());
        boolean isComposite = OChainedIndexProxy.isComposite(index);
        boolean supportNullValues = OChainedIndexProxy.supportNullValues(index);
        int priority = 1;
        if (isComposite) {
            if (!supportNullValues) {
                return -1;
            }
        } else {
            priority += 10;
        }
        switch (indexType) {
            case UNIQUE_HASH_INDEX: 
            case NOTUNIQUE_HASH_INDEX: {
                if (isComposite) {
                    return -1;
                }
                priority += 10;
                break;
            }
            case UNIQUE: 
            case NOTUNIQUE: {
                priority += 5;
                break;
            }
            case PROXY: 
            case FULLTEXT: 
            case DICTIONARY: 
            case FULLTEXT_HASH_INDEX: 
            case DICTIONARY_HASH_INDEX: 
            case SPATIAL: {
                return -1;
            }
        }
        return priority;
    }

    public static boolean isAppropriateAsBase(OIndex<?> index) {
        return OChainedIndexProxy.priorityOfUsage(index) > 0;
    }

    private static boolean supportNullValues(OIndex<?> index) {
        ODocument metadata = index.getMetadata();
        if (metadata == null) {
            return false;
        }
        Boolean ignoreNullValues = (Boolean)metadata.field("ignoreNullValues");
        return Boolean.FALSE.equals(ignoreNullValues);
    }

    @Override
    public String getDatabaseName() {
        return this.firstIndex.getDatabaseName();
    }

    public List<String> getIndexNames() {
        ArrayList<String> names = new ArrayList<String>(this.indexChain.size());
        for (OIndex<?> oIndex : this.indexChain) {
            names.add(oIndex.getName());
        }
        return names;
    }

    @Override
    public String getName() {
        StringBuilder res = new StringBuilder("IndexChain{");
        List<String> indexNames = this.getIndexNames();
        for (int i = 0; i < indexNames.size(); ++i) {
            String indexName = indexNames.get(i);
            if (i > 0) {
                res.append(", ");
            }
            res.append(indexName);
        }
        res.append("}");
        return res.toString();
    }

    @Override
    public T get(Object iKey) {
        Object lastIndexResult = this.lastIndex.get(iKey);
        HashSet<OIdentifiable> result = new HashSet<OIdentifiable>();
        if (lastIndexResult != null) {
            result.addAll(this.applyTailIndexes(lastIndexResult));
        }
        return (T)result;
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this.lastIndex.getInternal();
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.lastIndex.getDefinition();
    }

    private List<OIdentifiable> applyTailIndexes(Object lastIndexResult) {
        OIndex<?> beforeTheLastIndex = this.indexChain.get(this.indexChain.size() - 2);
        Set<Comparable> currentKeys = this.prepareKeys(beforeTheLastIndex, lastIndexResult);
        for (int j = this.indexChain.size() - 2; j > 0; --j) {
            Set<Object> newKeys;
            OIndex<Comparable> currentIndex = this.indexChain.get(j);
            OIndex<?> nextIndex = this.indexChain.get(j - 1);
            if (OChainedIndexProxy.isComposite(currentIndex)) {
                newKeys = new TreeSet();
                for (Comparable currentKey : currentKeys) {
                    List<OIdentifiable> currentResult = this.getFromCompositeIndex(currentKey, currentIndex);
                    newKeys.addAll(this.prepareKeys(nextIndex, currentResult));
                }
            } else {
                OIndexCursor cursor = currentIndex.iterateEntries(currentKeys, true);
                List<OIdentifiable> keys = this.cursorToList(cursor);
                newKeys = this.prepareKeys(nextIndex, keys);
            }
            this.updateStatistic(currentIndex);
            currentKeys = newKeys;
        }
        return this.applyFirstIndex(currentKeys);
    }

    private List<OIdentifiable> applyFirstIndex(Collection<Comparable> currentKeys) {
        ArrayList<OIdentifiable> result;
        if (OChainedIndexProxy.isComposite(this.firstIndex)) {
            result = new ArrayList();
            for (Comparable key : currentKeys) {
                result.addAll(this.getFromCompositeIndex(key, this.firstIndex));
            }
        } else {
            OIndexCursor cursor = this.firstIndex.iterateEntries(currentKeys, true);
            result = this.cursorToList(cursor);
        }
        this.updateStatistic(this.firstIndex);
        return result;
    }

    private List<OIdentifiable> getFromCompositeIndex(Comparable currentKey, OIndex<?> currentIndex) {
        OIndexCursor cursor = currentIndex.iterateEntriesBetween(currentKey, true, currentKey, true, true);
        return this.cursorToList(cursor);
    }

    private List<OIdentifiable> cursorToList(OIndexCursor cursor) {
        ArrayList<OIdentifiable> currentResult = new ArrayList<OIdentifiable>();
        Map.Entry<Object, OIdentifiable> entry = cursor.nextEntry();
        while (entry != null) {
            currentResult.add(entry.getValue());
            entry = cursor.nextEntry();
        }
        return currentResult;
    }

    private Set<Comparable> prepareKeys(OIndex<?> index, Object keys) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (keys instanceof Collection) {
            TreeSet<Comparable> newKeys = new TreeSet<Comparable>();
            for (Object o : (Collection)keys) {
                newKeys.add((Comparable)indexDefinition.createValue(o));
            }
            return newKeys;
        }
        return Collections.singleton((Comparable)indexDefinition.createValue(keys));
    }

    private void updateStatistic(OIndex<?> index) {
        OProfiler profiler = Orient.instance().getProfiler();
        if (profiler.isRecording()) {
            Orient.instance().getProfiler().updateCounter(profiler.getDatabaseMetric(index.getDatabaseName(), "query.indexUsed"), "Used index in query", 1L);
            int paramCount = index.getDefinition().getParamCount();
            if (paramCount > 1) {
                String profiler_prefix = profiler.getDatabaseMetric(index.getDatabaseName(), "query.compositeIndexUsed");
                profiler.updateCounter(profiler_prefix, "Used composite index in query", 1L);
                profiler.updateCounter(profiler_prefix + "." + paramCount, "Used composite index in query with " + paramCount + " params", 1L);
            }
        }
    }

    @Override
    public ODocument checkEntry(OIdentifiable iRecord, Object iKey) {
        return this.firstIndex.checkEntry(iRecord, iKey);
    }

    @Override
    public OIndex<T> create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean contains(Object iKey) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OType[] getKeyTypes() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    public Iterator<Map.Entry<Object, T>> iterator() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> put(Object iKey, OIdentifiable iValue) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean remove(Object key) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> clear() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    public Iterable<Object> keys() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long getKeySize() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> delete() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void deleteWithoutIndexLoad(String indexName) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getType() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getAlgorithm() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean isAutomatic() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getConfiguration() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getMetadata() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Set<String> getClusters() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Object getFirstKey() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Object getLastKey() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor cursor() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexCursor descCursor() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndexKeyCursor keyCursor() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        OIndexCursor internalCursor = this.lastIndex.iterateEntries(keys, ascSortOrder);
        return new ExternalIndexCursor(internalCursor);
    }

    @Override
    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        OIndexCursor internalCursor = this.lastIndex.iterateEntriesBetween(fromKey, fromInclusive, toKey, toInclusive, ascOrder);
        return new ExternalIndexCursor(internalCursor);
    }

    @Override
    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        OIndexCursor internalCursor = this.lastIndex.iterateEntriesMajor(fromKey, fromInclusive, ascOrder);
        return new ExternalIndexCursor(internalCursor);
    }

    @Override
    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        OIndexCursor internalCursor = this.lastIndex.iterateEntriesMinor(toKey, toInclusive, ascOrder);
        return new ExternalIndexCursor(internalCursor);
    }

    @Override
    public boolean isRebuiding() {
        return false;
    }

    @Override
    public int compareTo(OIndex<T> o) {
        throw new UnsupportedOperationException();
    }

    private final class ExternalIndexCursor
    extends OIndexAbstractCursor {
        private final OIndexCursor internalCursor;
        private final List<OIdentifiable> queryResult = new ArrayList<OIdentifiable>();
        private Iterator<OIdentifiable> currentIterator = OEmptyIterator.IDENTIFIABLE_INSTANCE;

        private ExternalIndexCursor(OIndexCursor internalCursor) {
            this.internalCursor = internalCursor;
        }

        @Override
        public Map.Entry<Object, OIdentifiable> nextEntry() {
            if (this.currentIterator == null) {
                return null;
            }
            while (!this.currentIterator.hasNext()) {
                Map.Entry<Object, OIdentifiable> entry = this.internalCursor.nextEntry();
                if (entry == null) {
                    this.currentIterator = null;
                    return null;
                }
                this.queryResult.clear();
                this.queryResult.addAll(OChainedIndexProxy.this.applyTailIndexes(entry.getValue()));
                this.currentIterator = this.queryResult.iterator();
            }
            if (!this.currentIterator.hasNext()) {
                this.currentIterator = null;
                return null;
            }
            final OIdentifiable result = this.currentIterator.next();
            return new Map.Entry<Object, OIdentifiable>(){

                @Override
                public Object getKey() {
                    throw new UnsupportedOperationException("getKey");
                }

                @Override
                public OIdentifiable getValue() {
                    return result;
                }

                @Override
                public OIdentifiable setValue(OIdentifiable value) {
                    throw new UnsupportedOperationException("setValue");
                }
            };
        }
    }
}

