/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OBinaryTypeSerializer;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.io.IOException;

public class OStreamSerializerOldRIDContainer
implements OStreamSerializer,
OBinarySerializer<OIndexRIDContainer> {
    public static final String NAME = "ic";
    public static final OStreamSerializerOldRIDContainer INSTANCE = new OStreamSerializerOldRIDContainer();
    private static final ORecordSerializerSchemaAware2CSV FORMAT = (ORecordSerializerSchemaAware2CSV)ORecordSerializerFactory.instance().getFormat("ORecordDocument2csv");
    public static final byte ID = 20;

    @Override
    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null) {
            return null;
        }
        String s = OBinaryProtocol.bytes2string(iStream);
        return this.containerFromStream(s);
    }

    @Override
    public byte[] toStream(Object object) throws IOException {
        if (object == null) {
            return null;
        }
        return this.containerToStream((OIndexRIDContainer)object);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int getObjectSize(OIndexRIDContainer object, Object ... hints) {
        byte[] serializedSet = this.containerToStream(object);
        return OBinaryTypeSerializer.INSTANCE.getObjectSize(serializedSet, new Object[0]);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OBinaryTypeSerializer.INSTANCE.getObjectSize(stream, startPosition);
    }

    @Override
    public void serialize(OIndexRIDContainer object, byte[] stream, int startPosition, Object ... hints) {
        byte[] serializedSet = this.containerToStream(object);
        OBinaryTypeSerializer.INSTANCE.serialize(serializedSet, stream, startPosition, new Object[0]);
    }

    @Override
    public OIndexRIDContainer deserialize(byte[] stream, int startPosition) {
        byte[] serializedSet = OBinaryTypeSerializer.INSTANCE.deserialize(stream, startPosition);
        String s = OBinaryProtocol.bytes2string(serializedSet);
        if (s.startsWith("<#@")) {
            return this.containerFromStream(s);
        }
        return (OIndexRIDContainer)FORMAT.embeddedCollectionFromStream(null, OType.EMBEDDEDSET, null, OType.LINK, s);
    }

    @Override
    public byte getId() {
        return 20;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public int getFixedLength() {
        return 0;
    }

    @Override
    public void serializeNativeObject(OIndexRIDContainer object, byte[] stream, int startPosition, Object ... hints) {
        byte[] serializedSet = this.containerToStream(object);
        OBinaryTypeSerializer.INSTANCE.serializeNativeObject(serializedSet, stream, startPosition, new Object[0]);
    }

    @Override
    public OIndexRIDContainer deserializeNativeObject(byte[] stream, int startPosition) {
        byte[] serializedSet = OBinaryTypeSerializer.INSTANCE.deserializeNativeObject(stream, startPosition);
        String s = OBinaryProtocol.bytes2string(serializedSet);
        if (s.startsWith("<#@")) {
            return this.containerFromStream(s);
        }
        return (OIndexRIDContainer)FORMAT.embeddedCollectionFromStream(null, OType.EMBEDDEDSET, null, OType.LINK, s);
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return OBinaryTypeSerializer.INSTANCE.getObjectSizeNative(stream, startPosition);
    }

    @Override
    public void serializeInDirectMemoryObject(OIndexRIDContainer object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        byte[] serializedSet = this.containerToStream(object);
        OBinaryTypeSerializer.INSTANCE.serializeInDirectMemoryObject(serializedSet, pointer, offset, new Object[0]);
    }

    @Override
    public OIndexRIDContainer deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        byte[] serializedSet = OBinaryTypeSerializer.INSTANCE.deserializeFromDirectMemoryObject(pointer, offset);
        String s = OBinaryProtocol.bytes2string(serializedSet);
        if (s.startsWith("<#@")) {
            return this.containerFromStream(s);
        }
        return (OIndexRIDContainer)FORMAT.embeddedCollectionFromStream(null, OType.EMBEDDEDSET, null, OType.LINK, s);
    }

    @Override
    public OIndexRIDContainer deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        byte[] serializedSet = OBinaryTypeSerializer.INSTANCE.deserializeFromDirectMemoryObject(wrapper, offset);
        String s = OBinaryProtocol.bytes2string(serializedSet);
        if (s.startsWith("<#@")) {
            return this.containerFromStream(s);
        }
        return (OIndexRIDContainer)FORMAT.embeddedCollectionFromStream(null, OType.EMBEDDEDSET, null, OType.LINK, s);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return OBinaryTypeSerializer.INSTANCE.getObjectSizeInDirectMemory(pointer, offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return OBinaryTypeSerializer.INSTANCE.getObjectSizeInDirectMemory(wrapper, offset);
    }

    @Override
    public OIndexRIDContainer preprocess(OIndexRIDContainer value, Object ... hints) {
        return value;
    }

    private byte[] containerToStream(OIndexRIDContainer object) {
        StringBuilder iOutput = new StringBuilder();
        iOutput.append("<#@");
        object.checkNotEmbedded();
        OIndexRIDContainerSBTree tree = (OIndexRIDContainerSBTree)object.getUnderlying();
        ODocument document = new ODocument();
        document.field("rootIndex", tree.getRootPointer().getPageIndex());
        document.field("rootOffset", tree.getRootPointer().getPageOffset());
        document.field("file", tree.getName());
        iOutput.append(new String(document.toStream()));
        iOutput.append('>');
        return iOutput.toString().getBytes();
    }

    private OIndexRIDContainer containerFromStream(String stream) {
        stream = stream.substring("<#@".length(), stream.length() - 1);
        ODocument doc = new ODocument();
        doc.fromString(stream);
        OBonsaiBucketPointer rootPointer = new OBonsaiBucketPointer((Long)doc.field("rootIndex"), (Integer)doc.field("rootOffset"));
        String fileName = (String)doc.field("file");
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        return new OIndexRIDContainer(fileName, new OIndexRIDContainerSBTree(fileName, rootPointer, false, (OAbstractPaginatedStorage)db.getStorage().getUnderlying()), false, false);
    }
}

