/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OLongSerializer;
import com.orientechnologies.common.serialization.types.OShortSerializer;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;

public class OLinkSerializer
implements OBinarySerializer<OIdentifiable> {
    public static final byte ID = 9;
    private static final int CLUSTER_POS_SIZE = 8;
    public static final int RID_SIZE = 10;
    public static OLinkSerializer INSTANCE = new OLinkSerializer();

    @Override
    public int getObjectSize(OIdentifiable rid, Object ... hints) {
        return 10;
    }

    @Override
    public void serialize(OIdentifiable rid, byte[] stream, int startPosition, Object ... hints) {
        ORID r = rid.getIdentity();
        OBinaryProtocol.short2bytes((short)r.getClusterId(), stream, startPosition);
        OBinaryProtocol.long2bytes(r.getClusterPosition(), stream, startPosition + 2);
    }

    @Override
    public ORecordId deserialize(byte[] stream, int startPosition) {
        return new ORecordId(OBinaryProtocol.bytes2short(stream, startPosition), OBinaryProtocol.bytes2long(stream, startPosition + 2));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 10;
    }

    @Override
    public byte getId() {
        return 9;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 10;
    }

    @Override
    public void serializeNativeObject(OIdentifiable rid, byte[] stream, int startPosition, Object ... hints) {
        ORID r = rid.getIdentity();
        OShortSerializer.INSTANCE.serializeNative((short)r.getClusterId(), stream, startPosition, new Object[0]);
        OLongSerializer.INSTANCE.serialize(r.getClusterPosition(), stream, startPosition + 2, new Object[0]);
    }

    @Override
    public ORecordId deserializeNativeObject(byte[] stream, int startPosition) {
        short clusterId = OShortSerializer.INSTANCE.deserializeNative(stream, startPosition);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(stream, startPosition + 2);
        return new ORecordId(clusterId, clusterPosition);
    }

    @Override
    public void serializeInDirectMemoryObject(OIdentifiable rid, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        ORID r = rid.getIdentity();
        OShortSerializer.INSTANCE.serializeInDirectMemory((short)r.getClusterId(), pointer, offset, new Object[0]);
        byte[] stream = new byte[8];
        OLongSerializer.INSTANCE.serialize(r.getClusterPosition(), stream, 0, new Object[0]);
        pointer.set(offset + 2L, stream, 0, 8);
    }

    @Override
    public OIdentifiable deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        short clusterId = OShortSerializer.INSTANCE.deserializeFromDirectMemory(pointer, offset);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(pointer.get(offset + 2L, 8), 0);
        return new ORecordId(clusterId, clusterPosition);
    }

    @Override
    public OIdentifiable deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        short clusterId = OShortSerializer.INSTANCE.deserializeFromDirectMemory(wrapper, offset);
        long clusterPosition = OLongSerializer.INSTANCE.deserialize(wrapper.get(offset + 2L, 8), 0);
        return new ORecordId(clusterId, clusterPosition);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 10;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 10;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 10;
    }

    @Override
    public OIdentifiable preprocess(OIdentifiable value, Object ... hints) {
        if (value == null) {
            return null;
        }
        return value.getIdentity();
    }
}

