/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.schedule;

import com.orientechnologies.common.concur.resource.OPartitionedObjectPool;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.schedule.OSchedulerListener;
import com.orientechnologies.orient.core.type.ODocumentWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class OScheduler
extends ODocumentWrapper
implements Runnable {
    public static final String CLASSNAME = "OSchedule";
    public static String PROP_NAME = "name";
    public static String PROP_RULE = "rule";
    public static String PROP_ARGUMENTS = "arguments";
    public static String PROP_STATUS = "status";
    public static String PROP_FUNC = "function";
    public static String PROP_STARTTIME = "starttime";
    public static String PROP_STARTED = "start";
    private OFunction function;
    private boolean isRunning = false;
    private ODatabaseDocumentInternal db;

    public OScheduler(ODocument doc) {
        this.getFunction();
        this.bindDb();
    }

    protected void bindDb() {
        this.db = ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void fromStream(ODocument iDocument) {
        super.fromStream(iDocument);
        this.bindDb();
    }

    public OFunction getFunctionSafe() {
        ODocument funcDoc;
        if (this.function == null && (funcDoc = (ODocument)this.document.field(PROP_FUNC)) != null) {
            this.function = new OFunction(funcDoc);
        }
        return this.function;
    }

    public OFunction getFunction() {
        OFunction fun = this.getFunctionSafe();
        if (fun == null) {
            throw new OCommandScriptException("function cannot be null");
        }
        return fun;
    }

    public String getSchedulingRule() {
        return (String)this.document.field(PROP_RULE);
    }

    public String getSchduleName() {
        return (String)this.document.field(PROP_NAME);
    }

    public boolean isStarted() {
        Boolean started = (Boolean)this.document.field(PROP_STARTED);
        return started == null ? false : started;
    }

    public void setStarted(boolean started) {
        this.document.field(PROP_STARTED, started);
    }

    public String getStatus() {
        return (String)this.document.field(PROP_STATUS);
    }

    public void setStatus(String status) {
        this.document.field(status, PROP_STATUS);
    }

    public Map<Object, Object> getArguments() {
        return (Map)this.document.field(PROP_ARGUMENTS);
    }

    public Date getStartTime() {
        return (Date)this.document.field(PROP_STARTTIME);
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public String toString() {
        String str = "OSchedule <name:" + this.getSchduleName() + ",rule:" + this.getSchedulingRule() + ",current status:" + this.getStatus() + ",func:" + this.getFunctionSafe() + ",start:" + this.isStarted() + ">";
        return str;
    }

    @Override
    public void run() {
        if (this.function == null) {
            return;
        }
        this.isRunning = true;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        Date date = new Date(System.currentTimeMillis());
        OLogManager.instance().warn((Object)this, "execute : " + this.toString() + " at " + sdf.format(date), new Object[0]);
        if (this.db != null) {
            ODatabaseRecordThreadLocal.INSTANCE.set(this.db);
        }
        this.document.field(PROP_STATUS, (Object)OSchedulerListener.SCHEDULER_STATUS.RUNNING);
        this.document.field(PROP_STARTTIME, System.currentTimeMillis());
        this.document.save();
        OScriptManager scriptManager = null;
        Bindings binding = null;
        scriptManager = Orient.instance().getScriptManager();
        OPartitionedObjectPool.PoolEntry<ScriptEngine> entry = scriptManager.acquireDatabaseEngine(this.db.getName(), this.function.getLanguage());
        ScriptEngine scriptEngine = (ScriptEngine)entry.object;
        try {
            binding = scriptEngine.getBindings(100);
            scriptManager.bind(binding, (ODatabaseDocumentTx)this.db, null, this.getArguments());
            if (this.function.getLanguage() == null) {
                throw new OConfigurationException("Database function '" + this.function.getName() + "' has no language");
            }
            String funcStr = scriptManager.getFunctionDefinition(this.function);
            if (funcStr != null) {
                try {
                    scriptEngine.eval(funcStr);
                }
                catch (ScriptException e) {
                    scriptManager.throwErrorMessage(e, funcStr);
                }
            }
            if (scriptEngine instanceof Invocable) {
                Invocable invocableEngine = (Invocable)((Object)scriptEngine);
                Object[] args = null;
                Map<Object, Object> iArgs = this.getArguments();
                if (iArgs != null) {
                    args = new Object[iArgs.size()];
                    int i = 0;
                    for (Map.Entry<Object, Object> arg : iArgs.entrySet()) {
                        args[i++] = arg.getValue();
                    }
                } else {
                    args = OCommonConst.EMPTY_OBJECT_ARRAY;
                }
                invocableEngine.invokeFunction(this.function.getName(), args);
            }
        }
        catch (ScriptException e) {
            throw new OCommandScriptException("Error on execution of the script", this.function.getName(), e.getColumnNumber(), e);
        }
        catch (NoSuchMethodException e) {
            throw new OCommandScriptException("Error on execution of the script", this.function.getName(), 0, e);
        }
        catch (OCommandScriptException e) {
            throw e;
        }
        catch (Exception ex) {
            throw new OCommandScriptException("Unknown Exception", this.function.getName(), 0, ex);
        }
        finally {
            if (scriptManager != null && binding != null) {
                scriptManager.unbind(binding, null, this.getArguments());
            }
            scriptManager.releaseDatabaseEngine(this.function.getLanguage(), this.db.getName(), entry);
            OLogManager.instance().warn((Object)this, "Job : " + this.toString() + " Finished!", new Object[0]);
            this.isRunning = false;
            this.document.field(PROP_STATUS, (Object)OSchedulerListener.SCHEDULER_STATUS.WAITING);
            this.document.save();
        }
    }
}

