/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.index;

import com.orientechnologies.orient.core.db.record.OMultiValueChangeEvent;
import com.orientechnologies.orient.core.index.OAbstractIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OPropertyMapIndexDefinition
extends OAbstractIndexDefinitionMultiValue
implements OIndexDefinitionMultiValue {
    private INDEX_BY indexBy = INDEX_BY.KEY;

    public OPropertyMapIndexDefinition() {
    }

    public OPropertyMapIndexDefinition(String iClassName, String iField, OType iType, INDEX_BY indexBy) {
        super(iClassName, iField, iType);
        if (indexBy == null) {
            throw new NullPointerException("You have to provide way by which map entries should be mapped");
        }
        this.indexBy = indexBy;
    }

    @Override
    public Object getDocumentValueToIndex(ODocument iDocument) {
        return this.createValue(iDocument.field(this.field));
    }

    @Override
    public Object createValue(List<?> params) {
        if (!(params.get(0) instanceof Map)) {
            return null;
        }
        Collection<?> mapParams = this.extractMapParams((Map)params.get(0));
        ArrayList<Object> result = new ArrayList<Object>(mapParams.size());
        for (Object mapParam : mapParams) {
            result.add(this.createSingleValue(mapParam));
        }
        return result;
    }

    @Override
    public Object createValue(Object ... params) {
        if (!(params[0] instanceof Map)) {
            return null;
        }
        Collection<?> mapParams = this.extractMapParams((Map)params[0]);
        ArrayList<Object> result = new ArrayList<Object>(mapParams.size());
        for (Object mapParam : mapParams) {
            result.add(this.createSingleValue(mapParam));
        }
        return result;
    }

    public INDEX_BY getIndexBy() {
        return this.indexBy;
    }

    @Override
    protected void serializeToStream() {
        super.serializeToStream();
        this.document.field("mapIndexBy", this.indexBy.toString());
    }

    @Override
    protected void serializeFromStream() {
        super.serializeFromStream();
        this.indexBy = INDEX_BY.valueOf((String)this.document.field("mapIndexBy"));
    }

    private Collection<?> extractMapParams(Map<?, ?> map) {
        if (this.indexBy == INDEX_BY.KEY) {
            return map.keySet();
        }
        return map.values();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OPropertyMapIndexDefinition that = (OPropertyMapIndexDefinition)o;
        return this.indexBy == that.indexBy;
    }

    @Override
    public Object createSingleValue(Object ... param) {
        return OType.convert(param[0], this.keyType.getDefaultJavaType());
    }

    @Override
    public void processChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<Object, Integer> keysToAdd, Map<Object, Integer> keysToRemove) {
        boolean result = this.indexBy.equals((Object)INDEX_BY.KEY) ? this.processKeyChangeEvent(changeEvent, keysToAdd, keysToRemove) : this.processValueChangeEvent(changeEvent, keysToAdd, keysToRemove);
        if (!result) {
            throw new IllegalArgumentException("Invalid change type :" + (Object)((Object)changeEvent.getChangeType()));
        }
    }

    private boolean processKeyChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<Object, Integer> keysToAdd, Map<Object, Integer> keysToRemove) {
        switch (changeEvent.getChangeType()) {
            case ADD: {
                this.processAdd(this.createSingleValue(changeEvent.getKey()), keysToAdd, keysToRemove);
                return true;
            }
            case REMOVE: {
                this.processRemoval(this.createSingleValue(changeEvent.getKey()), keysToAdd, keysToRemove);
                return true;
            }
            case UPDATE: {
                return true;
            }
        }
        return false;
    }

    private boolean processValueChangeEvent(OMultiValueChangeEvent<?, ?> changeEvent, Map<Object, Integer> keysToAdd, Map<Object, Integer> keysToRemove) {
        switch (changeEvent.getChangeType()) {
            case ADD: {
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                return true;
            }
            case REMOVE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                return true;
            }
            case UPDATE: {
                this.processRemoval(this.createSingleValue(changeEvent.getOldValue()), keysToAdd, keysToRemove);
                this.processAdd(this.createSingleValue(changeEvent.getValue()), keysToAdd, keysToRemove);
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getFieldsToIndex() {
        if (this.indexBy == INDEX_BY.KEY) {
            return Collections.singletonList(this.field + " by key");
        }
        return Collections.singletonList(this.field + " by value");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.indexBy.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "OPropertyMapIndexDefinition{indexBy=" + (Object)((Object)this.indexBy) + "} " + super.toString();
    }

    @Override
    public String toCreateIndexDDL(String indexName, String indexType, String engine) {
        StringBuilder ddl = new StringBuilder("create index ");
        ddl.append(indexName).append(" on ");
        ddl.append(this.className).append(" ( ").append(this.field);
        if (this.indexBy == INDEX_BY.KEY) {
            ddl.append(" by key");
        } else {
            ddl.append(" by value");
        }
        ddl.append(" ) ");
        ddl.append(indexType);
        return ddl.toString();
    }

    public static enum INDEX_BY {
        KEY,
        VALUE;

    }
}

