/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db.record.ridbag.sbtree;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OIndexRIDContainerSBTree;
import com.orientechnologies.orient.core.index.sbtree.local.OSBTreeException;
import com.orientechnologies.orient.core.storage.cache.OReadCache;
import com.orientechnologies.orient.core.storage.cache.OWriteCache;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class OIndexRIDContainer
implements Set<OIdentifiable> {
    public static final String INDEX_FILE_EXTENSION = ".irs";
    private final long fileId;
    private Set<OIdentifiable> underlying;
    private boolean isEmbedded;
    private int topThreshold = OGlobalConfiguration.INDEX_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.getValueAsInteger();
    private int bottomThreshold = OGlobalConfiguration.INDEX_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.getValueAsInteger();
    private final boolean durableNonTxMode;

    public OIndexRIDContainer(String name, boolean durableNonTxMode) {
        this.fileId = this.resolveFileIdByName(name + INDEX_FILE_EXTENSION);
        this.underlying = new HashSet<OIdentifiable>();
        this.isEmbedded = true;
        this.durableNonTxMode = durableNonTxMode;
    }

    public OIndexRIDContainer(String fileName, Set<OIdentifiable> underlying, boolean autoConvert, boolean durableNonTxMode) {
        this.fileId = this.resolveFileIdByName(fileName + INDEX_FILE_EXTENSION);
        this.underlying = underlying;
        boolean bl = this.isEmbedded = !(underlying instanceof OIndexRIDContainerSBTree);
        if (!autoConvert) {
            assert (!this.isEmbedded);
            this.topThreshold = -1;
            this.bottomThreshold = -1;
        }
        this.durableNonTxMode = durableNonTxMode;
    }

    private long resolveFileIdByName(String fileName) {
        OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        try {
            OAtomicOperation atomicOperation = storage.getAtomicOperationsManager().startAtomicOperation(fileName, true);
            OReadCache readCache = storage.getReadCache();
            OWriteCache writeCache = storage.getWriteCache();
            if (atomicOperation == null) {
                if (writeCache.exists(fileName)) {
                    return readCache.openFile(fileName, writeCache);
                }
                return readCache.addFile(fileName, writeCache);
            }
            long fileId = atomicOperation.isFileExists(fileName) ? atomicOperation.openFile(fileName) : atomicOperation.addFile(fileName);
            storage.getAtomicOperationsManager().endAtomicOperation(false, null);
            return fileId;
        }
        catch (IOException e) {
            try {
                storage.getAtomicOperationsManager().endAtomicOperation(true, e);
            }
            catch (IOException ioe) {
                throw new OSBTreeException("Error of rollback of atomic operation", ioe);
            }
            throw new OSBTreeException("Error creation of sbtree with name " + fileName, e);
        }
    }

    public OIndexRIDContainer(long fileId, Set<OIdentifiable> underlying, boolean durableNonTxMode) {
        this.fileId = fileId;
        this.underlying = underlying;
        this.isEmbedded = !(underlying instanceof OIndexRIDContainerSBTree);
        this.durableNonTxMode = durableNonTxMode;
    }

    public long getFileId() {
        return this.fileId;
    }

    @Override
    public int size() {
        return this.underlying.size();
    }

    @Override
    public boolean isEmpty() {
        return this.underlying.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlying.contains(o);
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this.underlying.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.underlying.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.underlying.toArray(a);
    }

    @Override
    public boolean add(OIdentifiable oIdentifiable) {
        boolean res = this.underlying.add(oIdentifiable);
        this.checkTopThreshold();
        return res;
    }

    @Override
    public boolean remove(Object o) {
        boolean res = this.underlying.remove(o);
        this.checkBottomThreshold();
        return res;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.underlying.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        boolean res = this.underlying.addAll(c);
        this.checkTopThreshold();
        return res;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.underlying.retainAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean res = this.underlying.removeAll(c);
        this.checkBottomThreshold();
        return res;
    }

    @Override
    public void clear() {
        if (this.isEmbedded) {
            this.underlying.clear();
        } else {
            OIndexRIDContainerSBTree tree = (OIndexRIDContainerSBTree)this.underlying;
            tree.delete();
            this.underlying = new HashSet<OIdentifiable>();
            this.isEmbedded = true;
        }
    }

    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    public boolean isDurableNonTxMode() {
        return this.durableNonTxMode;
    }

    public Set<OIdentifiable> getUnderlying() {
        return this.underlying;
    }

    private void checkTopThreshold() {
        if (this.isEmbedded && this.topThreshold < this.underlying.size()) {
            this.convertToSbTree();
        }
    }

    private void checkBottomThreshold() {
        if (!this.isEmbedded && this.bottomThreshold > this.underlying.size()) {
            this.convertToEmbedded();
        }
    }

    private void convertToEmbedded() {
        OIndexRIDContainerSBTree tree = (OIndexRIDContainerSBTree)this.underlying;
        HashSet<OIdentifiable> set = new HashSet<OIdentifiable>(tree);
        tree.delete();
        this.underlying = set;
        this.isEmbedded = true;
    }

    public void checkNotEmbedded() {
        if (this.isEmbedded) {
            this.convertToSbTree();
        }
    }

    private void convertToSbTree() {
        ODatabaseDocumentInternal db = ODatabaseRecordThreadLocal.INSTANCE.get();
        OIndexRIDContainerSBTree tree = new OIndexRIDContainerSBTree(this.fileId, this.durableNonTxMode, (OAbstractPaginatedStorage)db.getStorage().getUnderlying());
        tree.addAll((Collection<? extends OIdentifiable>)this.underlying);
        this.underlying = tree;
        this.isEmbedded = false;
    }
}

