/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.OOrientListenerAbstract;
import com.orientechnologies.orient.core.Orient;
import java.util.concurrent.Callable;

public class OScenarioThreadLocal
extends ThreadLocal<Scenario> {
    public static volatile OScenarioThreadLocal INSTANCE = new OScenarioThreadLocal();

    public OScenarioThreadLocal() {
        this.setRunMode(RUN_MODE.DEFAULT);
    }

    public static Object executeAsDistributed(Callable<Object> iCallback) {
        RUN_MODE currentDistributedMode = INSTANCE.getRunMode();
        if (currentDistributedMode != RUN_MODE.RUNNING_DISTRIBUTED) {
            INSTANCE.setRunMode(RUN_MODE.RUNNING_DISTRIBUTED);
        }
        try {
            Object object = iCallback.call();
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentDistributedMode != RUN_MODE.RUNNING_DISTRIBUTED) {
                INSTANCE.setRunMode(RUN_MODE.DEFAULT);
            }
        }
    }

    public static Object executeAsDefault(Callable<Object> iCallback) {
        RUN_MODE currentDistributedMode = INSTANCE.getRunMode();
        if (currentDistributedMode == RUN_MODE.RUNNING_DISTRIBUTED) {
            INSTANCE.setRunMode(RUN_MODE.DEFAULT);
        }
        try {
            Object object = iCallback.call();
            return object;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (currentDistributedMode == RUN_MODE.RUNNING_DISTRIBUTED) {
                INSTANCE.setRunMode(RUN_MODE.RUNNING_DISTRIBUTED);
            }
        }
    }

    @Override
    public void set(Scenario value) {
        super.set(value);
    }

    @Override
    protected Scenario initialValue() {
        return new Scenario();
    }

    public RUN_MODE getRunMode() {
        return ((Scenario)this.get()).runMode;
    }

    public void setRunMode(RUN_MODE iRunMode) {
        ((Scenario)this.get()).runMode = iRunMode;
    }

    public boolean isReplicationSyncMode() {
        return ((Scenario)this.get()).replicationSyncMode;
    }

    public void setReplicationSyncMode(boolean iReplicationSyncMode) {
        ((Scenario)this.get()).replicationSyncMode = iReplicationSyncMode;
    }

    static {
        Orient.instance().registerListener(new OOrientListenerAbstract(){

            @Override
            public void onStartup() {
                if (INSTANCE == null) {
                    INSTANCE = new OScenarioThreadLocal();
                }
            }

            @Override
            public void onShutdown() {
                INSTANCE = null;
            }
        });
    }

    public static enum RUN_MODE {
        DEFAULT,
        RUNNING_DISTRIBUTED;

    }

    public class Scenario {
        public RUN_MODE runMode = RUN_MODE.DEFAULT;
        public boolean replicationSyncMode = true;
    }
}

