/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraverseMultiValueProcess;
import com.orientechnologies.orient.core.command.traverse.OTraversePath;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.metadata.schema.OImmutableClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class OTraverseRecordProcess
extends OTraverseAbstractProcess<OIdentifiable> {
    private final OTraversePath path;

    public OTraverseRecordProcess(OTraverse iCommand, OIdentifiable iTarget, OTraversePath parentPath) {
        super(iCommand, iTarget);
        this.path = parentPath.append(iTarget);
    }

    @Override
    public OIdentifiable process() {
        Object conditionResult;
        if (this.target == null) {
            return this.pop();
        }
        int depth = this.path.getDepth();
        if (((OTraverse)this.command).getContext().isAlreadyTraversed((OIdentifiable)this.target, depth)) {
            return this.drop();
        }
        if (((OTraverse)this.command).getPredicate() != null && (conditionResult = ((OTraverse)this.command).getPredicate().evaluate((OIdentifiable)this.target, null, ((OTraverse)this.command).getContext())) != Boolean.TRUE) {
            return this.drop();
        }
        ((OTraverse)this.command).getContext().addTraversed((OIdentifiable)this.target, depth);
        int maxDepth = ((OTraverse)this.command).getMaxDepth();
        if (maxDepth > -1 && depth == maxDepth) {
            this.pop();
        } else {
            Object targetRec = ((OIdentifiable)this.target).getRecord();
            if (!(targetRec instanceof ODocument)) {
                return this.pop();
            }
            ODocument targetDoc = (ODocument)targetRec;
            ArrayList<Object> fields = new ArrayList<Object>();
            for (Object cfgFieldObject : ((OTraverse)this.command).getFields()) {
                String cfgField = cfgFieldObject.toString();
                if ("*".equals(cfgField) || "ALL()".equalsIgnoreCase(cfgField) || "ANY()".equalsIgnoreCase(cfgField)) {
                    Collections.addAll(fields, targetDoc.fieldNames());
                    break;
                }
                int pos = OStringSerializerHelper.parse(cfgField, new StringBuilder(), 0, -1, new char[]{'.'}, true, true, true, 0, true, new char[0]) - 1;
                if (pos > -1) {
                    String className;
                    OImmutableClass cls = ODocumentInternal.getImmutableSchemaClass(targetDoc);
                    if (cls == null || !cls.isSubClassOf(className = cfgField.substring(0, pos))) continue;
                    cfgField = cfgField.substring(pos + 1);
                    fields.add(cfgField);
                    continue;
                }
                fields.add(cfgFieldObject);
            }
            if (((OTraverse)this.command).getStrategy() == OTraverse.STRATEGY.DEPTH_FIRST) {
                Collections.reverse(fields);
            }
            this.processFields(fields.iterator());
            if (targetDoc.isEmbedded()) {
                return null;
            }
        }
        return (OIdentifiable)this.target;
    }

    private void processFields(Iterator<Object> target) {
        ODocument doc = (ODocument)((OIdentifiable)this.target).getRecord();
        while (target.hasNext()) {
            OTraverseAbstractProcess subProcess;
            Object field = target.next();
            Object fieldValue = field instanceof OSQLFilterItem ? ((OSQLFilterItem)field).getValue(doc, null, null) : doc.rawField(field.toString());
            if (fieldValue == null) continue;
            if (fieldValue instanceof Iterator || OMultiValue.isMultiValue(fieldValue)) {
                Iterator<Object> coll = fieldValue instanceof ORecordLazyMultiValue ? ((ORecordLazyMultiValue)fieldValue).rawIterator() : OMultiValue.getMultiValueIterator(fieldValue);
                subProcess = new OTraverseMultiValueProcess((OTraverse)this.command, coll, this.getPath().appendField(field.toString()));
            } else {
                if (!(fieldValue instanceof OIdentifiable) || !(((OIdentifiable)fieldValue).getRecord() instanceof ODocument)) continue;
                subProcess = new OTraverseRecordProcess((OTraverse)this.command, (ODocument)((OIdentifiable)fieldValue).getRecord(), this.getPath().appendField(field.toString()));
            }
            ((OTraverse)this.command).getContext().push(subProcess);
        }
    }

    @Override
    public String toString() {
        return this.target != null ? ((OIdentifiable)this.target).getIdentity().toString() : "-";
    }

    @Override
    public OTraversePath getPath() {
        return this.path;
    }

    public OIdentifiable drop() {
        ((OTraverse)this.command).getContext().pop(null);
        return null;
    }

    @Override
    public OIdentifiable pop() {
        ((OTraverse)this.command).getContext().pop((OIdentifiable)this.target);
        return null;
    }
}

