/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.orient.client.remote.OCollectionNetworkSerializer;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.db.record.ridbag.sbtree.OSBTreeRidBag;
import com.orientechnologies.orient.core.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OBonsaiBucketPointer;
import com.orientechnologies.orient.core.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryAsynchClient;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class OSBTreeBonsaiRemote<K, V>
implements OSBTreeBonsai<K, V> {
    private final OBonsaiCollectionPointer treePointer;
    private final OBinarySerializer<K> keySerializer;
    private final OBinarySerializer<V> valueSerializer;

    public OSBTreeBonsaiRemote(OBonsaiCollectionPointer treePointer, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        this.treePointer = treePointer;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    @Override
    public long getFileId() {
        return this.treePointer.getFileId();
    }

    @Override
    public OBonsaiBucketPointer getRootBucketPointer() {
        return this.treePointer.getRootPointer();
    }

    @Override
    public OBonsaiCollectionPointer getCollectionPointer() {
        return this.treePointer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        OChannelBinaryAsynchClient client = null;
        while (true) {
            try {
                byte[] stream;
                client = storage.beginRequest((byte)111);
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, this.getCollectionPointer());
                client.writeBytes(keyStream);
                storage.endRequest(client);
                try {
                    storage.beginResponse(client);
                    stream = client.readBytes();
                }
                finally {
                    storage.endResponse(client);
                }
                byte serializerId = OByteSerializer.INSTANCE.deserializeLiteral(stream, 0);
                OBinarySerializer<?> serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
                return (V)serializer.deserialize(stream, 1);
            }
            catch (Exception e) {
                storage.handleException(client, "Can't get by key from sb-tree bonsai.", e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean put(K key, V value) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public V remove(K key) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public long size() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public Collection<V> getValuesMinor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void loadEntriesMinor(K key, boolean inclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public Collection<V> getValuesMajor(K key, boolean inclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void loadEntriesMajor(K key, boolean inclusive, boolean ascSortOrder, OTreeInternal.RangeResultListener<K, V> listener) {
        if (!ascSortOrder) {
            throw new IllegalStateException("Descending sort order is not supported.");
        }
        List<Map.Entry<K, V>> entries = this.fetchEntriesMajor(key, inclusive);
        while (this.pushEntriesToListener(listener, entries)) {
            K nextKey = entries.get(entries.size() - 1).getKey();
            entries = this.fetchEntriesMajor(nextKey, false);
        }
    }

    private boolean pushEntriesToListener(OTreeInternal.RangeResultListener<K, V> listener, List<Map.Entry<K, V>> entries) {
        boolean more = false;
        for (Map.Entry<K, V> entry : entries) {
            more = listener.addResult(entry);
            if (more) continue;
            return false;
        }
        return more;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Map.Entry<K, V>> fetchEntriesMajor(K key, boolean inclusive) {
        byte[] keyStream = new byte[this.keySerializer.getObjectSize(key, new Object[0])];
        this.keySerializer.serialize(key, keyStream, 0, new Object[0]);
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        OChannelBinaryAsynchClient client = null;
        while (true) {
            try {
                client = storage.beginRequest((byte)113);
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, this.getCollectionPointer());
                client.writeBytes(keyStream);
                client.writeBoolean(inclusive);
                if (client.getSrvProtocolVersion() >= 21) {
                    client.writeInt(128);
                }
                storage.endRequest(client);
                ArrayList<Map.Entry<K, V>> list = null;
                try {
                    storage.beginResponse(client);
                    byte[] stream = client.readBytes();
                    int offset = 0;
                    int count = OIntegerSerializer.INSTANCE.deserializeLiteral(stream, 0);
                    offset += 4;
                    list = new ArrayList<Map.Entry<K, V>>(count);
                    for (int i = 0; i < count; ++i) {
                        K resultKey = this.keySerializer.deserialize(stream, offset);
                        offset += this.keySerializer.getObjectSize(stream, offset);
                        V resultValue = this.valueSerializer.deserialize(stream, offset);
                        offset += this.valueSerializer.getObjectSize(stream, offset);
                        list.add(new TreeEntry<K, V>(resultKey, resultValue));
                    }
                }
                finally {
                    storage.endResponse(client);
                }
                return list;
            }
            catch (Exception e) {
                storage.handleException(client, "Can't get first key from sb-tree bonsai.", e);
                continue;
            }
            break;
        }
    }

    @Override
    public Collection<V> getValuesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, int maxValuesToFetch) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public K firstKey() {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        OChannelBinaryAsynchClient client = null;
        while (true) {
            try {
                byte[] stream;
                client = storage.beginRequest((byte)112);
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, this.getCollectionPointer());
                storage.endRequest(client);
                try {
                    storage.beginResponse(client);
                    stream = client.readBytes();
                }
                finally {
                    storage.endResponse(client);
                }
                byte serializerId = OByteSerializer.INSTANCE.deserializeLiteral(stream, 0);
                OBinarySerializer<?> serializer = OBinarySerializerFactory.getInstance().getObjectSerializer(serializerId);
                return (K)serializer.deserialize(stream, 1);
            }
            catch (Exception e) {
                storage.handleException(client, "Can't get first key from sb-tree bonsai.", e);
                continue;
            }
            break;
        }
    }

    @Override
    public K lastKey() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void loadEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, OTreeInternal.RangeResultListener<K, V> listener) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRealBagSize(Map<K, OSBTreeRidBag.Change> changes) {
        OStorageRemote storage = (OStorageRemote)ODatabaseRecordThreadLocal.INSTANCE.get().getStorage().getUnderlying();
        OChannelBinaryAsynchClient client = null;
        while (true) {
            try {
                int result;
                client = storage.beginRequest((byte)114);
                OCollectionNetworkSerializer.INSTANCE.writeCollectionPointer(client, this.getCollectionPointer());
                OSBTreeRidBag.ChangeSerializationHelper changeSerializer = OSBTreeRidBag.ChangeSerializationHelper.INSTANCE;
                byte[] stream = new byte[4 + changeSerializer.getChangesSerializedSize(changes.size())];
                changeSerializer.serializeChanges(changes, this.keySerializer, stream, 0);
                client.writeBytes(stream);
                storage.endRequest(client);
                try {
                    storage.beginResponse(client);
                    result = client.readInt();
                }
                finally {
                    storage.endResponse(client);
                }
                return result;
            }
            catch (Exception e) {
                storage.handleException(client, "Can't get by real bag size sb-tree bonsai.", e);
                continue;
            }
            break;
        }
    }

    @Override
    public OBinarySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    @Override
    public OBinarySerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    class TreeEntry<EK, EV>
    implements Map.Entry<EK, EV> {
        private final EK key;
        private final EV value;

        TreeEntry(EK key, EV value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public EK getKey() {
            return this.key;
        }

        @Override
        public EV getValue() {
            return this.value;
        }

        @Override
        public EV setValue(EV value) {
            throw new UnsupportedOperationException();
        }
    }
}

