/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.remote.ORemoteConnectionManager;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.engine.OEngineAbstract;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.HashMap;
import java.util.Map;

public class OEngineRemote
extends OEngineAbstract {
    public static final String NAME = "remote";
    protected static final Map<String, OStorageRemote> sharedStorages = new HashMap<String, OStorageRemote>();
    protected final ORemoteConnectionManager connectionManager = new ORemoteConnectionManager(OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger(), OGlobalConfiguration.NETWORK_LOCK_TIMEOUT.getValueAsLong());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStorage createStorage(String iURL, Map<String, String> iConfiguration) {
        try {
            Map<String, OStorageRemote> map = sharedStorages;
            synchronized (map) {
                OStorageRemote sharedStorage = sharedStorages.get(iURL);
                if (sharedStorage == null) {
                    sharedStorage = new OStorageRemote(null, iURL, "rw");
                    sharedStorages.put(iURL, sharedStorage);
                }
                return new OStorageRemoteThread(sharedStorage);
            }
        }
        catch (Throwable t) {
            OLogManager.instance().error((Object)this, "Error on opening database: " + iURL, t, ODatabaseException.class, new Object[0]);
            return null;
        }
    }

    @Override
    public void removeStorage(OStorage iStorage) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        super.shutdown();
        this.connectionManager.close();
        Map<String, OStorageRemote> map = sharedStorages;
        synchronized (map) {
            for (Map.Entry<String, OStorageRemote> entry : sharedStorages.entrySet()) {
                entry.getValue().close(true, false);
            }
            sharedStorages.clear();
        }
    }

    public ORemoteConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isShared() {
        return false;
    }
}

