/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.serialization.types;

import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.ODateTimeSerializer;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWALChangesTree;
import java.util.Calendar;
import java.util.Date;

public class ODateSerializer
implements OBinarySerializer<Date> {
    public static final byte ID = 4;
    public static ODateSerializer INSTANCE = new ODateSerializer();

    @Override
    public int getObjectSize(Date object, Object ... hints) {
        return 8;
    }

    @Override
    public void serialize(Date object, byte[] stream, int startPosition, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        dateTimeSerializer.serialize(calendar.getTime(), stream, startPosition, new Object[0]);
    }

    @Override
    public Date deserialize(byte[] stream, int startPosition) {
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        return dateTimeSerializer.deserialize(stream, startPosition);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 4;
    }

    @Override
    public int getObjectSizeNative(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public void serializeNativeObject(Date object, byte[] stream, int startPosition, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        dateTimeSerializer.serializeNativeObject(calendar.getTime(), stream, startPosition, new Object[0]);
    }

    @Override
    public Date deserializeNativeObject(byte[] stream, int startPosition) {
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        return dateTimeSerializer.deserializeNativeObject(stream, startPosition);
    }

    @Override
    public void serializeInDirectMemoryObject(Date object, ODirectMemoryPointer pointer, long offset, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        dateTimeSerializer.serializeInDirectMemoryObject(calendar.getTime(), pointer, offset, new Object[0]);
    }

    @Override
    public Date deserializeFromDirectMemoryObject(ODirectMemoryPointer pointer, long offset) {
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        return dateTimeSerializer.deserializeFromDirectMemoryObject(pointer, offset);
    }

    @Override
    public Date deserializeFromDirectMemoryObject(OWALChangesTree.PointerWrapper wrapper, long offset) {
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        return dateTimeSerializer.deserializeFromDirectMemoryObject(wrapper, offset);
    }

    @Override
    public int getObjectSizeInDirectMemory(ODirectMemoryPointer pointer, long offset) {
        return 8;
    }

    @Override
    public int getObjectSizeInDirectMemory(OWALChangesTree.PointerWrapper wrapper, long offset) {
        return 8;
    }

    @Override
    public boolean isFixedLength() {
        return true;
    }

    @Override
    public int getFixedLength() {
        return 8;
    }

    @Override
    public Date preprocess(Date value, Object ... hints) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(value);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }
}

