/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.directmemory;

import com.orientechnologies.common.directmemory.ODirectMemory;
import com.orientechnologies.common.directmemory.ODirectMemoryPointer;
import com.orientechnologies.common.directmemory.ODirectMemoryPointerFactory;
import com.orientechnologies.common.directmemory.ODirectMemoryViolationException;

public class OUntrackedDirectMemoryPointer
implements ODirectMemoryPointer {
    private final boolean safeMode;
    private final ODirectMemory directMemory;
    private final long pageSize;
    private final long dataPointer;

    OUntrackedDirectMemoryPointer(boolean safeMode, ODirectMemory directMemory, long pageSize, ODirectMemoryPointerFactory factory) {
        this.safeMode = safeMode;
        this.directMemory = directMemory;
        if (pageSize <= 0L) {
            throw new ODirectMemoryViolationException("Size of allocated area should be more than zero but " + pageSize + " was provided.");
        }
        this.dataPointer = this.directMemory.allocate(pageSize);
        this.pageSize = pageSize;
    }

    OUntrackedDirectMemoryPointer(byte[] data, boolean safeMode, ODirectMemory directMemory, ODirectMemoryPointerFactory factory) {
        this.safeMode = safeMode;
        this.directMemory = directMemory;
        if (data.length == 0) {
            throw new ODirectMemoryViolationException("Size of allocated area should be more than zero but 0 was provided.");
        }
        this.pageSize = data.length;
        this.dataPointer = this.directMemory.allocate(this.pageSize);
        this.set(0L, data, 0, data.length);
    }

    @Override
    public byte[] get(long offset, int length) {
        if (this.safeMode) {
            this.rangeCheck(offset, length);
        }
        return this.directMemory.get(this.dataPointer + offset, length);
    }

    @Override
    public void get(long offset, byte[] array, int arrayOffset, int length) {
        if (this.safeMode) {
            this.rangeCheck(offset, length);
        }
        this.directMemory.get(this.dataPointer + offset, array, arrayOffset, length);
    }

    @Override
    public void set(long offset, byte[] content, int arrayOffset, int length) {
        if (this.safeMode) {
            this.rangeCheck(offset, length);
        }
        this.directMemory.set(this.dataPointer + offset, content, arrayOffset, length);
    }

    @Override
    public int getInt(long offset) {
        if (this.safeMode) {
            this.rangeCheck(offset, 4L);
        }
        return this.directMemory.getInt(this.dataPointer + offset);
    }

    @Override
    public void setInt(long offset, int value) {
        if (this.safeMode) {
            this.rangeCheck(offset, 4L);
        }
        this.directMemory.setInt(this.dataPointer + offset, value);
    }

    @Override
    public void setShort(long offset, short value) {
        if (this.safeMode) {
            this.rangeCheck(offset, 2L);
        }
        this.directMemory.setShort(this.dataPointer + offset, value);
    }

    @Override
    public short getShort(long offset) {
        if (this.safeMode) {
            this.rangeCheck(offset, 2L);
        }
        return this.directMemory.getShort(this.dataPointer + offset);
    }

    @Override
    public long getLong(long offset) {
        if (this.safeMode) {
            this.rangeCheck(offset, 8L);
        }
        return this.directMemory.getLong(this.dataPointer + offset);
    }

    @Override
    public void setLong(long offset, long value) {
        if (this.safeMode) {
            this.rangeCheck(offset, 8L);
        }
        this.directMemory.setLong(this.dataPointer + offset, value);
    }

    @Override
    public byte getByte(long offset) {
        if (this.safeMode) {
            this.rangeCheck(offset, 1L);
        }
        return this.directMemory.getByte(this.dataPointer + offset);
    }

    @Override
    public void setByte(long offset, byte value) {
        if (this.safeMode) {
            this.rangeCheck(offset, 1L);
        }
        this.directMemory.setByte(this.dataPointer + offset, value);
    }

    @Override
    public void setChar(long offset, char value) {
        if (this.safeMode) {
            this.rangeCheck(offset, 2L);
        }
        this.directMemory.setChar(this.dataPointer + offset, value);
    }

    @Override
    public char getChar(long offset) {
        if (this.safeMode) {
            this.rangeCheck(offset, 2L);
        }
        return this.directMemory.getChar(this.dataPointer + offset);
    }

    @Override
    public void moveData(long srcOffset, ODirectMemoryPointer destPointer, long destOffset, long len) {
        if (this.safeMode) {
            this.rangeCheck(srcOffset, len);
            this.rangeCheck(destOffset, len);
        }
        this.directMemory.moveData(this.dataPointer + srcOffset, destPointer.getDataPointer() + destOffset, len);
    }

    @Override
    public long getDataPointer() {
        return this.dataPointer;
    }

    @Override
    public void free() {
        this.directMemory.free(this.dataPointer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OUntrackedDirectMemoryPointer that = (OUntrackedDirectMemoryPointer)o;
        if (this.dataPointer != that.dataPointer) {
            return false;
        }
        return this.pageSize == that.pageSize;
    }

    public int hashCode() {
        int result = (int)(this.pageSize ^ this.pageSize >>> 32);
        result = 31 * result + (int)(this.dataPointer ^ this.dataPointer >>> 32);
        return result;
    }

    private void rangeCheck(long offset, long size) {
        if (offset < 0L) {
            throw new ODirectMemoryViolationException("Negative offset was provided");
        }
        if (size < 0L) {
            throw new ODirectMemoryViolationException("Negative size was provided");
        }
        if (offset > this.pageSize) {
            throw new ODirectMemoryViolationException("Provided offset [" + offset + "] is more than size of allocated area  [" + this.pageSize + "]");
        }
        if (offset + size > this.pageSize) {
            throw new ODirectMemoryViolationException("Last position of provided data interval [" + (offset + size) + "] is more than size of allocated area [" + this.pageSize + "]");
        }
    }
}

