/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.resource;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.util.OResettable;
import java.util.Iterator;

public class OSharedResourceIterator<T>
implements Iterator<T>,
OResettable {
    protected final OSharedResourceAdaptiveExternal resource;
    protected Iterator<?> iterator;

    public OSharedResourceIterator(OSharedResourceAdaptiveExternal iResource, Iterator<?> iIterator) {
        this.resource = iResource;
        this.iterator = iIterator;
    }

    @Override
    public boolean hasNext() {
        this.resource.acquireExclusiveLock();
        try {
            boolean bl = this.iterator.hasNext();
            return bl;
        }
        finally {
            this.resource.releaseExclusiveLock();
        }
    }

    @Override
    public T next() {
        this.resource.acquireExclusiveLock();
        try {
            Object obj = this.iterator.next();
            return (T)obj;
        }
        finally {
            this.resource.releaseExclusiveLock();
        }
    }

    @Override
    public void remove() {
        this.resource.acquireExclusiveLock();
        try {
            this.iterator.remove();
        }
        finally {
            this.resource.releaseExclusiveLock();
        }
    }

    @Override
    public void reset() {
        if (!(this.iterator instanceof OResettable)) {
            return;
        }
        this.resource.acquireExclusiveLock();
        try {
            ((OResettable)((Object)this.iterator)).reset();
        }
        finally {
            this.resource.releaseExclusiveLock();
        }
    }
}

