/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OModificationOperationProhibitedException;
import com.orientechnologies.common.concur.lock.OReadersWriterSpinLock;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class OModificationLock {
    private final AtomicInteger vetos = new AtomicInteger();
    private volatile boolean throwException = false;
    private final ConcurrentLinkedQueue<Thread> waiters = new ConcurrentLinkedQueue();
    private final OReadersWriterSpinLock lock = new OReadersWriterSpinLock();

    public void requestModificationLock() {
        this.lock.acquireReadLock();
        if (this.vetos.get() == 0) {
            return;
        }
        if (this.throwException) {
            this.lock.releaseReadLock();
            throw new OModificationOperationProhibitedException("Modification requests are prohibited");
        }
        boolean wasInterrupted = false;
        Thread thread = Thread.currentThread();
        this.waiters.add(thread);
        while (this.vetos.get() > 0) {
            LockSupport.park(this);
            if (!Thread.interrupted()) continue;
            wasInterrupted = true;
        }
        this.waiters.remove(thread);
        if (wasInterrupted) {
            thread.interrupt();
        }
    }

    public void releaseModificationLock() {
        this.lock.releaseReadLock();
    }

    public void prohibitModifications() {
        this.prohibitModifications(false);
    }

    public void prohibitModifications(boolean throwException) {
        this.lock.acquireWriteLock();
        try {
            this.throwException = throwException;
            this.vetos.incrementAndGet();
        }
        finally {
            this.lock.releaseWriteLock();
        }
    }

    public void allowModifications() {
        int currentVetos = this.vetos.decrementAndGet();
        if (currentVetos < 0) {
            throw new IllegalStateException("Bad state of modification lock. Modifications were prohibited less times than they will be allowed.");
        }
        for (Thread thread : this.waiters) {
            LockSupport.unpark(thread);
        }
    }
}

