/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.common.concur.lock;

import com.orientechnologies.common.concur.lock.OLockException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class OLockManager<T> {
    private static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    protected long acquireTimeout;
    protected final ConcurrentHashMap<T, CountableLock> map;
    private final boolean enabled;

    public OLockManager(boolean iEnabled, int iAcquireTimeout) {
        this(iEnabled, iAcquireTimeout, OLockManager.defaultConcurrency());
    }

    public OLockManager(boolean iEnabled, int iAcquireTimeout, int concurrencyLevel) {
        int cL;
        for (cL = 1; cL < concurrencyLevel; cL <<= 1) {
        }
        this.map = new ConcurrentHashMap(cL);
        this.acquireTimeout = iAcquireTimeout;
        this.enabled = iEnabled;
    }

    public void acquireLock(T iResourceId, LOCK iLockType) {
        this.acquireLock(iResourceId, iLockType, this.acquireTimeout);
    }

    public void acquireLock(T iResourceId, LOCK iLockType, long iTimeout) {
        block12: {
            CountableLock lock;
            CountableLock oldLock;
            if (!this.enabled) {
                return;
            }
            T immutableResource = this.getImmutableResourceId(iResourceId);
            while ((oldLock = this.map.putIfAbsent(immutableResource, lock = new CountableLock())) != null) {
                lock = oldLock;
                int oldValue = lock.countLocks.get();
                if (oldValue <= 0 || !lock.countLocks.compareAndSet(oldValue, oldValue + 1)) continue;
                assert (this.map.get(immutableResource) == lock);
                break;
            }
            try {
                if (iTimeout <= 0L) {
                    if (iLockType == LOCK.SHARED) {
                        lock.readWriteLock.readLock().lock();
                    } else {
                        lock.readWriteLock.writeLock().lock();
                    }
                    break block12;
                }
                try {
                    if (iLockType == LOCK.SHARED ? !lock.readWriteLock.readLock().tryLock(iTimeout, TimeUnit.MILLISECONDS) : !lock.readWriteLock.writeLock().tryLock(iTimeout, TimeUnit.MILLISECONDS)) {
                        throw new OLockException("Timeout (" + iTimeout + "ms) on acquiring resource '" + iResourceId + "' because is locked from another thread");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new OLockException("Thread interrupted while waiting for resource '" + iResourceId + "'", e);
                }
            }
            catch (RuntimeException e) {
                int usages = lock.countLocks.decrementAndGet();
                if (usages == 0) {
                    this.map.remove(immutableResource);
                }
                throw e;
            }
        }
    }

    public void releaseLock(Object iRequester, T iResourceId, LOCK iLockType) throws OLockException {
        if (!this.enabled) {
            return;
        }
        CountableLock lock = this.map.get(iResourceId);
        if (lock == null) {
            throw new OLockException("Error on releasing a non acquired lock by the requester '" + iRequester + "' against the resource: '" + iResourceId + "'");
        }
        int usages = lock.countLocks.decrementAndGet();
        if (usages == 0) {
            this.map.remove(iResourceId);
        }
        if (iLockType == LOCK.SHARED) {
            lock.readWriteLock.readLock().unlock();
        } else {
            lock.readWriteLock.writeLock().unlock();
        }
    }

    public int getCountCurrentLocks() {
        return this.map.size();
    }

    protected T getImmutableResourceId(T iResourceId) {
        return iResourceId;
    }

    private static int defaultConcurrency() {
        return Runtime.getRuntime().availableProcessors() * 64 > 16 ? Runtime.getRuntime().availableProcessors() * 64 : 16;
    }

    protected static class CountableLock {
        private final AtomicInteger countLocks = new AtomicInteger(1);
        private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();

        protected CountableLock() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CountableLock)) {
                return false;
            }
            CountableLock that = (CountableLock)o;
            if (!this.countLocks.equals(that.countLocks)) {
                return false;
            }
            return this.readWriteLock.equals(that.readWriteLock);
        }

        public int hashCode() {
            int result = this.countLocks.hashCode();
            result = 31 * result + this.readWriteLock.hashCode();
            return result;
        }
    }

    public static enum LOCK {
        SHARED,
        EXCLUSIVE;

    }
}

