/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.QueryExpr;
import apex.jorje.data.soql.WhereCalcOp;
import apex.jorje.data.soql.WhereCompoundOp;
import apex.jorje.data.soql.WhereExpr;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;

public class WhereExprPrinter
implements Printer<WhereExpr> {
    private final PrinterFactory factory;

    public WhereExprPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(WhereExpr x, final PrintContext ctx) {
        return x.match(new WhereExpr.MatchBlock<String>(){

            @Override
            public String _case(WhereExpr.WhereCalcExpr x) {
                String calc = x.calc.match(new WhereCalcOp.MatchBlock<String>(){

                    @Override
                    public String _case(WhereCalcOp.WhereCalcPlus x) {
                        return "+";
                    }

                    @Override
                    public String _case(WhereCalcOp.WhereCalcMinus x) {
                        return "-";
                    }
                });
                return WhereExprPrinter.this.factory.fieldIdentifierPrinter().print(x.field1, ctx) + " " + calc + " " + WhereExprPrinter.this.factory.fieldIdentifierPrinter().print(x.field2, ctx) + " " + WhereExprPrinter.this.factory.queryOpPrinter().print(x.op, ctx) + " " + WhereExprPrinter.this.factory.queryExprPrinter().print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereDistanceExpr x) {
                return WhereExprPrinter.this.factory.distanceFunctionExprPrinter().print(x.distance, ctx) + " " + WhereExprPrinter.this.factory.queryOpPrinter().print(x.op, ctx) + " " + WhereExprPrinter.this.factory.queryExprPrinter().print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereOpExpr x) {
                return WhereExprPrinter.this.factory.fieldPrinter().print(x.field, ctx) + " " + WhereExprPrinter.this.factory.queryOpPrinter().print(x.op, ctx) + " " + WhereExprPrinter.this.factory.queryExprPrinter().print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereOpExprs x) {
                Printer<Iterable<QueryExpr>> listQueryExpr = ListPrinter.create(WhereExprPrinter.this.factory.queryExprPrinter(), ", ", "(", ")");
                return WhereExprPrinter.this.factory.fieldPrinter().print(x.field, ctx) + " " + WhereExprPrinter.this.factory.queryOpPrinter().print(x.op, ctx) + " " + listQueryExpr.print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereInnerExpr x) {
                return WhereExprPrinter.this.factory.fieldPrinter().print(x.field, ctx) + " " + WhereExprPrinter.this.factory.queryOpPrinter().print(x.op, ctx) + " (" + WhereExprPrinter.this.factory.queryPrinter().print(x.inner, ctx) + ")";
            }

            @Override
            public String _case(WhereExpr.WhereCompoundExpr x) {
                String separator = x.op.match(new WhereCompoundOp.MatchBlock<String>(){

                    @Override
                    public String _case(WhereCompoundOp.QueryAnd x) {
                        return " AND ";
                    }

                    @Override
                    public String _case(WhereCompoundOp.QueryOr x) {
                        return " OR ";
                    }
                });
                Printer<Iterable<WhereExpr>> listWhereExpr = ListPrinter.create(WhereExprPrinter.this.factory.whereExprPrinter(), separator, "(", ")");
                return listWhereExpr.print(x.expr, ctx);
            }

            @Override
            public String _case(WhereExpr.WhereUnaryExpr x) {
                return "(NOT " + WhereExprPrinter.this.factory.whereExprPrinter().print(x.expr, ctx) + ")";
            }
        });
    }
}

