/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.GroupByClause;
import apex.jorje.data.soql.GroupByType;
import apex.jorje.data.soql.HavingClause;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.Optional;
import java.util.stream.Collectors;

public class GroupByPrinter
implements Printer<GroupByClause> {
    private final PrinterFactory factory;

    public GroupByPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(GroupByClause x, PrintContext ctx) {
        String typeTemplate = x.type.map(value -> value.match(new GroupByType.MatchBlock<String>(){

            @Override
            public String _case(GroupByType.GroupByRollUp x) {
                return "ROLLUP(%s)";
            }

            @Override
            public String _case(GroupByType.GroupByCube x) {
                return "CUBE(%s)";
            }
        })).orElse("%s");
        Printer<Optional<HavingClause>> optionalHaving = OptionalPrinter.create(this.factory.havingPrinter(), "", " ", "");
        Printer<Iterable<Field>> listFieldPrinter = ListPrinter.create(this.factory.fieldPrinter(), ", ", "", "");
        ctx.checkAggregate(true);
        return "GROUP BY " + String.format(typeTemplate, listFieldPrinter.print(x.exprs.stream().map(input -> input.field).collect(Collectors.toList()), ctx)) + optionalHaving.print(x.having, ctx);
    }
}

