/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.soql;

import apex.jorje.data.soql.DataCategory;
import apex.jorje.data.soql.DataCategoryOperator;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import com.google.common.collect.Ordering;

public class DataCategoryPrinter
implements Printer<DataCategory> {
    private final PrinterFactory factory;

    public DataCategoryPrinter(PrinterFactory factory) {
        this.factory = factory;
    }

    @Override
    public String print(DataCategory x, PrintContext ctx) {
        Printer<Iterable<FieldIdentifier>> listFieldIdentifier = ListPrinter.create(this.factory.fieldIdentifierPrinter(), ", ", "(", ")");
        String op = x.op.match(new DataCategoryOperator.MatchBlock<String>(){

            @Override
            public String _case(DataCategoryOperator.DataCategoryAt x) {
                return "AT";
            }

            @Override
            public String _case(DataCategoryOperator.DataCategoryAbove x) {
                return "ABOVE";
            }

            @Override
            public String _case(DataCategoryOperator.DataCategoryBelow x) {
                return "BELOW";
            }

            @Override
            public String _case(DataCategoryOperator.DataCategoryAboveOrBelow x) {
                return "ABOVE_OR_BELOW";
            }
        });
        final PrintContext emptyContext = new PrintContext();
        Ordering<FieldIdentifier> ordering = new Ordering<FieldIdentifier>(){

            @Override
            public int compare(FieldIdentifier left, FieldIdentifier right) {
                return DataCategoryPrinter.this.factory.fieldIdentifierPrinter().print(left, emptyContext).compareTo(DataCategoryPrinter.this.factory.fieldIdentifierPrinter().print(right, emptyContext));
            }
        };
        return this.factory.fieldIdentifierPrinter().print(x.type, ctx) + " " + op + " " + listFieldIdentifier.print(ordering.sortedCopy(x.categories), ctx);
    }
}

