/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.BinaryOp;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.data.ast.Expr;
import java.util.Comparator;

public class ExprPrecedenceComparator
implements Comparator<Expr> {
    private static final Integer PRIMARY = 11;
    private static final Integer POSTFIX = 10;
    private static final Integer PREFIX = 9;
    private static final Integer MULTIPLY_DIVIDE = 8;
    private static final Integer ADD_SUBTRACT = 7;
    private static final Integer SHIFT = 6;
    private static final Integer COMPARISON = 5;
    private static final Integer BITWISE = 4;
    private static final Integer AND = 3;
    private static final Integer OR = 2;
    private static final Integer TERNARY = 1;
    private static final Integer ASSIGNMENT = 0;
    public static final ExprPrecedenceComparator INSTANCE = new ExprPrecedenceComparator();

    private ExprPrecedenceComparator() {
    }

    @Override
    public int compare(Expr l, Expr r) {
        return this.score(l).compareTo(this.score(r));
    }

    public Integer score(Expr expr) {
        return expr.match(new Expr.MatchBlock<Integer>(){

            @Override
            public Integer _case(Expr.AssignmentExpr x) {
                return ASSIGNMENT;
            }

            @Override
            public Integer _case(Expr.TernaryExpr x) {
                return TERNARY;
            }

            @Override
            public Integer _case(Expr.BinaryExpr x) {
                return x.op.match(new BinaryOp.MatchBlock<Integer>(){

                    @Override
                    public Integer _case(BinaryOp.Addition x) {
                        return ADD_SUBTRACT;
                    }

                    @Override
                    public Integer _case(BinaryOp.Subtraction x) {
                        return ADD_SUBTRACT;
                    }

                    @Override
                    public Integer _case(BinaryOp.Multiplication x) {
                        return MULTIPLY_DIVIDE;
                    }

                    @Override
                    public Integer _case(BinaryOp.Division x) {
                        return MULTIPLY_DIVIDE;
                    }

                    @Override
                    public Integer _case(BinaryOp.LeftShift x) {
                        return SHIFT;
                    }

                    @Override
                    public Integer _case(BinaryOp.SignedRightShift x) {
                        return SHIFT;
                    }

                    @Override
                    public Integer _case(BinaryOp.UnsignedRightShift x) {
                        return SHIFT;
                    }

                    @Override
                    public Integer _case(BinaryOp.BitwiseXor x) {
                        return BITWISE;
                    }

                    @Override
                    public Integer _case(BinaryOp.BitwiseAnd x) {
                        return BITWISE;
                    }

                    @Override
                    public Integer _case(BinaryOp.BitwiseOr x) {
                        return BITWISE;
                    }
                });
            }

            @Override
            public Integer _case(Expr.InstanceOf x) {
                return COMPARISON;
            }

            @Override
            public Integer _case(Expr.BooleanExpr x) {
                return x.op.match(new BooleanOp.MatchBlockWithDefault<Integer>(){

                    @Override
                    protected Integer _default(BooleanOp x) {
                        return COMPARISON;
                    }

                    @Override
                    public Integer _case(BooleanOp.And x) {
                        return AND;
                    }

                    @Override
                    public Integer _case(BooleanOp.Or x) {
                        return OR;
                    }
                });
            }

            @Override
            public Integer _case(Expr.TriggerVariableExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.PackageVersionExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.PrefixExpr x) {
                return PREFIX;
            }

            @Override
            public Integer _case(Expr.PostfixExpr x) {
                return POSTFIX;
            }

            @Override
            public Integer _case(Expr.VariableExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.ArrayExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.MethodCallExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.JavaMethodCallExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.JavaVariableExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.SuperMethodCallExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.SuperVariableExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.ThisMethodCallExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.ThisVariableExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.ClassRefExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.LiteralExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.NewExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.NestedExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.SoqlExpr x) {
                return PRIMARY;
            }

            @Override
            public Integer _case(Expr.SoslExpr x) {
                return PRIMARY;
            }
        });
    }
}

