/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.EnumDecl;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.Modifier;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import java.util.stream.Collectors;

public class EnumDeclPrinter
implements Printer<EnumDecl> {
    private final PrinterFactory factory;
    private final Printer<Iterable<Modifier>> modifiersPrinter;
    private final Printer<Identifier> identifierPrinter;

    public EnumDeclPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.modifiersPrinter = factory.modifiersPrinter();
        this.identifierPrinter = factory.identifierPrinter();
    }

    @Override
    public String print(EnumDecl x, PrintContext ctx) {
        StringBuilder builder = new StringBuilder(this.factory.indent());
        builder.append(this.modifiersPrinter.print(x.modifiers, ctx));
        builder.append("enum ");
        builder.append(this.identifierPrinter.print(x.name, ctx));
        builder.append(" {\n");
        String enums = x.members.values.stream().map(identifier -> this.factory.nestedPrinterFactory().indent() + this.factory.identifierPrinter().print((Identifier)identifier, ctx)).collect(Collectors.joining(",\n"));
        builder.append(enums).append(enums.isEmpty() ? "" : "\n");
        builder.append(this.factory.indent());
        builder.append("}");
        return builder.toString();
    }
}

