/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers.ast;

import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.PrintContext;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.OptionalPrinter;
import java.util.Optional;

public class ClassDeclPrinter
implements Printer<ClassDecl> {
    private final String indent;
    private final PrinterFactory factory;
    private final Printer<Iterable<Modifier>> modifiersPrinter;
    private final Printer<Optional<GroupedList<Identifier>>> formalTypeArgumentsPrinter;
    private final Printer<Identifier> identifierPrinter;

    public ClassDeclPrinter(PrinterFactory factory) {
        this.factory = factory;
        this.indent = factory.indent();
        this.modifiersPrinter = factory.modifiersPrinter();
        this.formalTypeArgumentsPrinter = factory.formalTypeArgumentsPrinter();
        this.identifierPrinter = factory.identifierPrinter();
    }

    @Override
    public String print(ClassDecl x, PrintContext ctx) {
        StringBuilder builder = new StringBuilder(this.indent);
        builder.append(this.modifiersPrinter.print(x.modifiers, ctx));
        builder.append("class");
        builder.append(" ");
        builder.append(this.identifierPrinter.print(x.name, ctx));
        builder.append(this.formalTypeArgumentsPrinter.print(x.formalTypeArguments, ctx));
        Printer<Optional<TypeRef>> optionalSuperClassPrinter = OptionalPrinter.create(this.factory.typeRefPrinter(), "", " extends ", "");
        builder.append(optionalSuperClassPrinter.print(x.superClass, ctx));
        Printer<Iterable<TypeRef>> listInterfacePrinter = ListPrinter.create(this.factory.typeRefPrinter(), ", ", " implements ", "");
        builder.append(listInterfacePrinter.print(x.interfaces, ctx));
        builder.append(" {\n");
        Printer<Iterable<BlockMember>> listMemberPrinter = ListPrinter.create(this.factory.nestedPrinterFactory().blockMemberPrinter(), "\n\n", "", "\n");
        builder.append(listMemberPrinter.print(x.members.values, ctx));
        builder.append(this.indent);
        builder.append("}");
        return builder.toString();
    }
}

