/*
 * Decompiled with CFR 0.152.
 */
package apex.jorje.services.printers;

import apex.jorje.data.Loc;
import apex.jorje.data.ast.AnnotationParameter;
import apex.jorje.data.ast.AssignmentOp;
import apex.jorje.data.ast.BinaryOp;
import apex.jorje.data.ast.BlockMember;
import apex.jorje.data.ast.BooleanOp;
import apex.jorje.data.ast.Case;
import apex.jorje.data.ast.CatchBlock;
import apex.jorje.data.ast.ClassDecl;
import apex.jorje.data.ast.CompilationUnit;
import apex.jorje.data.ast.ElseBlock;
import apex.jorje.data.ast.EnumDecl;
import apex.jorje.data.ast.Expr;
import apex.jorje.data.ast.FinallyBlock;
import apex.jorje.data.ast.ForControl;
import apex.jorje.data.ast.FormalParameter;
import apex.jorje.data.ast.GroupedList;
import apex.jorje.data.ast.Identifier;
import apex.jorje.data.ast.IfBlock;
import apex.jorje.data.ast.InterfaceDecl;
import apex.jorje.data.ast.JavaRef;
import apex.jorje.data.ast.Literal;
import apex.jorje.data.ast.MethodDecl;
import apex.jorje.data.ast.Modifier;
import apex.jorje.data.ast.NameValueParameter;
import apex.jorje.data.ast.ObjectCreator;
import apex.jorje.data.ast.PostfixOp;
import apex.jorje.data.ast.PrefixOp;
import apex.jorje.data.ast.PropertyDecl;
import apex.jorje.data.ast.PropertyGetter;
import apex.jorje.data.ast.PropertySetter;
import apex.jorje.data.ast.Stmnt;
import apex.jorje.data.ast.TriggerUsage;
import apex.jorje.data.ast.TypeRef;
import apex.jorje.data.ast.VariableDecl;
import apex.jorje.data.ast.VariableDecls;
import apex.jorje.data.errors.LexicalError;
import apex.jorje.data.errors.SyntaxError;
import apex.jorje.data.errors.UserError;
import apex.jorje.data.soql.BindClause;
import apex.jorje.data.soql.BindExpr;
import apex.jorje.data.soql.CaseExpr;
import apex.jorje.data.soql.CaseOp;
import apex.jorje.data.soql.ColonExpr;
import apex.jorje.data.soql.DataCategory;
import apex.jorje.data.soql.DistanceFunctionExpr;
import apex.jorje.data.soql.ElseExpr;
import apex.jorje.data.soql.Field;
import apex.jorje.data.soql.FieldIdentifier;
import apex.jorje.data.soql.FromClause;
import apex.jorje.data.soql.FromExpr;
import apex.jorje.data.soql.GroupByClause;
import apex.jorje.data.soql.HavingClause;
import apex.jorje.data.soql.LimitClause;
import apex.jorje.data.soql.OffsetClause;
import apex.jorje.data.soql.OrderByClause;
import apex.jorje.data.soql.OrderByExpr;
import apex.jorje.data.soql.Query;
import apex.jorje.data.soql.QueryExpr;
import apex.jorje.data.soql.QueryLiteral;
import apex.jorje.data.soql.QueryOp;
import apex.jorje.data.soql.QueryOption;
import apex.jorje.data.soql.SelectClause;
import apex.jorje.data.soql.SelectExpr;
import apex.jorje.data.soql.SoqlUsingClause;
import apex.jorje.data.soql.TrackingType;
import apex.jorje.data.soql.UpdateStatsClause;
import apex.jorje.data.soql.UsingExpr;
import apex.jorje.data.soql.WhenExpr;
import apex.jorje.data.soql.WhenOp;
import apex.jorje.data.soql.WhereClause;
import apex.jorje.data.soql.WhereExpr;
import apex.jorje.data.soql.WithClause;
import apex.jorje.data.sosl.FindClause;
import apex.jorje.data.sosl.InClause;
import apex.jorje.data.sosl.ReturningClause;
import apex.jorje.data.sosl.ReturningExpr;
import apex.jorje.data.sosl.ReturningSelectExpr;
import apex.jorje.data.sosl.Search;
import apex.jorje.data.sosl.SoslUsingClause;
import apex.jorje.data.sosl.SoslWithClause;
import apex.jorje.data.sosl.WithDataCategoryClause;
import apex.jorje.data.sosl.WithDivisionClause;
import apex.jorje.data.sosl.WithNetworkClause;
import apex.jorje.data.sosl.WithSnippetClause;
import apex.jorje.services.printers.ListPrinter;
import apex.jorje.services.printers.Printer;
import apex.jorje.services.printers.PrinterFactory;
import apex.jorje.services.printers.ast.AnnotationParameterPrinter;
import apex.jorje.services.printers.ast.AssignmentOpPrinter;
import apex.jorje.services.printers.ast.BinaryOpPrinter;
import apex.jorje.services.printers.ast.BlockMemberPrinter;
import apex.jorje.services.printers.ast.BooleanOpPrinter;
import apex.jorje.services.printers.ast.CasePrinter;
import apex.jorje.services.printers.ast.CatchBlockPrinter;
import apex.jorje.services.printers.ast.ClassDeclPrinter;
import apex.jorje.services.printers.ast.CompilationUnitPrinter;
import apex.jorje.services.printers.ast.ElseBlockPrinter;
import apex.jorje.services.printers.ast.EnumDeclPrinter;
import apex.jorje.services.printers.ast.ExprPrinter;
import apex.jorje.services.printers.ast.FinallyBlockPrinter;
import apex.jorje.services.printers.ast.ForControlPrinter;
import apex.jorje.services.printers.ast.FormalParameterPrinter;
import apex.jorje.services.printers.ast.GroupedListPrinter;
import apex.jorje.services.printers.ast.IdentifierPrinter;
import apex.jorje.services.printers.ast.IfBlockPrinter;
import apex.jorje.services.printers.ast.InterfaceDeclPrinter;
import apex.jorje.services.printers.ast.JavaRefPrinter;
import apex.jorje.services.printers.ast.LiteralPrinter;
import apex.jorje.services.printers.ast.MethodDeclPrinter;
import apex.jorje.services.printers.ast.ModifierPrinter;
import apex.jorje.services.printers.ast.NameValueParameterPrinter;
import apex.jorje.services.printers.ast.ObjectCreatorPrinter;
import apex.jorje.services.printers.ast.OptionalNestedStatementPrinter;
import apex.jorje.services.printers.ast.OptionalPrinter;
import apex.jorje.services.printers.ast.PostfixOpPrinter;
import apex.jorje.services.printers.ast.PrefixOpPrinter;
import apex.jorje.services.printers.ast.PropertyDeclPrinter;
import apex.jorje.services.printers.ast.PropertyGetterPrinter;
import apex.jorje.services.printers.ast.PropertySetterPrinter;
import apex.jorje.services.printers.ast.StmntPrinter;
import apex.jorje.services.printers.ast.TriggerUsagePrinter;
import apex.jorje.services.printers.ast.TypeRefPrinter;
import apex.jorje.services.printers.ast.VariableDeclPrinter;
import apex.jorje.services.printers.ast.VariableDeclsPrinter;
import apex.jorje.services.printers.errors.LexicalErrorPrinter;
import apex.jorje.services.printers.errors.SyntaxErrorPrinter;
import apex.jorje.services.printers.errors.UserErrorPrinter;
import apex.jorje.services.printers.location.LocPrinter;
import apex.jorje.services.printers.soql.BindExprPrinter;
import apex.jorje.services.printers.soql.BindPrinter;
import apex.jorje.services.printers.soql.CaseExprPrinter;
import apex.jorje.services.printers.soql.CaseOpPrinter;
import apex.jorje.services.printers.soql.ColonExprPrinter;
import apex.jorje.services.printers.soql.DataCategoryPrinter;
import apex.jorje.services.printers.soql.DistanceFunctionExprPrinter;
import apex.jorje.services.printers.soql.ElseExprPrinter;
import apex.jorje.services.printers.soql.FieldIdentifierPrinter;
import apex.jorje.services.printers.soql.FieldPrinter;
import apex.jorje.services.printers.soql.FromClausePrinter;
import apex.jorje.services.printers.soql.FromExprPrinter;
import apex.jorje.services.printers.soql.GroupByPrinter;
import apex.jorje.services.printers.soql.HavingPrinter;
import apex.jorje.services.printers.soql.LimitPrinter;
import apex.jorje.services.printers.soql.OffsetPrinter;
import apex.jorje.services.printers.soql.OrderByExprPrinter;
import apex.jorje.services.printers.soql.OrderByPrinter;
import apex.jorje.services.printers.soql.QueryExprPrinter;
import apex.jorje.services.printers.soql.QueryLiteralPrinter;
import apex.jorje.services.printers.soql.QueryOpPrinter;
import apex.jorje.services.printers.soql.QueryOptionPrinter;
import apex.jorje.services.printers.soql.QueryPrinter;
import apex.jorje.services.printers.soql.SelectExprPrinter;
import apex.jorje.services.printers.soql.SelectPrinter;
import apex.jorje.services.printers.soql.SoqlUsingPrinter;
import apex.jorje.services.printers.soql.TrackingTypePrinter;
import apex.jorje.services.printers.soql.UpdateStatsOptionsPrinter;
import apex.jorje.services.printers.soql.UsingExprPrinter;
import apex.jorje.services.printers.soql.WhenExprPrinter;
import apex.jorje.services.printers.soql.WhenOpPrinter;
import apex.jorje.services.printers.soql.WhereExprPrinter;
import apex.jorje.services.printers.soql.WherePrinter;
import apex.jorje.services.printers.soql.WithPrinter;
import apex.jorje.services.printers.sosl.FindPrinter;
import apex.jorje.services.printers.sosl.InPrinter;
import apex.jorje.services.printers.sosl.ReturningExprPrinter;
import apex.jorje.services.printers.sosl.ReturningPrinter;
import apex.jorje.services.printers.sosl.ReturningSelectExprPrinter;
import apex.jorje.services.printers.sosl.SearchPrinter;
import apex.jorje.services.printers.sosl.SoslUsingPrinter;
import apex.jorje.services.printers.sosl.SoslWithClausePrinter;
import apex.jorje.services.printers.sosl.WithDataCategoryPrinter;
import apex.jorje.services.printers.sosl.WithDivisionPrinter;
import apex.jorje.services.printers.sosl.WithNetworkPrinter;
import apex.jorje.services.printers.sosl.WithSnippetPrinter;
import com.google.common.base.Strings;
import java.util.Optional;

public class StandardPrinterFactory
implements PrinterFactory {
    private static final Printer<Literal> LITERAL_PRINTER = new LiteralPrinter();
    private static final Printer<QueryLiteral> QUERY_LITERAL_PRINTER = new QueryLiteralPrinter();
    private static final Printer<PostfixOp> POSTFIX_OP_PRINTER = new PostfixOpPrinter();
    private static final Printer<BinaryOp> BINARY_OP_PRINTER = new BinaryOpPrinter();
    private static final Printer<AssignmentOp> ASSIGNMENT_OP_PRINTER = new AssignmentOpPrinter(BINARY_OP_PRINTER);
    private static final Printer<BooleanOp> BOOLEAN_OP_PRINTER = new BooleanOpPrinter();
    private static final Printer<Identifier> IDENTIFIER_PRINTER = new IdentifierPrinter();
    private static final Printer<Iterable<Identifier>> DOTTED_IDENTIFIER_PRINTER = ListPrinter.create(IDENTIFIER_PRINTER, ".", "", "");
    private static final Printer<AnnotationParameter> ANNOTATION_PARAMETER_PRINTER = new AnnotationParameterPrinter(IDENTIFIER_PRINTER);
    private static final Printer<Modifier> MODIFIER_PRINTER = new ModifierPrinter(IDENTIFIER_PRINTER, ANNOTATION_PARAMETER_PRINTER);
    private static final Printer<Iterable<Modifier>> MODIFIERS_PRINTER = ListPrinter.create(MODIFIER_PRINTER, " ", "", " ");
    private static final Printer<Optional<GroupedList<Identifier>>> FORMAL_TYPE_PARAMETERS_PRINTER = OptionalPrinter.create(GroupedListPrinter.create(IDENTIFIER_PRINTER, ", ", "<", ">"), "", "", "");
    private static final Printer<Iterable<Identifier>> IDENTIFIERS_PRINTER = ListPrinter.create(IDENTIFIER_PRINTER, ", ", "", "");
    private static final Printer<FieldIdentifier> FIELD_IDENTIFIER_PRINTER = new FieldIdentifierPrinter(IDENTIFIER_PRINTER);
    private static final Printer<UsingExpr> USING_EXPR_PRINTER = new UsingExprPrinter(FIELD_IDENTIFIER_PRINTER);
    private static final Printer<SoqlUsingClause> SOQL_USING_PRINTER = new SoqlUsingPrinter(USING_EXPR_PRINTER);
    private static final Printer<Optional<JavaRef>> JAVA_REF_PRINTER = OptionalPrinter.create(new JavaRefPrinter(), "", "", "");
    private static final Printer<TypeRef> TYPE_REF_PRINTER = new TypeRefPrinter(DOTTED_IDENTIFIER_PRINTER, JAVA_REF_PRINTER);
    private static final Printer<PrefixOp> PREFIX_OP_PRINTER = new PrefixOpPrinter(TYPE_REF_PRINTER);
    private static final Printer<Iterable<TypeRef>> TYPE_REFS_PRINTER = ListPrinter.create(TYPE_REF_PRINTER, ", ", "", "");
    private static final Printer<FormalParameter> FORMAL_PARAMETER_PRINTER = new FormalParameterPrinter(MODIFIERS_PRINTER, TYPE_REF_PRINTER, IDENTIFIER_PRINTER);
    private static final Printer<Iterable<FormalParameter>> FORMAL_PARAMETERS_PRINTER = ListPrinter.create(FORMAL_PARAMETER_PRINTER, ", ", "", "");
    private static final Printer<TriggerUsage> TRIGGER_USAGE_PRINTER = new TriggerUsagePrinter();
    private static final Printer<GroupedList<TriggerUsage>> TRIGGER_USAGES_PRINTER = GroupedListPrinter.create(TRIGGER_USAGE_PRINTER, ", ", "(", ")");
    private static final Printer<UpdateStatsClause> UPDATE_STATS_OPTIONS_PRINTER = new UpdateStatsOptionsPrinter();
    private static final Printer<TrackingType> TRACKING_TYPE_PRINTER = new TrackingTypePrinter();
    private static final Printer<QueryOption> QUERY_OPTION_PRINTER = new QueryOptionPrinter();
    private static final Printer<SoslUsingClause> SOSL_USING_PRINTER = new SoslUsingPrinter();
    private static final Printer<ColonExpr> COLON_EXPR_PRINTER = new ColonExprPrinter();
    private static final Printer<QueryOp> QUERY_OP_PRINTER = new QueryOpPrinter();
    private static final Printer<InClause> IN_PRINTER = new InPrinter();
    private final int indentLevel;
    private final String indent;
    private final String singleIndent;
    private final Printer<ObjectCreator> objectCreatorPrinter;
    private final Printer<Expr> exprPrinter;
    private final Printer<Iterable<Expr>> exprListPrinter;
    private final Printer<PropertyGetter> propertyGetterPrinter;
    private final Printer<PropertySetter> propertySetterPrinter;
    private final Printer<PropertyDecl> propertyDeclPrinter;
    private final Printer<MethodDecl> methodDeclPrinter;
    private final Printer<Stmnt> stmntPrinter;
    private final Printer<Optional<Stmnt>> optionalNestedStatementPrinter;
    private final Printer<VariableDecl> variableDeclPrinter;
    private final Printer<ClassDecl> classDeclPrinter;
    private final Printer<InterfaceDecl> interfaceDeclPrinter;
    private final Printer<VariableDecls> variableDeclsPrinter;
    private final Printer<EnumDecl> enumDeclPrinter;
    private final Printer<BlockMember> blockMemberPrinter;
    private final Printer<CompilationUnit> compilationUnitPrinter;
    private final Printer<Case> casePrinter;
    private final Printer<Query> queryPrinter;
    private final Printer<SelectClause> selectPrinter;
    private final Printer<FromClause> fromClausePrinter;
    private final Printer<SelectExpr> selectExprPrinter;
    private final Printer<Field> fieldPrinter;
    private final Printer<CaseExpr> caseExprPrinter;
    private final Printer<CaseOp> caseOpPrinter;
    private final Printer<WhenExpr> whenExprPrinter;
    private final Printer<WhenOp> whenOpPrinter;
    private final Printer<ElseExpr> elseExprPrinter;
    private final Printer<FromExpr> fromExprPrinter;
    private final Printer<WhereClause> wherePrinter;
    private final Printer<WhereExpr> whereExprPrinter;
    private final Printer<QueryExpr> queryExprPrinter;
    private final Printer<DistanceFunctionExpr> distanceFunctionExpr;
    private final Printer<WithClause> withPrinter;
    private final Printer<DataCategory> dataCategoryPrinter;
    private final Printer<GroupByClause> groupByPrinter;
    private final Printer<HavingClause> havingPrinter;
    private final Printer<OrderByClause> orderByPrinter;
    private final Printer<OrderByExpr> orderByExprPrinter;
    private final Printer<LimitClause> limitPrinter;
    private final Printer<OffsetClause> offsetPrinter;
    private final Printer<BindClause> bindPrinter;
    private final Printer<BindExpr> bindExprPrinter;
    private final Printer<FindClause> findPrinter;
    private final Printer<ReturningClause> returningPrinter;
    private final Printer<ReturningExpr> returningExprPrinter;
    private final Printer<ReturningSelectExpr> returningSelectExprPrinter;
    private final Printer<WithDivisionClause> withDivisionPrinter;
    private final Printer<WithDataCategoryClause> withDataCategoryPrinter;
    private final Printer<WithNetworkClause> withNetworkPrinter;
    private final Printer<WithSnippetClause> withSnippetPrinter;
    private final Printer<SoslWithClause> soslWithPrinter;
    private final Printer<Search> searchPrinter;
    private final Printer<Loc> locPrinter;
    private final Printer<LexicalError> lexicalErrorPrinter;
    private final Printer<SyntaxError> syntaxErrorPrinter;
    private final Printer<UserError> userErrorPrinter;
    private final Printer<ForControl> forControlPrinter;
    private final Printer<NameValueParameter> nameValueParameterPrinter;
    private final Printer<IfBlock> ifBlockPrinter;
    private final Printer<ElseBlock> elseBlockPrinter;
    private final Printer<CatchBlock> catchBlockPrinter;
    private final Printer<FinallyBlock> finallyBlockPrinter;
    private PrinterFactory nestedASTPrinterFactory;

    public StandardPrinterFactory(int indentLevel, String singleIndent) {
        this.indentLevel = indentLevel;
        this.singleIndent = singleIndent;
        this.indent = Strings.repeat(singleIndent, indentLevel);
        this.locPrinter = new LocPrinter();
        this.lexicalErrorPrinter = new LexicalErrorPrinter();
        this.syntaxErrorPrinter = new SyntaxErrorPrinter();
        this.userErrorPrinter = new UserErrorPrinter(this);
        this.stmntPrinter = new StmntPrinter(this);
        this.optionalNestedStatementPrinter = new OptionalNestedStatementPrinter(this);
        this.propertyGetterPrinter = new PropertyGetterPrinter(this);
        this.propertySetterPrinter = new PropertySetterPrinter(this);
        this.propertyDeclPrinter = new PropertyDeclPrinter(this);
        this.methodDeclPrinter = new MethodDeclPrinter(this);
        this.variableDeclPrinter = new VariableDeclPrinter(this);
        this.variableDeclsPrinter = new VariableDeclsPrinter(this);
        this.classDeclPrinter = new ClassDeclPrinter(this);
        this.interfaceDeclPrinter = new InterfaceDeclPrinter(this);
        this.enumDeclPrinter = new EnumDeclPrinter(this);
        this.blockMemberPrinter = new BlockMemberPrinter(this);
        this.compilationUnitPrinter = new CompilationUnitPrinter(this);
        this.forControlPrinter = new ForControlPrinter(this);
        this.nameValueParameterPrinter = new NameValueParameterPrinter(this);
        this.ifBlockPrinter = new IfBlockPrinter(this);
        this.elseBlockPrinter = new ElseBlockPrinter(this);
        this.catchBlockPrinter = new CatchBlockPrinter(this);
        this.finallyBlockPrinter = new FinallyBlockPrinter(this);
        this.exprPrinter = new ExprPrinter(this);
        this.exprListPrinter = ListPrinter.create(this.exprPrinter, ", ", "", "");
        this.objectCreatorPrinter = new ObjectCreatorPrinter(this);
        this.casePrinter = new CasePrinter(this);
        this.queryPrinter = new QueryPrinter(this);
        this.selectPrinter = new SelectPrinter(this);
        this.fromClausePrinter = new FromClausePrinter(this);
        this.selectExprPrinter = new SelectExprPrinter(this);
        this.fieldPrinter = new FieldPrinter(this);
        this.caseExprPrinter = new CaseExprPrinter(this);
        this.caseOpPrinter = new CaseOpPrinter(this);
        this.whenExprPrinter = new WhenExprPrinter(this);
        this.whenOpPrinter = new WhenOpPrinter(this);
        this.elseExprPrinter = new ElseExprPrinter(this);
        this.fromExprPrinter = new FromExprPrinter(this);
        this.wherePrinter = new WherePrinter(this);
        this.whereExprPrinter = new WhereExprPrinter(this);
        this.queryExprPrinter = new QueryExprPrinter(this);
        this.distanceFunctionExpr = new DistanceFunctionExprPrinter(this);
        this.withPrinter = new WithPrinter(this);
        this.dataCategoryPrinter = new DataCategoryPrinter(this);
        this.groupByPrinter = new GroupByPrinter(this);
        this.havingPrinter = new HavingPrinter(this);
        this.orderByPrinter = new OrderByPrinter(this);
        this.orderByExprPrinter = new OrderByExprPrinter(this);
        this.limitPrinter = new LimitPrinter(this);
        this.offsetPrinter = new OffsetPrinter(this);
        this.bindPrinter = new BindPrinter(this);
        this.bindExprPrinter = new BindExprPrinter(this);
        this.findPrinter = new FindPrinter(this);
        this.returningPrinter = new ReturningPrinter(this);
        this.returningExprPrinter = new ReturningExprPrinter(this);
        this.returningSelectExprPrinter = new ReturningSelectExprPrinter(this);
        this.withDivisionPrinter = new WithDivisionPrinter(this);
        this.withDataCategoryPrinter = new WithDataCategoryPrinter(this);
        this.withNetworkPrinter = new WithNetworkPrinter(this);
        this.withSnippetPrinter = new WithSnippetPrinter();
        this.searchPrinter = new SearchPrinter(this);
        this.soslWithPrinter = new SoslWithClausePrinter(this);
    }

    @Override
    public synchronized PrinterFactory nestedPrinterFactory() {
        if (this.nestedASTPrinterFactory == null) {
            this.nestedASTPrinterFactory = new StandardPrinterFactory(this.indentLevel + 1, this.singleIndent);
        }
        return this.nestedASTPrinterFactory;
    }

    @Override
    public String indent() {
        return this.indent;
    }

    @Override
    public Printer<Iterable<Identifier>> dottedIdentifier() {
        return DOTTED_IDENTIFIER_PRINTER;
    }

    @Override
    public Printer<Optional<Stmnt>> optionalNestedStmntPrinter() {
        return this.optionalNestedStatementPrinter;
    }

    @Override
    public Printer<Stmnt> stmntPrinter() {
        return this.stmntPrinter;
    }

    @Override
    public Printer<MethodDecl> methodDeclPrinter() {
        return this.methodDeclPrinter;
    }

    @Override
    public Printer<PropertyDecl> propertyDeclPrinter() {
        return this.propertyDeclPrinter;
    }

    @Override
    public Printer<PropertySetter> propertySetterPrinter() {
        return this.propertySetterPrinter;
    }

    @Override
    public Printer<PropertyGetter> propertyGetterPrinter() {
        return this.propertyGetterPrinter;
    }

    @Override
    public Printer<ClassDecl> classDeclPrinter() {
        return this.classDeclPrinter;
    }

    @Override
    public Printer<InterfaceDecl> interfaceDeclPrinter() {
        return this.interfaceDeclPrinter;
    }

    @Override
    public Printer<Expr> exprPrinter() {
        return this.exprPrinter;
    }

    @Override
    public Printer<TypeRef> typeRefPrinter() {
        return TYPE_REF_PRINTER;
    }

    @Override
    public Printer<EnumDecl> enumDeclPrinter() {
        return this.enumDeclPrinter;
    }

    @Override
    public Printer<VariableDecls> variableDeclsPrinter() {
        return this.variableDeclsPrinter;
    }

    @Override
    public Printer<VariableDecl> variableDeclPrinter() {
        return this.variableDeclPrinter;
    }

    @Override
    public Printer<BlockMember> blockMemberPrinter() {
        return this.blockMemberPrinter;
    }

    @Override
    public Printer<Iterable<Modifier>> modifiersPrinter() {
        return MODIFIERS_PRINTER;
    }

    @Override
    public Printer<TriggerUsage> triggerUsagePrinter() {
        return TRIGGER_USAGE_PRINTER;
    }

    @Override
    public Printer<GroupedList<TriggerUsage>> triggerUsagesPrinter() {
        return TRIGGER_USAGES_PRINTER;
    }

    @Override
    public Printer<CompilationUnit> compilationUnitPrinter() {
        return this.compilationUnitPrinter;
    }

    @Override
    public Printer<Iterable<TypeRef>> typeRefsPrinter() {
        return TYPE_REFS_PRINTER;
    }

    @Override
    public Printer<Optional<GroupedList<Identifier>>> formalTypeArgumentsPrinter() {
        return FORMAL_TYPE_PARAMETERS_PRINTER;
    }

    @Override
    public Printer<Iterable<Identifier>> identifiersPrinter() {
        return IDENTIFIERS_PRINTER;
    }

    @Override
    public Printer<Iterable<FormalParameter>> formalParametersPrinter() {
        return FORMAL_PARAMETERS_PRINTER;
    }

    @Override
    public Printer<Iterable<Expr>> exprListPrinter() {
        return this.exprListPrinter;
    }

    @Override
    public Printer<FormalParameter> formalParameterPrinter() {
        return FORMAL_PARAMETER_PRINTER;
    }

    @Override
    public Printer<Identifier> identifierPrinter() {
        return IDENTIFIER_PRINTER;
    }

    @Override
    public Printer<Modifier> modifierPrinter() {
        return MODIFIER_PRINTER;
    }

    @Override
    public Printer<Case> casePrinter() {
        return this.casePrinter;
    }

    @Override
    public Printer<Query> queryPrinter() {
        return this.queryPrinter;
    }

    @Override
    public Printer<SelectClause> selectPrinter() {
        return this.selectPrinter;
    }

    @Override
    public Printer<FromClause> fromPrinter() {
        return this.fromClausePrinter;
    }

    @Override
    public Printer<WhereClause> wherePrinter() {
        return this.wherePrinter;
    }

    @Override
    public Printer<WithClause> withPrinter() {
        return this.withPrinter;
    }

    @Override
    public Printer<GroupByClause> groupByPrinter() {
        return this.groupByPrinter;
    }

    @Override
    public Printer<HavingClause> havingPrinter() {
        return this.havingPrinter;
    }

    @Override
    public Printer<OrderByClause> orderByPrinter() {
        return this.orderByPrinter;
    }

    @Override
    public Printer<OrderByExpr> orderByExprPrinter() {
        return this.orderByExprPrinter;
    }

    @Override
    public Printer<LimitClause> limitPrinter() {
        return this.limitPrinter;
    }

    @Override
    public Printer<OffsetClause> offsetPrinter() {
        return this.offsetPrinter;
    }

    @Override
    public Printer<BindClause> bindPrinter() {
        return this.bindPrinter;
    }

    @Override
    public Printer<BindExpr> bindExprPrinter() {
        return this.bindExprPrinter;
    }

    @Override
    public Printer<TrackingType> trackingTypePrinter() {
        return TRACKING_TYPE_PRINTER;
    }

    @Override
    public Printer<UpdateStatsClause> updateStatsOptionsPrinter() {
        return UPDATE_STATS_OPTIONS_PRINTER;
    }

    @Override
    public Printer<QueryOption> queryOptionPrinter() {
        return QUERY_OPTION_PRINTER;
    }

    @Override
    public Printer<SelectExpr> selectExprPrinter() {
        return this.selectExprPrinter;
    }

    @Override
    public Printer<CaseExpr> caseExprPrinter() {
        return this.caseExprPrinter;
    }

    @Override
    public Printer<Field> fieldPrinter() {
        return this.fieldPrinter;
    }

    @Override
    public Printer<FieldIdentifier> fieldIdentifierPrinter() {
        return FIELD_IDENTIFIER_PRINTER;
    }

    @Override
    public Printer<CaseOp> caseOpPrinter() {
        return this.caseOpPrinter;
    }

    @Override
    public Printer<WhenExpr> whenExprPrinter() {
        return this.whenExprPrinter;
    }

    @Override
    public Printer<ElseExpr> elseExprPrinter() {
        return this.elseExprPrinter;
    }

    @Override
    public Printer<WhenOp> whenOpPrinter() {
        return this.whenOpPrinter;
    }

    @Override
    public Printer<FromExpr> fromExprPrinter() {
        return this.fromExprPrinter;
    }

    @Override
    public Printer<WhereExpr> whereExprPrinter() {
        return this.whereExprPrinter;
    }

    @Override
    public Printer<QueryOp> queryOpPrinter() {
        return QUERY_OP_PRINTER;
    }

    @Override
    public Printer<QueryExpr> queryExprPrinter() {
        return this.queryExprPrinter;
    }

    @Override
    public Printer<ColonExpr> colonExprPrinter() {
        return COLON_EXPR_PRINTER;
    }

    @Override
    public Printer<QueryLiteral> queryLiteralPrinter() {
        return QUERY_LITERAL_PRINTER;
    }

    @Override
    public Printer<DistanceFunctionExpr> distanceFunctionExprPrinter() {
        return this.distanceFunctionExpr;
    }

    @Override
    public Printer<DataCategory> dataCategoryPrinter() {
        return this.dataCategoryPrinter;
    }

    @Override
    public Printer<FindClause> findPrinter() {
        return this.findPrinter;
    }

    @Override
    public Printer<InClause> inPrinter() {
        return IN_PRINTER;
    }

    @Override
    public Printer<ReturningClause> returningPrinter() {
        return this.returningPrinter;
    }

    @Override
    public Printer<SoslUsingClause> usingPrinter() {
        return SOSL_USING_PRINTER;
    }

    @Override
    public Printer<ReturningExpr> returningExprPrinter() {
        return this.returningExprPrinter;
    }

    @Override
    public Printer<ReturningSelectExpr> returningSelectExprPrinter() {
        return this.returningSelectExprPrinter;
    }

    @Override
    public Printer<WithDivisionClause> withDivisionPrinter() {
        return this.withDivisionPrinter;
    }

    @Override
    public Printer<WithDataCategoryClause> withDataCategoryPrinter() {
        return this.withDataCategoryPrinter;
    }

    @Override
    public Printer<WithNetworkClause> withNetworkPrinter() {
        return this.withNetworkPrinter;
    }

    @Override
    public Printer<Search> searchPrinter() {
        return this.searchPrinter;
    }

    @Override
    public Printer<WithSnippetClause> withSnippetPrinter() {
        return this.withSnippetPrinter;
    }

    @Override
    public Printer<Loc> loc() {
        return this.locPrinter;
    }

    @Override
    public Printer<LexicalError> lexicalErrorPrinter() {
        return this.lexicalErrorPrinter;
    }

    @Override
    public Printer<SyntaxError> syntaxErrorPrinter() {
        return this.syntaxErrorPrinter;
    }

    @Override
    public Printer<UserError> userErrorPrinter() {
        return this.userErrorPrinter;
    }

    @Override
    public Printer<ForControl> forControlPrinter() {
        return this.forControlPrinter;
    }

    @Override
    public Printer<NameValueParameter> nameValueParameter() {
        return this.nameValueParameterPrinter;
    }

    @Override
    public Printer<IfBlock> ifBlockPrinter() {
        return this.ifBlockPrinter;
    }

    @Override
    public Printer<ElseBlock> elseBlockPrinter() {
        return this.elseBlockPrinter;
    }

    @Override
    public Printer<CatchBlock> catchBlockPrinter() {
        return this.catchBlockPrinter;
    }

    @Override
    public Printer<FinallyBlock> finallyBlockPrinter() {
        return this.finallyBlockPrinter;
    }

    @Override
    public Printer<ObjectCreator> objectCreatorPrinter() {
        return this.objectCreatorPrinter;
    }

    @Override
    public Printer<BinaryOp> binaryOpPrinter() {
        return BINARY_OP_PRINTER;
    }

    @Override
    public Printer<BooleanOp> booleanOpPrinter() {
        return BOOLEAN_OP_PRINTER;
    }

    @Override
    public Printer<PrefixOp> prefixOpPrinter() {
        return PREFIX_OP_PRINTER;
    }

    @Override
    public Printer<PostfixOp> postfixOpPrinter() {
        return POSTFIX_OP_PRINTER;
    }

    @Override
    public Printer<Literal> literalPrinter() {
        return LITERAL_PRINTER;
    }

    @Override
    public Printer<AssignmentOp> assignmentOpPrinter() {
        return ASSIGNMENT_OP_PRINTER;
    }

    @Override
    public Printer<UsingExpr> usingExprPrinter() {
        return USING_EXPR_PRINTER;
    }

    @Override
    public Printer<SoqlUsingClause> soqlUsingClausePrinter() {
        return SOQL_USING_PRINTER;
    }

    @Override
    public Printer<SoslWithClause> soslWithClausePrinter() {
        return this.soslWithPrinter;
    }
}

